/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.sta.dao.BaseDao;
import de.fraunhofer.iosb.ilt.sta.dao.ThingDao;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.model.HistoricalLocation;
import de.fraunhofer.iosb.ilt.sta.model.Location;
import de.fraunhofer.iosb.ilt.sta.model.MultiDatastream;
import de.fraunhofer.iosb.ilt.sta.model.TaskingCapability;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Thing
extends Entity<Thing> {
    private String name;
    private String description;
    private Map<String, Object> properties;
    private final EntityList<Location> locations = new EntityList(EntityType.LOCATIONS);
    private final EntityList<HistoricalLocation> historicalLocations = new EntityList(EntityType.HISTORICAL_LOCATIONS);
    private final EntityList<Datastream> datastreams = new EntityList(EntityType.DATASTREAMS);
    private final EntityList<MultiDatastream> multiDatastreams = new EntityList(EntityType.MULTIDATASTREAMS);
    private final EntityList<TaskingCapability> taskingCapabilities = new EntityList(EntityType.TASKING_CAPABILITIES);

    public Thing() {
        super(EntityType.THING);
    }

    public Thing(String name, String description) {
        this();
        this.name = name;
        this.description = description;
    }

    public Thing(String name, String description, Map<String, Object> properties) {
        this(name, description);
        this.properties = properties;
    }

    public Thing(String name, String description, Map<String, Object> properties, List<Location> locations, List<HistoricalLocation> historicalLocations, List<Datastream> datastreams) {
        this(name, description, properties);
        this.locations.addAll((Collection<Location>)locations);
        this.historicalLocations.addAll((Collection<HistoricalLocation>)historicalLocations);
        this.datastreams.addAll((Collection<Datastream>)datastreams);
    }

    @Override
    protected void ensureServiceOnChildren(SensorThingsService service) {
        this.locations.setService(service, Location.class);
        this.datastreams.setService(service, Datastream.class);
        this.multiDatastreams.setService(service, MultiDatastream.class);
        this.historicalLocations.setService(service, HistoricalLocation.class);
        if (this.taskingCapabilities != null) {
            this.taskingCapabilities.setService(service, TaskingCapability.class);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Thing other = (Thing)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!Objects.equals(this.properties, other.properties)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 97 * hash + Objects.hashCode(this.name);
        hash = 97 * hash + Objects.hashCode(this.description);
        hash = 97 * hash + Objects.hashCode(this.properties);
        return hash;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public BaseDao<Location> locations() {
        return this.getService().locations().setParent(this);
    }

    @JsonProperty(value="Locations")
    public EntityList<Location> getLocations() {
        return this.locations;
    }

    @JsonProperty(value="Locations")
    public void setLocations(List<Location> locations) {
        this.locations.replaceAll(locations);
    }

    public BaseDao<HistoricalLocation> historicalLocations() {
        return this.getService().historicalLocations().setParent(this);
    }

    @JsonProperty(value="HistoricalLocations")
    public EntityList<HistoricalLocation> getHistoricalLocations() {
        return this.historicalLocations;
    }

    @JsonProperty(value="HistoricalLocations")
    public void setHistoricalLocations(List<HistoricalLocation> historicalLocations) {
        this.historicalLocations.replaceAll(historicalLocations);
    }

    public BaseDao<Datastream> datastreams() {
        return this.getService().datastreams().setParent(this);
    }

    @JsonProperty(value="Datastreams")
    public EntityList<Datastream> getDatastreams() {
        return this.datastreams;
    }

    @JsonProperty(value="Datastreams")
    public void setDatastreams(List<Datastream> datastreams) {
        this.datastreams.replaceAll(datastreams);
    }

    public BaseDao<MultiDatastream> multiDatastreams() {
        return this.getService().multiDatastreams().setParent(this);
    }

    @JsonProperty(value="MultiDatastreams")
    public EntityList<MultiDatastream> getMultiDatastreams() {
        return this.multiDatastreams;
    }

    @JsonProperty(value="MultiDatastreams")
    public void setMultiDatastreams(List<MultiDatastream> multiDatastreams) {
        this.multiDatastreams.replaceAll(multiDatastreams);
    }

    public BaseDao<TaskingCapability> taskingCapabilities() {
        return this.getService().taskingCapabilities().setParent(this);
    }

    @JsonProperty(value="TaskingCapabilities")
    public EntityList<TaskingCapability> getTaskingCapabilities() {
        return this.taskingCapabilities;
    }

    @JsonProperty(value="TaskingCapabilities")
    public void setTaskingCapabilities(List<TaskingCapability> taskingCapabilities) {
        this.taskingCapabilities.replaceAll(taskingCapabilities);
    }

    public ThingDao getDao(SensorThingsService service) {
        return new ThingDao(service);
    }

    @Override
    public Thing withOnlyId() {
        Thing copy = new Thing();
        copy.setId(this.id);
        return copy;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.getName();
    }
}

