/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.model.builder.api;

import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.MultiDatastream;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.builder.api.EntityBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class AbstractSensorBuilder<U extends AbstractSensorBuilder<U>>
extends EntityBuilder<Sensor, U> {
    @Override
    protected Sensor newBuildingInstance() {
        return new Sensor();
    }

    public U name(String name) {
        ((Sensor)this.getBuildingInstance()).setName(name);
        return (U)((AbstractSensorBuilder)this.getSelf());
    }

    public U description(String description) {
        ((Sensor)this.getBuildingInstance()).setDescription(description);
        return (U)((AbstractSensorBuilder)this.getSelf());
    }

    public U encodingType(String encodingType) {
        ((Sensor)this.getBuildingInstance()).setEncodingType(encodingType);
        return (U)((AbstractSensorBuilder)this.getSelf());
    }

    public U encodingType(ValueCode encodingType) {
        ((Sensor)this.getBuildingInstance()).setEncodingType(encodingType.getValue());
        return (U)((AbstractSensorBuilder)this.getSelf());
    }

    public U metadata(Object metadata) {
        ((Sensor)this.getBuildingInstance()).setMetadata(metadata);
        return (U)((AbstractSensorBuilder)this.getSelf());
    }

    public U datastreams(List<Datastream> datastreams) {
        ((Sensor)this.getBuildingInstance()).getDatastreams().addAll((Collection<Datastream>)datastreams);
        return (U)((AbstractSensorBuilder)this.getSelf());
    }

    public U datastream(Datastream datastream) {
        ((Sensor)this.getBuildingInstance()).getDatastreams().add(datastream);
        return (U)((AbstractSensorBuilder)this.getSelf());
    }

    public U multiDatastreams(List<MultiDatastream> multiDatastreams) {
        ((Sensor)this.getBuildingInstance()).getMultiDatastreams().addAll((Collection<MultiDatastream>)multiDatastreams);
        return (U)((AbstractSensorBuilder)this.getSelf());
    }

    public U multiDatastream(MultiDatastream multiDatastream) {
        ((Sensor)this.getBuildingInstance()).getMultiDatastreams().add(multiDatastream);
        return (U)((AbstractSensorBuilder)this.getSelf());
    }

    public U properties(Map<String, Object> properties) {
        ((Sensor)this.getBuildingInstance()).setProperties(properties);
        return (U)((AbstractSensorBuilder)this.getSelf());
    }

    public U property(String key, Object value) {
        if (((Sensor)this.getBuildingInstance()).getProperties() == null) {
            ((Sensor)this.getBuildingInstance()).setProperties(new HashMap<String, Object>());
        }
        ((Sensor)this.getBuildingInstance()).getProperties().put(key, value);
        return (U)((AbstractSensorBuilder)this.getSelf());
    }

    public static enum ValueCode {
        PDF("application/pdf"),
        SensorML("http://www.opengis.net/doc/IS/SensorML/2.0");

        private final String value;

        private ValueCode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static ValueCode from(String value) {
            Optional<ValueCode> result = Stream.of(ValueCode.values()).filter(x -> x.value.equals(value)).findAny();
            if (!result.isPresent()) {
                throw new IllegalArgumentException("unkown value code '" + value + "'");
            }
            return result.get();
        }
    }
}

