/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.model.ext;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.fraunhofer.iosb.ilt.sta.StatusCodeException;
import de.fraunhofer.iosb.ilt.sta.Utils;
import de.fraunhofer.iosb.ilt.sta.jackson.ObjectMapperFactory;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityCollection;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityList<T extends Entity<T>>
implements EntityCollection<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)EntityList.class.getName());
    private final List<T> entities = new ArrayList<T>();
    private long count = -1L;
    private URI nextLink;
    private SensorThingsService service;
    private Class<T> entityClass;
    private final EntityType entityType;

    public EntityList(EntityType entityType) {
        if (!entityType.isList()) {
            LOGGER.warn("Trying to make a collection of a singular entity type {}, assuming the plural is wanted.", (Object)entityType);
            this.entityType = entityType.getPlural();
        } else {
            this.entityType = entityType;
        }
    }

    @Override
    public EntityType getType() {
        return this.entityType;
    }

    @Override
    public int size() {
        return this.entities.size();
    }

    @Override
    public boolean isEmpty() {
        return this.entities.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.entities.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.entities.iterator();
    }

    public Iterator<T> fullIterator() {
        return new Iterator<T>(){
            private Iterator<T> currentIterator;
            private URI nextLink;
            {
                this.currentIterator = EntityList.this.iterator();
                this.nextLink = EntityList.this.getNextLink();
            }

            private void fetchNextList() {
                EntityList nextList;
                if (this.nextLink == null) {
                    this.currentIterator = null;
                    return;
                }
                HttpGet httpGet = new HttpGet(this.nextLink);
                httpGet.addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
                LOGGER.debug("Fetching: {}", (Object)httpGet.getURI());
                try (CloseableHttpResponse response = EntityList.this.service.execute((HttpRequestBase)httpGet);){
                    Utils.throwIfNotOk((HttpRequestBase)httpGet, response);
                    String json = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
                    ObjectMapper mapper = ObjectMapperFactory.get();
                    nextList = (EntityList)mapper.readValue(json, EntityType.listForClass(EntityList.this.entityClass).getTypeReference());
                    nextList.setService(EntityList.this.service, EntityList.this.entityClass);
                }
                catch (IOException | ParseException exc) {
                    LOGGER.error("Failed deserializing collection.", exc);
                    this.currentIterator = null;
                    this.nextLink = null;
                    return;
                }
                catch (StatusCodeException exc) {
                    LOGGER.error("Failed follow nextlink: {} - '{}' - {}", new Object[]{exc.getStatusCode(), this.nextLink, Utils.cleanForLogging(exc.getReturnedContent(), 100)});
                    LOGGER.debug("Response: {}", (Object)exc.getReturnedContent());
                    this.currentIterator = null;
                    this.nextLink = null;
                    return;
                }
                this.currentIterator = nextList.iterator();
                this.nextLink = nextList.getNextLink();
            }

            @Override
            public boolean hasNext() {
                if (this.currentIterator == null) {
                    return false;
                }
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                this.fetchNextList();
                return this.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return (Entity)this.currentIterator.next();
            }
        };
    }

    @Override
    public boolean hasNextLink() {
        return this.nextLink != null;
    }

    @Override
    public void fetchNext() throws StatusCodeException {
        HttpGet httpGet = new HttpGet(this.nextLink);
        LOGGER.debug("Fetching: {}", (Object)httpGet.getURI());
        httpGet.addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        try (CloseableHttpResponse response = this.service.execute((HttpRequestBase)httpGet);){
            Utils.throwIfNotOk((HttpRequestBase)httpGet, response);
            String json = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
            ObjectMapper mapper = ObjectMapperFactory.get();
            EntityList nextList = (EntityList)mapper.readValue(json, EntityType.listForClass(this.entityClass).getTypeReference());
            nextList.setService(this.service, this.entityClass);
            this.clear();
            this.addAll(nextList);
            this.setNextLink(nextList.getNextLink());
        }
        catch (IOException ex) {
            LOGGER.error("Failed to fetch list.", (Throwable)ex);
        }
    }

    @Override
    public Object[] toArray() {
        return this.entities.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.entities.toArray(a);
    }

    @Override
    public boolean add(T e) {
        return this.entities.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.entities.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.entities.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.entities.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.entities.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.entities.retainAll(c);
    }

    public void replaceAll(Collection<T> other) {
        this.entities.clear();
        this.entities.addAll(other);
    }

    @Override
    public void clear() {
        this.entities.clear();
    }

    @Override
    public List<T> toList() {
        return this.entities;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public void setCount(long count) {
        this.count = count;
    }

    public URI getNextLink() {
        return this.nextLink;
    }

    public void setNextLink(URI nextLink) {
        this.nextLink = nextLink;
    }

    public void setService(SensorThingsService service, Class<T> entityClass) {
        this.service = service;
        this.entityClass = entityClass;
        for (Entity entity : this.entities) {
            entity.setService(service);
        }
    }
}

