/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.query;

import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.query.ExpandedEntity;
import de.fraunhofer.iosb.ilt.sta.query.InvalidRelationException;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class Expansion {
    private final Set<ExpandedEntity> entities = new HashSet<ExpandedEntity>();
    private final EntityType type;

    private Expansion(EntityType type) {
        this.type = type;
    }

    public static Expansion of(EntityType type) {
        return new Expansion(type);
    }

    public Expansion with(ExpandedEntity entity) throws InvalidRelationException {
        if (!this.type.hasRelationTo(entity.getDirectSibling())) {
            throw new InvalidRelationException(String.format("%s is not directly related to %s", this.type.getName(), entity.getDirectSibling().getName()));
        }
        this.entities.add(entity);
        return this;
    }

    public Expansion and(ExpandedEntity entity) throws InvalidRelationException {
        return this.with(entity);
    }

    public String toString() {
        return this.entities.stream().map(e -> e.toString()).collect(Collectors.joining(","));
    }
}

