/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonpatch.JsonPatchOperation;
import de.fraunhofer.iosb.ilt.sta.MqttException;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.StatusCodeException;
import de.fraunhofer.iosb.ilt.sta.Utils;
import de.fraunhofer.iosb.ilt.sta.dao.ActuatorDao;
import de.fraunhofer.iosb.ilt.sta.dao.DatastreamDao;
import de.fraunhofer.iosb.ilt.sta.dao.FeatureOfInterestDao;
import de.fraunhofer.iosb.ilt.sta.dao.HistoricalLocationDao;
import de.fraunhofer.iosb.ilt.sta.dao.LocationDao;
import de.fraunhofer.iosb.ilt.sta.dao.MultiDatastreamDao;
import de.fraunhofer.iosb.ilt.sta.dao.ObservationDao;
import de.fraunhofer.iosb.ilt.sta.dao.ObservedPropertyDao;
import de.fraunhofer.iosb.ilt.sta.dao.SensorDao;
import de.fraunhofer.iosb.ilt.sta.dao.TaskDao;
import de.fraunhofer.iosb.ilt.sta.dao.TaskingCapabilityDao;
import de.fraunhofer.iosb.ilt.sta.dao.ThingDao;
import de.fraunhofer.iosb.ilt.sta.jackson.ObjectMapperFactory;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.model.ext.DataArrayDocument;
import de.fraunhofer.iosb.ilt.sta.service.MqttConfig;
import de.fraunhofer.iosb.ilt.sta.service.MqttSubscription;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsAPIVersion;
import de.fraunhofer.iosb.ilt.sta.service.ServerSettings;
import de.fraunhofer.iosb.ilt.sta.service.TokenManager;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.ParseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorThingsService
implements MqttCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(SensorThingsService.class);
    private URL endpoint;
    private String urlReplace;
    private HttpClientBuilder clientBuilder;
    private CloseableHttpClient httpClient;
    private TokenManager tokenManager;
    private MqttClient mqttClient;
    private MqttConfig mqttConfig;
    private Map<String, Set<Consumer<MqttMessage>>> mqttSubscriptions = new HashMap<String, Set<Consumer<MqttMessage>>>();
    private SensorThingsAPIVersion version;
    private int requestTimeoutMs = 120000;

    public SensorThingsService() {
    }

    public SensorThingsService(URI endpoint) throws MalformedURLException {
        this(endpoint.toURL());
    }

    public SensorThingsService(URL endpoint) throws MalformedURLException {
        this.setEndpoint(endpoint);
    }

    public SensorThingsService(URL endpoint, MqttConfig mqttConfig) throws MalformedURLException, MqttException {
        this(endpoint);
        this.mqttConfig = mqttConfig;
        try {
            this.mqttClient = new MqttClient(mqttConfig.getServerUri(), mqttConfig.getClientId(), mqttConfig.getPersistence());
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException exc) {
            throw new MqttException("could not create MQTT client", exc);
        }
        this.mqttClient.setCallback((MqttCallback)this);
    }

    public final void setEndpoint(URI endpoint) throws MalformedURLException {
        this.setEndpoint(endpoint.toURL());
    }

    public final void setEndpoint(URL endpoint) throws MalformedURLException {
        if (this.endpoint != null) {
            throw new IllegalStateException("endpoint URL already set.");
        }
        String url = StringUtils.removeEnd((String)endpoint.toString(), (String)"/");
        String lastSegment = url.substring(url.lastIndexOf(47) + 1);
        SensorThingsAPIVersion detectedVersion = SensorThingsAPIVersion.fromString(lastSegment);
        if (detectedVersion != null) {
            this.version = detectedVersion;
        } else {
            if (this.getVersion() == null) {
                throw new MalformedURLException("endpoint URL does not contain version (e.g. http://example.org/v1.0/) nor version information explicitely provided");
            }
            url = url + "/" + this.getVersion().getUrlPattern();
        }
        this.cleanupMqtt();
        this.mqttConfig = null;
        this.endpoint = new URL(url + "/");
    }

    public final void setUrlReplace(String urlReplace) {
        this.urlReplace = urlReplace;
    }

    public URL getEndpoint() {
        if (this.endpoint == null) {
            throw new IllegalStateException("endpoint URL not set.");
        }
        return this.endpoint;
    }

    public boolean isEndpointSet() {
        return this.endpoint != null;
    }

    public String getPath(Entity<?> parent, EntityType relation) {
        if (parent == null) {
            return relation.getName();
        }
        if (!parent.getType().hasRelationTo(relation)) {
            throw new IllegalArgumentException("Entity of type " + (Object)((Object)parent.getType()) + " has no relation of type " + (Object)((Object)relation) + ".");
        }
        if (parent.getId() == null) {
            throw new IllegalArgumentException("Can not create a path with a parent without id.");
        }
        return String.format("%s(%s)/%s", EntityType.listForClass(parent.getClass()).getName(), parent.getId().getUrl(), relation.getName());
    }

    public String getMqttPath(Entity<?> parent, EntityType relation) {
        if (parent == null) {
            return relation.getName();
        }
        if (!parent.getType().hasRelationTo(relation)) {
            throw new IllegalArgumentException("Entity of type " + (Object)((Object)parent.getType()) + " has no relation of type " + (Object)((Object)relation) + ".");
        }
        if (parent.getId() == null) {
            throw new IllegalArgumentException("Can not create a path with a parent without id.");
        }
        return String.format("%s(%s)/%s", EntityType.listForClass(parent.getClass()).getName(), parent.getId().getUrl(), relation.getName());
    }

    public URL getFullPath(Entity<?> parent, EntityType relation) throws ServiceFailureException {
        try {
            return new URL(this.getEndpoint().toString() + this.getPath(parent, relation));
        }
        catch (MalformedURLException exc) {
            LOGGER.error("Failed to generate URL.", (Throwable)exc);
            throw new ServiceFailureException(exc);
        }
    }

    public CloseableHttpResponse execute(HttpRequestBase request) throws IOException {
        String urlString = request.getURI().toString();
        if (this.urlReplace != null && urlString.startsWith(this.urlReplace)) {
            String newUrlString = this.endpoint.toString() + urlString.substring(this.urlReplace.length());
            LOGGER.debug("   Fixed: {}", (Object)newUrlString);
            try {
                request.setURI(new URI(newUrlString));
            }
            catch (URISyntaxException ex) {
                throw new IOException("Failed to replace start of URL", ex);
            }
        }
        CloseableHttpClient client = this.getHttpClient();
        this.setTimeouts(request);
        if (this.tokenManager != null) {
            this.tokenManager.addAuthHeader((HttpRequest)request);
        }
        return client.execute((HttpUriRequest)request);
    }

    private void setTimeouts(HttpRequestBase request) {
        RequestConfig.Builder configBuilder = request.getConfig() == null ? RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT) : RequestConfig.copy((RequestConfig)request.getConfig());
        RequestConfig config = configBuilder.setSocketTimeout(this.requestTimeoutMs).setConnectTimeout(this.requestTimeoutMs).setConnectionRequestTimeout(this.requestTimeoutMs).build();
        request.setConfig(config);
    }

    public DatastreamDao datastreams() {
        return new DatastreamDao(this);
    }

    public MultiDatastreamDao multiDatastreams() {
        return new MultiDatastreamDao(this);
    }

    public FeatureOfInterestDao featuresOfInterest() {
        return new FeatureOfInterestDao(this);
    }

    public HistoricalLocationDao historicalLocations() {
        return new HistoricalLocationDao(this);
    }

    public LocationDao locations() {
        return new LocationDao(this);
    }

    public ObservationDao observations() {
        return new ObservationDao(this);
    }

    public ObservedPropertyDao observedProperties() {
        return new ObservedPropertyDao(this);
    }

    public SensorDao sensors() {
        return new SensorDao(this);
    }

    public ThingDao things() {
        return new ThingDao(this);
    }

    public ActuatorDao actuators() {
        return new ActuatorDao(this);
    }

    public TaskDao tasks() {
        return new TaskDao(this);
    }

    public TaskingCapabilityDao taskingCapabilities() {
        return new TaskingCapabilityDao(this);
    }

    public List<String> create(DataArrayDocument dataArray) throws ServiceFailureException {
        return new ObservationDao(this).create(dataArray);
    }

    public <T extends Entity<T>> void create(T entity) throws ServiceFailureException {
        entity.getDao(this).create(entity);
    }

    public <T extends Entity<T>> void update(T entity) throws ServiceFailureException {
        entity.getDao(this).update(entity);
    }

    public <T extends Entity<T>> void patch(T entity, List<JsonPatchOperation> patch) throws ServiceFailureException {
        entity.getDao(this).patch(entity, patch);
    }

    public <T extends Entity<T>> void delete(T entity) throws ServiceFailureException {
        entity.getDao(this).delete(entity);
    }

    public SensorThingsService setTokenManager(TokenManager tokenManager) {
        if (tokenManager != null && this.httpClient != null) {
            tokenManager.setHttpClient(this.httpClient);
        }
        this.tokenManager = tokenManager;
        return this;
    }

    public TokenManager getTokenManager() {
        return this.tokenManager;
    }

    public CloseableHttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = this.getClientBuilder().build();
            if (this.tokenManager != null) {
                this.tokenManager.setHttpClient(this.httpClient);
            }
        }
        return this.httpClient;
    }

    @Deprecated
    public void setHttpClient(CloseableHttpClient httpClient) {
        LOGGER.warn("Avoid using setHttpClient!");
        this.httpClient = httpClient;
    }

    public HttpClientBuilder getClientBuilder() {
        if (this.clientBuilder == null) {
            this.clientBuilder = HttpClients.custom().useSystemProperties();
        }
        return this.clientBuilder;
    }

    public void rebuildHttpClient() {
        this.httpClient = null;
    }

    public void connectionLost(Throwable e) {
        LOGGER.warn("MQTT connection lost", e);
    }

    public <T> MqttSubscription subscribe(String topic, Consumer<T> handler, Class<T> returnType, Predicate<T> filter) throws MqttException {
        Consumer<MqttMessage> typedHandler = x -> {
            try {
                Object entity = ObjectMapperFactory.get().readValue(x.getPayload(), returnType);
                if (filter == null || filter.test(entity)) {
                    handler.accept(entity);
                }
            }
            catch (Exception exc) {
                LOGGER.warn("could not parse payload received via MQTT");
            }
        };
        this.subscribe(topic, typedHandler);
        return new MqttSubscription(topic, typedHandler);
    }

    public MqttSubscription subscribe(String topic, Consumer<MqttMessage> handler) throws MqttException {
        this.checkMqttConfigured();
        if (!this.mqttSubscriptions.containsKey(topic)) {
            this.mqttSubscriptions.put(topic, new HashSet());
        }
        if (this.mqttSubscriptions.get(topic).add(handler) && this.mqttSubscriptions.get(topic).size() == 1) {
            this.checkMqttConnected();
            try {
                this.mqttClient.subscribe(topic);
            }
            catch (org.eclipse.paho.client.mqttv3.MqttException exc) {
                throw new MqttException(String.format("subscribing topic '%s' failed", topic), exc);
            }
        }
        return new MqttSubscription(topic, handler);
    }

    public void publish(String topic, Entity entity) throws MqttException {
        this.checkMqttConfigured();
        this.checkMqttConnected();
        try {
            this.mqttClient.publish(topic, new MqttMessage(ObjectMapperFactory.get().writeValueAsBytes((Object)entity)));
        }
        catch (JsonProcessingException ex) {
            throw new MqttException("Could not process JSON", ex);
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException ex) {
            throw new MqttException("Error publishing via MQTT", ex);
        }
    }

    private void checkMqttConnected() throws MqttException {
        if (this.mqttClient.isConnected()) {
            return;
        }
        try {
            this.mqttClient.connect(this.mqttConfig.getOptions());
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException exc) {
            throw new MqttException("MQTT connection failed", exc);
        }
    }

    private void checkMqttConfigured() throws MqttException {
        if (this.mqttClient == null) {
            if (this.mqttConfig == null) {
                LOGGER.info("trying to auto-configure MQTT connection");
                this.mqttConfig = this.getRemoteConfig();
            }
            if (this.mqttConfig == null) {
                throw new MqttException("you must configure MQTT to use this feature");
            }
            try {
                this.mqttClient = new MqttClient(this.mqttConfig.getServerUri(), this.mqttConfig.getClientId(), this.mqttConfig.getPersistence());
            }
            catch (org.eclipse.paho.client.mqttv3.MqttException exc) {
                throw new MqttException("could not create MQTT client", exc);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MqttConfig getRemoteConfig() {
        HttpGet httpGet;
        try {
            LOGGER.debug("Fetching: {}", (Object)this.getEndpoint().toURI());
            httpGet = new HttpGet(this.getEndpoint().toURI());
            httpGet.addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        }
        catch (URISyntaxException ex) {
            LOGGER.error("Failed to get MQTT configuration.", (Throwable)ex);
            return null;
        }
        try (CloseableHttpResponse response = this.execute((HttpRequestBase)httpGet);){
            Utils.throwIfNotOk((HttpRequestBase)httpGet, response);
            String returnContent = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
            ObjectMapper mapper = ObjectMapperFactory.get();
            JsonNode root = mapper.readTree(returnContent);
            if (!root.has("serverSettings")) return null;
            ServerSettings serverSettings = (ServerSettings)mapper.treeToValue((TreeNode)root.get("serverSettings"), ServerSettings.class);
            MqttConfig mqttConfig = new MqttConfig((String)((List)serverSettings.getExtensions().get((Object)ServerSettings.Extension.MQTT).get("endpoints")).get(0));
            return mqttConfig;
        }
        catch (IOException | ParseException ex) {
            LOGGER.error("Failed to get MQTT configuration.", ex);
            return null;
        }
        catch (StatusCodeException ex) {
            LOGGER.error("Failed to get MQTT configuration: {} - {}", new Object[]{ex.getStatusCode(), Utils.cleanForLogging(ex.getReturnedContent()), ex});
        }
        return null;
    }

    public void unsubscribe(MqttSubscription subscription) throws MqttException {
        this.unsubscribe(subscription.getTopic(), subscription.getHandler());
    }

    public void unsubscribe(String topic, Consumer<MqttMessage> handler) throws MqttException {
        this.checkMqttConfigured();
        if (this.mqttSubscriptions.containsKey(topic)) {
            if (this.mqttSubscriptions.get(topic).size() == 1 && this.mqttSubscriptions.get(topic).contains(handler)) {
                this.unsubscribeMqtt(topic);
            }
            this.mqttSubscriptions.get(topic).remove(handler);
            this.cleanupMqttSubscriptions();
        }
    }

    private void cleanupMqttSubscriptions() throws MqttException {
        this.mqttSubscriptions.entrySet().removeIf(x -> ((Set)x.getValue()).isEmpty());
    }

    private void unsubscribeMqtt(String topic) throws MqttException {
        try {
            this.mqttClient.unsubscribe(topic);
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException exc) {
            throw new MqttException(String.format("could not unsubscribe from MQTT '%s'", topic), exc);
        }
        try {
            if (this.mqttSubscriptions.isEmpty()) {
                this.mqttClient.disconnect();
            }
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException exc) {
            LOGGER.info("error closing MQTT connection", (Throwable)exc);
        }
    }

    public void unsubscribe(String topic) throws MqttException {
        if (this.mqttSubscriptions.containsKey(topic)) {
            this.unsubscribeMqtt(topic);
            this.mqttSubscriptions.get(topic).clear();
            this.cleanupMqttSubscriptions();
        }
    }

    private void cleanupMqtt() {
        this.mqttSubscriptions.forEach((x, y) -> {
            try {
                this.unsubscribe((String)x);
            }
            catch (MqttException exc) {
                LOGGER.warn("error unsubscribing from MQTT", (Throwable)exc);
            }
        });
        if (this.mqttClient != null) {
            try {
                this.mqttClient.close(true);
            }
            catch (org.eclipse.paho.client.mqttv3.MqttException ex) {
                LOGGER.warn("error closing MQTT conection");
            }
        }
        this.mqttClient = null;
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        if (this.mqttSubscriptions.containsKey(topic)) {
            this.mqttSubscriptions.get(topic).forEach(x -> x.accept(message));
        }
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
        LOGGER.trace("Publish completed.");
    }

    public SensorThingsAPIVersion getVersion() {
        return this.version;
    }
}

