/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.fraunhofer.iosb.ilt.sta.service.TokenManager;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenManagerOpenIDConnect
implements TokenManager<TokenManagerOpenIDConnect> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenManagerOpenIDConnect.class);
    private String tokenServerUrl;
    private String clientId;
    private String userName;
    private String password;
    private CloseableHttpClient client;
    private String accessToken = "";
    private String refreshToken = "";
    private String keyType;
    private byte[] apiKeyBytes;
    private int expireDuration = 300;
    private Calendar expireTime = Calendar.getInstance();
    private int refreshExpireDuration = 1800;
    private Calendar refreshExpireTime = Calendar.getInstance();
    private boolean autoRefresh;
    private Timer timer;
    private TimerTask refreshTask;

    @Override
    public void addAuthHeader(HttpRequest request) {
        request.addHeader("Authorization", "Bearer " + this.getToken());
    }

    public boolean isExpired() {
        return this.expireTime.before(Calendar.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fetchTokenUsingPassword() {
        String json = null;
        CloseableHttpResponse response = null;
        try {
            HttpPost tokenRequest = new HttpPost(this.tokenServerUrl);
            ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("grant_type", "password"));
            parameters.add(new BasicNameValuePair("client_id", this.clientId));
            parameters.add(new BasicNameValuePair("username", this.userName));
            parameters.add(new BasicNameValuePair("password", this.password));
            tokenRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
            response = this.client.execute((HttpUriRequest)tokenRequest);
            json = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to fetch Token.", (Throwable)ex);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException ex2) {
                    LOGGER.error("Exception closing response after exception!", (Throwable)ex2);
                }
            }
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fetchTokenUsingRefreshToken() {
        String json = null;
        CloseableHttpResponse response = null;
        try {
            HttpPost tokenRequest = new HttpPost(this.tokenServerUrl);
            ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("grant_type", "refresh_token"));
            parameters.add(new BasicNameValuePair("refresh_token", this.refreshToken));
            tokenRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
            response = this.client.execute((HttpUriRequest)tokenRequest);
            json = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to fetch Token.", (Throwable)ex);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException ex2) {
                    LOGGER.error("Exception closing response after exception!", (Throwable)ex2);
                }
            }
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToken() {
        String currentToken = this.accessToken;
        if (!currentToken.isEmpty() && !this.isExpired()) {
            return currentToken;
        }
        TokenManagerOpenIDConnect tokenManagerOpenIDConnect = this;
        synchronized (tokenManagerOpenIDConnect) {
            this.accessToken = "";
            String json = null;
            if (!this.refreshToken.isEmpty()) {
                json = this.fetchTokenUsingRefreshToken();
            }
            if (json == null) {
                json = this.fetchTokenUsingPassword();
            }
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode tree = objectMapper.readTree(json);
                if (tree.isObject()) {
                    JsonNode node = tree.get("access_token");
                    if (node == null) {
                        throw new IllegalStateException("Did not receive an access_token. Received: " + json);
                    }
                    this.accessToken = node.textValue();
                    this.validateToken(this.accessToken);
                    this.refreshToken = tree.get("refresh_token").textValue();
                    this.validateToken(this.refreshToken);
                    node = tree.get("expires_in");
                    if (node.isNumber() && node.canConvertToInt()) {
                        this.expireDuration = node.intValue();
                    }
                    this.expireTime = Calendar.getInstance();
                    this.expireTime.add(13, Math.max(this.expireDuration - 10, 10));
                    node = tree.get("refresh_expires_in");
                    if (node.isNumber() && node.canConvertToInt()) {
                        this.refreshExpireDuration = node.intValue();
                    }
                    this.checkAutoRefreshTimer();
                }
                LOGGER.debug("Token: {}", (Object)this.accessToken);
                LOGGER.debug("RefreshToken: {}", (Object)this.refreshToken);
                return this.accessToken;
            }
            catch (IOException ex) {
                LOGGER.error("Failed to parse response.", (Throwable)ex);
                return null;
            }
        }
    }

    private void checkAutoRefreshTimer() {
        if (!this.autoRefresh) {
            return;
        }
        if (this.timer == null) {
            this.timer = new Timer("Autorefresh", true);
        }
        Calendar targetTime = Calendar.getInstance();
        targetTime.add(13, Math.max(this.refreshExpireDuration - 20, 20));
        if (this.refreshExpireTime.before(targetTime)) {
            this.refreshTask.cancel();
            this.refreshTask = null;
            this.refreshExpireTime = targetTime;
        }
        if (this.refreshTask == null) {
            this.refreshTask = new TimerTask(){

                @Override
                public void run() {
                    TokenManagerOpenIDConnect.this.autoRefresh();
                }
            };
            this.timer.schedule(this.refreshTask, targetTime.getTime());
        }
    }

    private void autoRefresh() {
        LOGGER.info("Auto-Refreshing the token.");
        this.getToken();
    }

    public boolean validateToken(String token) {
        try {
            if (Jwts.parser().isSigned(token)) {
                if (this.keyType != null) {
                    X509EncodedKeySpec spec = new X509EncodedKeySpec(this.apiKeyBytes);
                    KeyFactory fact = KeyFactory.getInstance(this.keyType);
                    PublicKey key = fact.generatePublic(spec);
                    Jwts.parser().setSigningKey((Key)key).parse(token);
                } else if (this.apiKeyBytes != null) {
                    Jwts.parser().setSigningKey(this.apiKeyBytes).parse(token);
                } else {
                    LOGGER.debug("Can not validate token, please set the signing key.");
                }
            } else {
                Jwts.parser().parse(token);
            }
            return true;
        }
        catch (SignatureException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            LOGGER.error("Token failed signature!", e);
            return false;
        }
    }

    @Override
    public TokenManagerOpenIDConnect setHttpClient(CloseableHttpClient client) {
        this.client = client;
        return this;
    }

    @Override
    public CloseableHttpClient getHttpClient() {
        return this.client;
    }

    public TokenManagerOpenIDConnect setTokenServerUrl(String tokenServerUrl) {
        this.tokenServerUrl = tokenServerUrl;
        return this;
    }

    public TokenManagerOpenIDConnect setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public TokenManagerOpenIDConnect setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public TokenManagerOpenIDConnect setPassword(String password) {
        this.password = password;
        return this;
    }

    public TokenManagerOpenIDConnect setSigningKey(String signingKey) {
        this.apiKeyBytes = DatatypeConverter.parseBase64Binary((String)signingKey);
        return this;
    }

    public TokenManagerOpenIDConnect setKeyType(String keyType) {
        this.keyType = keyType;
        return this;
    }

    public TokenManagerOpenIDConnect setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    public TokenManagerOpenIDConnect setRefreshExpireDuration(int refreshExpireDuration) {
        this.refreshExpireDuration = refreshExpireDuration;
        return this;
    }

    public TokenManagerOpenIDConnect setAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
        return this;
    }
}

