/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotation;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlAnnotation;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlDocument;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CsdlPropertyNavigation
implements CsdlProperty {
    @JsonProperty(value="$Kind")
    public String kind = "NavigationProperty";
    @JsonProperty(value="$Collection")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Boolean collection;
    @JsonProperty(value="$Partner")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String partner;
    @JsonProperty(value="$Type")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String type;
    @JsonProperty(value="$Nullable")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Boolean nullable;
    @JsonIgnore
    private final List<CsdlAnnotation> annotations = new ArrayList<CsdlAnnotation>();

    public CsdlPropertyNavigation generateFrom(CsdlDocument doc, String nameSpace, EntityType et, NavigationPropertyMain<?> np) {
        this.type = nameSpace + "." + np.getType().getName();
        NavigationPropertyMain inverse = np.getInverse();
        if (inverse != null) {
            this.partner = inverse.getName();
        }
        if (np.isEntitySet()) {
            this.collection = true;
        }
        this.nullable = np.isNullable();
        for (Annotation an : np.getAnnotations()) {
            this.annotations.add(new CsdlAnnotation().generateFrom(doc, an));
        }
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> otherProperties() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (CsdlAnnotation annotation : this.annotations) {
            result.put("@" + annotation.getQualifiedName(), annotation.getValue());
        }
        return result;
    }

    @Override
    public void writeXml(String nameSpace, String name, Writer writer) throws IOException {
        Object finalType = this.type;
        if (this.collection != null && this.collection.booleanValue()) {
            finalType = "Collection(" + this.type + ")";
        }
        Object nullableString = "";
        if (this.nullable != null && this.nullable.booleanValue()) {
            nullableString = " Nullable=\"" + Boolean.toString(this.nullable) + "\"";
        }
        Object partnerString = "";
        if (!StringHelper.isNullOrEmpty((String)this.partner)) {
            partnerString = " Partner=\"" + this.partner + "\"";
        }
        writer.write("<NavigationProperty Name=\"" + name + "\" Type=\"" + (String)finalType + "\"" + (String)nullableString + (String)partnerString);
        if (this.annotations.isEmpty()) {
            writer.write(" />");
        } else {
            writer.write(">");
            for (CsdlAnnotation an : this.annotations) {
                an.writeXml(writer);
            }
            writer.write("</NavigationProperty>");
        }
    }
}

