/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlDocument;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlItemComplexType;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlItemEntityContainer;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlItemEntityType;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlItemEnumType;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlItemTypeDefinition;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlSchemaItem;
import de.fraunhofer.iosb.ilt.frostserver.property.type.PropertyType;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeComplex;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeEnumeration;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeSimpleCustom;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsdlSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CsdlSchema.class.getName());
    @JsonAnyGetter
    @JsonAnySetter
    public Map<String, CsdlSchemaItem> schemaItems = new LinkedHashMap<String, CsdlSchemaItem>();

    public CsdlSchema generateFrom(CsdlDocument doc, Version version, String nameSpace, CoreSettings settings) {
        ModelRegistry mr = settings.getModelRegistry();
        for (EntityType entityType : mr.getEntityTypes()) {
            this.schemaItems.put(entityType.entityName, new CsdlItemEntityType().generateFrom(doc, version, nameSpace, entityType));
        }
        for (Map.Entry entry : mr.getPropertyTypes().entrySet()) {
            TypeComplex tc;
            String name = (String)entry.getKey();
            PropertyType value = (PropertyType)entry.getValue();
            if (value instanceof TypeComplex) {
                tc = (TypeComplex)value;
                this.schemaItems.put(name, new CsdlItemComplexType().generateFrom(doc, nameSpace, tc));
                continue;
            }
            if (value instanceof TypeSimpleCustom) {
                tc = (TypeSimpleCustom)value;
                this.schemaItems.put(name, new CsdlItemTypeDefinition().generateFrom((TypeSimpleCustom)tc));
                continue;
            }
            if (value instanceof TypeEnumeration) {
                TypeEnumeration te = (TypeEnumeration)value;
                this.schemaItems.put(name, new CsdlItemEnumType().generateFrom(te));
                continue;
            }
            LOGGER.debug("Unknown PropertyType {}", (Object)value);
        }
        this.schemaItems.put("FrostService", new CsdlItemEntityContainer().generateFrom(nameSpace, settings));
        return this;
    }

    public void writeXml(String nameSpace, Writer writer) throws IOException {
        writer.write("<Schema Namespace=\"" + nameSpace + "\" xmlns=\"http://docs.oasis-open.org/odata/ns/edm\">");
        for (Map.Entry<String, CsdlSchemaItem> entry : this.schemaItems.entrySet()) {
            String name = entry.getKey();
            CsdlSchemaItem item = entry.getValue();
            item.writeXml(nameSpace, name, writer);
        }
        writer.write("</Schema>");
    }
}

