/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.odata.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.EntitySerializer;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.serialize.EntityWrapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityWrapperSerializer
extends JsonSerializer<EntityWrapper> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)EntityWrapperSerializer.class.getName());
    private final EntitySerializer innerSerialiser;
    private final String contextField;

    public EntityWrapperSerializer(String contextField, String countField, String navLinkField, String nextLinkField, String selfLinkField) {
        this.contextField = contextField;
        this.innerSerialiser = new EntitySerializer(true, countField, navLinkField, nextLinkField, selfLinkField);
    }

    public void serialize(EntityWrapper wrapper, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        try {
            gen.writeStringField(this.contextField, wrapper.getContext());
            this.innerSerialiser.writeContent(wrapper.getEntity(), gen);
        }
        catch (IOException | RuntimeException exc) {
            LOGGER.error("Failed to serialise entity.", (Throwable)exc);
            throw new IOException("could not serialize Entity");
        }
        finally {
            gen.writeEndObject();
        }
    }
}

