/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util;

import java.time.ZoneOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Constants {
    public static final ZoneOffset UTC = ZoneOffset.UTC;
    public static final String[] HTTP_URL_PATTERNS = new String[]{"/v1.0", "/v1.0/*", "/v1.1", "/v1.1/*"};
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Constants.class.getName());

    private Constants() {
    }

    public static <T> T throwIfNullOrTypeNot(Object entity, Class<T> targetClass) {
        if (entity == null || !targetClass.isAssignableFrom(entity.getClass())) {
            throw new IllegalArgumentException("Expected " + targetClass + " got " + entity);
        }
        return (T)entity;
    }

    public static <T> T throwIfTypeNot(Object entity, Class<T> targetClass) {
        if (entity != null && !targetClass.isAssignableFrom(entity.getClass())) {
            LOGGER.error("Expected {}, but got {}", targetClass, entity);
            throw new IllegalArgumentException("Expected " + targetClass + " got " + entity);
        }
        return (T)entity;
    }
}

