/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker.subscriptions;

import io.moquette.broker.subscriptions.CNode;
import io.moquette.broker.subscriptions.DumpTreeVisitor;
import io.moquette.broker.subscriptions.INode;
import io.moquette.broker.subscriptions.Subscription;
import io.moquette.broker.subscriptions.SubscriptionCounterVisitor;
import io.moquette.broker.subscriptions.TNode;
import io.moquette.broker.subscriptions.Token;
import io.moquette.broker.subscriptions.Topic;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class CTrie {
    private static final Token ROOT = new Token("root");
    private static final INode NO_PARENT = null;
    INode root;

    CTrie() {
        CNode mainNode = new CNode();
        mainNode.setToken(ROOT);
        this.root = new INode(mainNode);
    }

    Optional<CNode> lookup(Topic topic) {
        INode inode = this.root;
        Token token = topic.headToken();
        while (!topic.isEmpty() && inode.mainNode().anyChildrenMatch(token)) {
            topic = topic.exceptHeadToken();
            inode = inode.mainNode().childOf(token);
            token = topic.headToken();
        }
        if (inode == null || !topic.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(inode.mainNode());
    }

    private NavigationAction evaluate(Topic topic, CNode cnode) {
        if (Token.MULTI.equals(cnode.getToken())) {
            return NavigationAction.MATCH;
        }
        if (topic.isEmpty()) {
            return NavigationAction.STOP;
        }
        Token token = topic.headToken();
        if (!(Token.SINGLE.equals(cnode.getToken()) || cnode.getToken().equals(token) || ROOT.equals(cnode.getToken()))) {
            return NavigationAction.STOP;
        }
        return NavigationAction.GODEEP;
    }

    public Set<Subscription> recursiveMatch(Topic topic) {
        return this.recursiveMatch(topic, this.root);
    }

    private Set<Subscription> recursiveMatch(Topic topic, INode inode) {
        CNode cnode = inode.mainNode();
        if (cnode instanceof TNode) {
            return Collections.emptySet();
        }
        NavigationAction action = this.evaluate(topic, cnode);
        if (action == NavigationAction.MATCH) {
            return cnode.subscriptions;
        }
        if (action == NavigationAction.STOP) {
            return Collections.emptySet();
        }
        Topic remainingTopic = ROOT.equals(cnode.getToken()) ? topic : topic.exceptHeadToken();
        HashSet<Subscription> subscriptions = new HashSet<Subscription>();
        if (remainingTopic.isEmpty()) {
            subscriptions.addAll(cnode.subscriptions);
        }
        for (INode subInode : cnode.allChildren()) {
            subscriptions.addAll(this.recursiveMatch(remainingTopic, subInode));
        }
        return subscriptions;
    }

    public void addToTree(Subscription newSubscription) {
        Action res;
        while ((res = this.insert(newSubscription.topicFilter, this.root, newSubscription)) == Action.REPEAT) {
        }
    }

    private Action insert(Topic topic, INode inode, Subscription newSubscription) {
        Token token = topic.headToken();
        if (!topic.isEmpty() && inode.mainNode().anyChildrenMatch(token)) {
            Topic remainingTopic = topic.exceptHeadToken();
            INode nextInode = inode.mainNode().childOf(token);
            return this.insert(remainingTopic, nextInode, newSubscription);
        }
        if (topic.isEmpty()) {
            return this.insertSubscription(inode, newSubscription);
        }
        return this.createNodeAndInsertSubscription(topic, inode, newSubscription);
    }

    private Action insertSubscription(INode inode, Subscription newSubscription) {
        CNode updatedCnode;
        CNode cnode = inode.mainNode();
        if (inode.compareAndSet(cnode, updatedCnode = cnode.copy().addSubscription(newSubscription))) {
            return Action.OK;
        }
        return Action.REPEAT;
    }

    private Action createNodeAndInsertSubscription(Topic topic, INode inode, Subscription newSubscription) {
        INode newInode = this.createPathRec(topic, newSubscription);
        CNode cnode = inode.mainNode();
        CNode updatedCnode = cnode.copy();
        updatedCnode.add(newInode);
        return inode.compareAndSet(cnode, updatedCnode) ? Action.OK : Action.REPEAT;
    }

    private INode createPathRec(Topic topic, Subscription newSubscription) {
        Topic remainingTopic = topic.exceptHeadToken();
        if (!remainingTopic.isEmpty()) {
            INode inode = this.createPathRec(remainingTopic, newSubscription);
            CNode cnode = new CNode();
            cnode.setToken(topic.headToken());
            cnode.add(inode);
            return new INode(cnode);
        }
        return this.createLeafNodes(topic.headToken(), newSubscription);
    }

    private INode createLeafNodes(Token token, Subscription newSubscription) {
        CNode newLeafCnode = new CNode();
        newLeafCnode.setToken(token);
        newLeafCnode.addSubscription(newSubscription);
        return new INode(newLeafCnode);
    }

    public void removeFromTree(Topic topic, String clientID) {
        Action res;
        while ((res = this.remove(clientID, topic, this.root, NO_PARENT)) == Action.REPEAT) {
        }
    }

    private Action remove(String clientId, Topic topic, INode inode, INode iParent) {
        Token token = topic.headToken();
        if (!topic.isEmpty() && inode.mainNode().anyChildrenMatch(token)) {
            Topic remainingTopic = topic.exceptHeadToken();
            INode nextInode = inode.mainNode().childOf(token);
            return this.remove(clientId, remainingTopic, nextInode, inode);
        }
        CNode cnode = inode.mainNode();
        if (cnode instanceof TNode) {
            return Action.OK;
        }
        if (cnode.containsOnly(clientId) && topic.isEmpty() && cnode.allChildren().isEmpty()) {
            if (inode == this.root) {
                return inode.compareAndSet(cnode, inode.mainNode().copy()) ? Action.OK : Action.REPEAT;
            }
            TNode tnode = new TNode();
            return inode.compareAndSet(cnode, tnode) ? this.cleanTomb(inode, iParent) : Action.REPEAT;
        }
        if (cnode.contains(clientId) && topic.isEmpty()) {
            CNode updatedCnode = cnode.copy();
            updatedCnode.removeSubscriptionsFor(clientId);
            return inode.compareAndSet(cnode, updatedCnode) ? Action.OK : Action.REPEAT;
        }
        return Action.OK;
    }

    private Action cleanTomb(INode inode, INode iParent) {
        CNode updatedCnode = iParent.mainNode().copy();
        updatedCnode.remove(inode);
        return iParent.compareAndSet(iParent.mainNode(), updatedCnode) ? Action.OK : Action.REPEAT;
    }

    public int size() {
        SubscriptionCounterVisitor visitor = new SubscriptionCounterVisitor();
        this.dfsVisit(this.root, visitor, 0);
        return visitor.getResult();
    }

    public String dumpTree() {
        DumpTreeVisitor visitor = new DumpTreeVisitor();
        this.dfsVisit(this.root, visitor, 0);
        return visitor.getResult();
    }

    private void dfsVisit(INode node, IVisitor<?> visitor, int deep) {
        if (node == null) {
            return;
        }
        visitor.visit(node.mainNode(), deep);
        ++deep;
        for (INode child : node.mainNode().allChildren()) {
            this.dfsVisit(child, visitor, deep);
        }
    }

    static enum NavigationAction {
        MATCH,
        GODEEP,
        STOP;

    }

    private static enum Action {
        OK,
        REPEAT;

    }

    static interface IVisitor<T> {
        public void visit(CNode var1, int var2);

        public T getResult();
    }
}

