/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker.subscriptions;

import io.moquette.broker.subscriptions.INode;
import io.moquette.broker.subscriptions.Subscription;
import io.moquette.broker.subscriptions.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

class CNode
implements Comparable<CNode> {
    private final Token token;
    private final List<INode> children;
    Set<Subscription> subscriptions;

    CNode(Token token) {
        this.children = new ArrayList<INode>();
        this.subscriptions = new HashSet<Subscription>();
        this.token = token;
    }

    private CNode(Token token, List<INode> children, Set<Subscription> subscriptions) {
        this.token = token;
        this.subscriptions = new HashSet<Subscription>(subscriptions);
        this.children = new ArrayList<INode>(children);
    }

    public Token getToken() {
        return this.token;
    }

    List<INode> allChildren() {
        return new ArrayList<INode>(this.children);
    }

    INode childOf(Token token) {
        int idx = Collections.binarySearch(this.children, token, (node, token1) -> ((INode)node).mainNode().token.compareTo((Token)token1));
        if (idx < 0) {
            return null;
        }
        return this.children.get(idx);
    }

    private boolean equalsToken(Token token) {
        return token != null && this.token != null && this.token.equals(token);
    }

    public int hashCode() {
        return Objects.hash(this.token);
    }

    CNode copy() {
        return new CNode(this.token, this.children, this.subscriptions);
    }

    public void add(INode newINode) {
        int idx = Collections.binarySearch(this.children, newINode.mainNode().token, (node, token1) -> ((INode)node).mainNode().token.compareTo((Token)token1));
        if (idx < 0) {
            this.children.add(-1 - idx, newINode);
        } else {
            this.children.add(idx, newINode);
        }
    }

    public void remove(INode node) {
        int idx = Collections.binarySearch(this.children, node.mainNode().token, (node1, token1) -> ((INode)node1).mainNode().token.compareTo((Token)token1));
        this.children.remove(idx);
    }

    CNode addSubscription(Subscription newSubscription) {
        if (this.subscriptions.contains(newSubscription)) {
            Subscription existing = this.subscriptions.stream().filter(s -> s.equals(newSubscription)).findFirst().get();
            if (existing.getRequestedQos().value() < newSubscription.getRequestedQos().value()) {
                this.subscriptions.remove(existing);
                this.subscriptions.add(new Subscription(newSubscription));
            }
        } else {
            this.subscriptions.add(new Subscription(newSubscription));
        }
        return this;
    }

    boolean containsOnly(String clientId) {
        for (Subscription sub : this.subscriptions) {
            if (sub.clientId.equals(clientId)) continue;
            return false;
        }
        return !this.subscriptions.isEmpty();
    }

    public boolean contains(String clientId) {
        for (Subscription sub : this.subscriptions) {
            if (!sub.clientId.equals(clientId)) continue;
            return true;
        }
        return false;
    }

    void removeSubscriptionsFor(String clientId) {
        HashSet<Subscription> toRemove = new HashSet<Subscription>();
        for (Subscription sub : this.subscriptions) {
            if (!sub.clientId.equals(clientId)) continue;
            toRemove.add(sub);
        }
        this.subscriptions.removeAll(toRemove);
    }

    @Override
    public int compareTo(CNode o) {
        return this.token.compareTo(o.token);
    }
}

