/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.android.data.CategoryDefinition;

public class InfoflowAndroidConfiguration
extends InfoflowConfiguration {
    private boolean oneComponentAtATime = false;
    private final CallbackConfiguration callbackConfig = new CallbackConfiguration();
    private final SourceSinkConfiguration sourceSinkConfig = new SourceSinkConfiguration();
    private final IccConfiguration iccConfig = new IccConfiguration();
    private final AnalysisFileConfiguration analysisFileConfig = new AnalysisFileConfiguration();
    private boolean mergeDexFiles = false;
    private static boolean createActivityEntryMethods = true;

    public InfoflowAndroidConfiguration() {
        this.setEnableArraySizeTainting(false);
        this.setInspectSources(false);
        this.setInspectSinks(false);
        this.setIgnoreFlowsInSystemPackages(true);
        this.setExcludeSootLibraryClasses(true);
    }

    public void merge(InfoflowConfiguration config) {
        super.merge(config);
        if (config instanceof InfoflowAndroidConfiguration) {
            InfoflowAndroidConfiguration androidConfig = (InfoflowAndroidConfiguration)config;
            this.oneComponentAtATime = androidConfig.oneComponentAtATime;
            this.callbackConfig.merge(androidConfig.callbackConfig);
            this.sourceSinkConfig.merge(androidConfig.sourceSinkConfig);
            this.iccConfig.merge(androidConfig.iccConfig);
            this.analysisFileConfig.merge(androidConfig.analysisFileConfig);
            this.mergeDexFiles = androidConfig.mergeDexFiles;
        }
    }

    public CallbackConfiguration getCallbackConfig() {
        return this.callbackConfig;
    }

    public SourceSinkConfiguration getSourceSinkConfig() {
        return this.sourceSinkConfig;
    }

    public IccConfiguration getIccConfig() {
        return this.iccConfig;
    }

    public AnalysisFileConfiguration getAnalysisFileConfig() {
        return this.analysisFileConfig;
    }

    public void setOneComponentAtATime(boolean oneComponentAtATime) {
        this.oneComponentAtATime = oneComponentAtATime;
    }

    public boolean getOneComponentAtATime() {
        return this.oneComponentAtATime;
    }

    public boolean getMergeDexFiles() {
        return this.mergeDexFiles;
    }

    public void setMergeDexFiles(boolean mergeDexFiles) {
        this.mergeDexFiles = mergeDexFiles;
    }

    public static boolean getCreateActivityEntryMethods() {
        return createActivityEntryMethods;
    }

    public static void setCreateActivityEntryMethods(boolean createActivityEntryMethods) {
        InfoflowAndroidConfiguration.createActivityEntryMethods = createActivityEntryMethods;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.analysisFileConfig == null ? 0 : this.analysisFileConfig.hashCode());
        result = 31 * result + (this.callbackConfig == null ? 0 : this.callbackConfig.hashCode());
        result = 31 * result + (this.iccConfig == null ? 0 : this.iccConfig.hashCode());
        result = 31 * result + (this.mergeDexFiles ? 1231 : 1237);
        result = 31 * result + (this.oneComponentAtATime ? 1231 : 1237);
        result = 31 * result + (this.sourceSinkConfig == null ? 0 : this.sourceSinkConfig.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        InfoflowAndroidConfiguration other = (InfoflowAndroidConfiguration)((Object)obj);
        if (this.analysisFileConfig == null ? other.analysisFileConfig != null : !this.analysisFileConfig.equals(other.analysisFileConfig)) {
            return false;
        }
        if (this.callbackConfig == null ? other.callbackConfig != null : !this.callbackConfig.equals(other.callbackConfig)) {
            return false;
        }
        if (this.iccConfig == null ? other.iccConfig != null : !this.iccConfig.equals(other.iccConfig)) {
            return false;
        }
        if (this.mergeDexFiles != other.mergeDexFiles) {
            return false;
        }
        if (this.oneComponentAtATime != other.oneComponentAtATime) {
            return false;
        }
        return !(this.sourceSinkConfig == null ? other.sourceSinkConfig != null : !this.sourceSinkConfig.equals((Object)other.sourceSinkConfig));
    }

    public static class CallbackConfiguration {
        private boolean enableCallbacks = true;
        private CallbackAnalyzer callbackAnalyzer = CallbackAnalyzer.Default;
        private boolean filterThreadCallbacks = true;
        private int maxCallbacksPerComponent = 100;
        private int callbackAnalysisTimeout = 0;
        private int maxCallbackAnalysisDepth = -1;
        private boolean serializeCallbacks = false;
        private String callbacksFile = "";

        public void merge(CallbackConfiguration cbConfig) {
            this.enableCallbacks = cbConfig.enableCallbacks;
            this.callbackAnalyzer = cbConfig.callbackAnalyzer;
            this.filterThreadCallbacks = cbConfig.filterThreadCallbacks;
            this.maxCallbacksPerComponent = cbConfig.maxCallbacksPerComponent;
            this.callbackAnalysisTimeout = cbConfig.callbackAnalysisTimeout;
            this.maxCallbackAnalysisDepth = cbConfig.maxCallbackAnalysisDepth;
            this.serializeCallbacks = cbConfig.serializeCallbacks;
            this.callbacksFile = cbConfig.callbacksFile;
        }

        public void setEnableCallbacks(boolean enableCallbacks) {
            this.enableCallbacks = enableCallbacks;
        }

        public boolean getEnableCallbacks() {
            return this.enableCallbacks;
        }

        public void setCallbackAnalyzer(CallbackAnalyzer callbackAnalyzer) {
            this.callbackAnalyzer = callbackAnalyzer;
        }

        public CallbackAnalyzer getCallbackAnalyzer() {
            return this.callbackAnalyzer;
        }

        public void setFilterThreadCallbacks(boolean filterThreadCallbacks) {
            this.filterThreadCallbacks = filterThreadCallbacks;
        }

        public boolean getFilterThreadCallbacks() {
            return this.filterThreadCallbacks;
        }

        public int getMaxCallbacksPerComponent() {
            return this.maxCallbacksPerComponent;
        }

        public void setMaxCallbacksPerComponent(int maxCallbacksPerComponent) {
            this.maxCallbacksPerComponent = maxCallbacksPerComponent;
        }

        public int getCallbackAnalysisTimeout() {
            return this.callbackAnalysisTimeout;
        }

        public void setCallbackAnalysisTimeout(int callbackAnalysisTimeout) {
            this.callbackAnalysisTimeout = callbackAnalysisTimeout;
        }

        public int getMaxAnalysisCallbackDepth() {
            return this.maxCallbackAnalysisDepth;
        }

        public void setMaxAnalysisCallbackDepth(int maxCallbackAnalysisDepth) {
            this.maxCallbackAnalysisDepth = maxCallbackAnalysisDepth;
        }

        public boolean isSerializeCallbacks() {
            return this.serializeCallbacks;
        }

        public void setSerializeCallbacks(boolean serializeCallbacks) {
            this.serializeCallbacks = serializeCallbacks;
        }

        public String getCallbacksFile() {
            return this.callbacksFile;
        }

        public void setCallbacksFile(String callbacksFile) {
            this.callbacksFile = callbacksFile;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.callbackAnalysisTimeout;
            result = 31 * result + (this.callbackAnalyzer == null ? 0 : this.callbackAnalyzer.hashCode());
            result = 31 * result + (this.callbacksFile == null ? 0 : this.callbacksFile.hashCode());
            result = 31 * result + (this.enableCallbacks ? 1231 : 1237);
            result = 31 * result + (this.filterThreadCallbacks ? 1231 : 1237);
            result = 31 * result + this.maxCallbackAnalysisDepth;
            result = 31 * result + this.maxCallbacksPerComponent;
            result = 31 * result + (this.serializeCallbacks ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CallbackConfiguration other = (CallbackConfiguration)obj;
            if (this.callbackAnalysisTimeout != other.callbackAnalysisTimeout) {
                return false;
            }
            if (this.callbackAnalyzer != other.callbackAnalyzer) {
                return false;
            }
            if (this.callbacksFile == null ? other.callbacksFile != null : !this.callbacksFile.equals(other.callbacksFile)) {
                return false;
            }
            if (this.enableCallbacks != other.enableCallbacks) {
                return false;
            }
            if (this.filterThreadCallbacks != other.filterThreadCallbacks) {
                return false;
            }
            if (this.maxCallbackAnalysisDepth != other.maxCallbackAnalysisDepth) {
                return false;
            }
            if (this.maxCallbacksPerComponent != other.maxCallbacksPerComponent) {
                return false;
            }
            return this.serializeCallbacks == other.serializeCallbacks;
        }
    }

    public static class SourceSinkConfiguration
    extends InfoflowConfiguration.SourceSinkConfiguration {
        private Map<CategoryDefinition, InfoflowConfiguration.CategoryMode> sourceCategories = new HashMap<CategoryDefinition, InfoflowConfiguration.CategoryMode>();
        private Map<CategoryDefinition, InfoflowConfiguration.CategoryMode> sinkCategories = new HashMap<CategoryDefinition, InfoflowConfiguration.CategoryMode>();

        public void merge(SourceSinkConfiguration ssConfig) {
            super.merge((InfoflowConfiguration.SourceSinkConfiguration)ssConfig);
            this.sourceCategories.putAll(ssConfig.sourceCategories);
            this.sinkCategories.putAll(ssConfig.sinkCategories);
        }

        public Set<CategoryDefinition> getSourceCategories() {
            return this.sourceCategories.keySet();
        }

        public Set<CategoryDefinition> getSinkCategories() {
            return this.sinkCategories.keySet();
        }

        public Map<CategoryDefinition, InfoflowConfiguration.CategoryMode> getSourceCategoriesAndModes() {
            return this.sourceCategories;
        }

        public Map<CategoryDefinition, InfoflowConfiguration.CategoryMode> getSinkCategoriesAndModes() {
            return this.sinkCategories;
        }

        public void addSourceCategory(CategoryDefinition category, InfoflowConfiguration.CategoryMode mode) {
            this.sourceCategories.put(category, mode);
        }

        public void addSinkCategory(CategoryDefinition category, InfoflowConfiguration.CategoryMode mode) {
            this.sinkCategories.put(category, mode);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * super.hashCode();
            result = 31 * result + (this.sinkCategories == null ? 0 : this.sinkCategories.hashCode());
            result = 31 * result + (this.sourceCategories == null ? 0 : this.sourceCategories.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            SourceSinkConfiguration other = (SourceSinkConfiguration)((Object)obj);
            if (!super.equals(obj)) {
                return false;
            }
            if (this.sinkCategories == null ? other.sinkCategories != null : !this.sinkCategories.equals(other.sinkCategories)) {
                return false;
            }
            return !(this.sourceCategories == null ? other.sourceCategories != null : !this.sourceCategories.equals(other.sourceCategories));
        }
    }

    public static class IccConfiguration {
        private boolean iccEnabled = false;
        private String iccModel = null;
        private boolean iccResultsPurify = true;

        public void merge(IccConfiguration iccConfig) {
            this.iccEnabled = iccConfig.iccEnabled;
            this.iccModel = iccConfig.iccModel;
            this.iccResultsPurify = iccConfig.iccResultsPurify;
        }

        public String getIccModel() {
            return this.iccModel;
        }

        public void setIccModel(String iccModel) {
            this.iccModel = iccModel;
        }

        public boolean isIccEnabled() {
            return this.iccModel != null && !this.iccModel.isEmpty();
        }

        public boolean isIccResultsPurifyEnabled() {
            return this.isIccEnabled() && this.iccResultsPurify;
        }

        public void setIccResultsPurify(boolean iccResultsPurify) {
            this.iccResultsPurify = iccResultsPurify;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.iccEnabled ? 1231 : 1237);
            result = 31 * result + (this.iccModel == null ? 0 : this.iccModel.hashCode());
            result = 31 * result + (this.iccResultsPurify ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IccConfiguration other = (IccConfiguration)obj;
            if (this.iccEnabled != other.iccEnabled) {
                return false;
            }
            if (this.iccModel == null ? other.iccModel != null : !this.iccModel.equals(other.iccModel)) {
                return false;
            }
            return this.iccResultsPurify == other.iccResultsPurify;
        }
    }

    public static class AnalysisFileConfiguration {
        private String targetAPKFile = "";
        private String sourceSinkFile = "";
        private String androidPlatformDir = "";
        private String additionalClasspath = "";
        private String outputFile = "";

        public void merge(AnalysisFileConfiguration fileConfig) {
            this.targetAPKFile = fileConfig.targetAPKFile;
            this.sourceSinkFile = fileConfig.sourceSinkFile;
            this.androidPlatformDir = fileConfig.androidPlatformDir;
            this.additionalClasspath = fileConfig.additionalClasspath;
            this.outputFile = fileConfig.outputFile;
        }

        public boolean validate() {
            return this.targetAPKFile != null && !this.targetAPKFile.isEmpty() && this.sourceSinkFile != null && !this.sourceSinkFile.isEmpty() && this.androidPlatformDir != null && !this.androidPlatformDir.isEmpty();
        }

        public String getTargetAPKFile() {
            return this.targetAPKFile;
        }

        public void setTargetAPKFile(String targetAPKFile) {
            this.targetAPKFile = targetAPKFile;
        }

        public String getAndroidPlatformDir() {
            return this.androidPlatformDir;
        }

        public void setAndroidPlatformDir(String androidPlatformDir) {
            this.androidPlatformDir = androidPlatformDir;
        }

        public String getSourceSinkFile() {
            return this.sourceSinkFile;
        }

        public void setSourceSinkFile(String sourceSinkFile) {
            this.sourceSinkFile = sourceSinkFile;
        }

        public String getAdditionalClasspath() {
            return this.additionalClasspath;
        }

        public void setAdditionalClasspath(String additionalClasspath) {
            this.additionalClasspath = additionalClasspath;
        }

        public String getOutputFile() {
            return this.outputFile;
        }

        public void setOutputFile(String outputFile) {
            this.outputFile = outputFile;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.additionalClasspath == null ? 0 : this.additionalClasspath.hashCode());
            result = 31 * result + (this.androidPlatformDir == null ? 0 : this.androidPlatformDir.hashCode());
            result = 31 * result + (this.outputFile == null ? 0 : this.outputFile.hashCode());
            result = 31 * result + (this.sourceSinkFile == null ? 0 : this.sourceSinkFile.hashCode());
            result = 31 * result + (this.targetAPKFile == null ? 0 : this.targetAPKFile.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AnalysisFileConfiguration other = (AnalysisFileConfiguration)obj;
            if (this.additionalClasspath == null ? other.additionalClasspath != null : !this.additionalClasspath.equals(other.additionalClasspath)) {
                return false;
            }
            if (this.androidPlatformDir == null ? other.androidPlatformDir != null : !this.androidPlatformDir.equals(other.androidPlatformDir)) {
                return false;
            }
            if (this.outputFile == null ? other.outputFile != null : !this.outputFile.equals(other.outputFile)) {
                return false;
            }
            if (this.sourceSinkFile == null ? other.sourceSinkFile != null : !this.sourceSinkFile.equals(other.sourceSinkFile)) {
                return false;
            }
            return !(this.targetAPKFile == null ? other.targetAPKFile != null : !this.targetAPKFile.equals(other.targetAPKFile));
        }
    }

    public static enum CallbackAnalyzer {
        Default,
        Fast;

    }
}

