/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.callbacks.filters;

import java.util.Set;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.infoflow.android.callbacks.filters.AbstractCallbackFilter;

public class AlienHostComponentFilter
extends AbstractCallbackFilter {
    private SootClass activityClass;
    private SootClass fragmentClass;
    private final Set<SootClass> components;

    public AlienHostComponentFilter(Set<SootClass> components) {
        this.components = components;
    }

    @Override
    public boolean accepts(SootClass component, SootClass callbackHandler) {
        if (callbackHandler == null || component == null) {
            return false;
        }
        if (this.activityClass == null || this.fragmentClass == null) {
            this.reset();
        }
        if (this.fragmentClass != null && this.activityClass != null && Scene.v().getOrMakeFastHierarchy().canStoreType((Type)callbackHandler.getType(), (Type)this.fragmentClass.getType()) && !Scene.v().getOrMakeFastHierarchy().canStoreType((Type)component.getType(), (Type)this.activityClass.getType())) {
            return false;
        }
        SootClass curHandler = callbackHandler;
        while (curHandler.isInnerClass()) {
            SootClass outerClass = curHandler.getOuterClass();
            if (this.components.contains(outerClass) && !Scene.v().getOrMakeFastHierarchy().canStoreType((Type)component.getType(), (Type)outerClass.getType())) {
                return false;
            }
            if (curHandler == outerClass) break;
            curHandler = outerClass;
        }
        if (this.components.contains(callbackHandler) && callbackHandler != component) {
            return false;
        }
        for (SootMethod cons : callbackHandler.getMethods()) {
            if (!cons.isConstructor() || cons.isPrivate()) continue;
            boolean isConstructorUsable = true;
            for (int i = 0; i < cons.getParameterCount(); ++i) {
                Type paramType = cons.getParameterType(i);
                if (paramType == component.getType() || !(paramType instanceof RefType) || !this.components.contains(((RefType)paramType).getSootClass())) continue;
                isConstructorUsable = false;
                break;
            }
            if (isConstructorUsable) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        this.activityClass = Scene.v().getSootClassUnsafe("android.app.Activity");
        this.fragmentClass = Scene.v().getSootClassUnsafe("android.app.Fragment");
    }

    @Override
    public boolean accepts(SootClass component, SootMethod callback) {
        return true;
    }
}

