/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.entryPointCreators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.IfStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.infoflow.android.entryPointCreators.AbstractAndroidEntryPointCreator;
import soot.jimple.infoflow.android.entryPointCreators.AndroidEntryPointConstants;
import soot.jimple.infoflow.android.entryPointCreators.AndroidEntryPointUtils;
import soot.jimple.infoflow.android.entryPointCreators.DummyMainFieldElementTag;
import soot.jimple.infoflow.android.entryPointCreators.components.AbstractComponentEntryPointCreator;
import soot.jimple.infoflow.android.entryPointCreators.components.ActivityEntryPointCreator;
import soot.jimple.infoflow.android.entryPointCreators.components.BroadcastReceiverEntryPointCreator;
import soot.jimple.infoflow.android.entryPointCreators.components.ComponentEntryPointCollection;
import soot.jimple.infoflow.android.entryPointCreators.components.ContentProviderEntryPointCreator;
import soot.jimple.infoflow.android.entryPointCreators.components.FragmentEntryPointCreator;
import soot.jimple.infoflow.android.entryPointCreators.components.ServiceConnectionEntryPointCreator;
import soot.jimple.infoflow.android.entryPointCreators.components.ServiceEntryPointCreator;
import soot.jimple.infoflow.android.manifest.IAndroidApplication;
import soot.jimple.infoflow.android.manifest.IManifestHandler;
import soot.jimple.infoflow.cfg.LibraryClassPatcher;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.entryPointCreators.IEntryPointCreator;
import soot.jimple.infoflow.entryPointCreators.SimulatedCodeElementTag;
import soot.jimple.infoflow.typing.TypeUtils;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.jimple.toolkits.scalar.NopEliminator;
import soot.options.Options;
import soot.tagkit.Tag;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class AndroidEntryPointCreator
extends AbstractAndroidEntryPointCreator
implements IEntryPointCreator {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final boolean DEBUG = false;
    protected MultiMap<SootClass, SootMethod> callbackFunctions = new HashMultiMap();
    private SootClass applicationClass = null;
    private Local applicationLocal = null;
    private MultiMap<SootClass, String> activityLifecycleCallbacks = new HashMultiMap();
    private MultiMap<SootClass, String> applicationCallbackClasses = new HashMultiMap();
    private Map<SootClass, SootField> callbackClassToField = new HashMap<SootClass, SootField>();
    private MultiMap<SootClass, SootClass> fragmentClasses = null;
    private final ComponentEntryPointCollection componentToInfo = new ComponentEntryPointCollection();
    private Collection<SootClass> components;
    private MultiMap<SootMethod, Stmt> javascriptInterfaceStmts;

    public AndroidEntryPointCreator(IManifestHandler manifest, Collection<SootClass> components) {
        super(manifest);
        this.components = components;
        this.overwriteDummyMainMethod = true;
    }

    protected SootMethod createDummyMainInternal() {
        this.reset();
        this.logger.info(String.format("Creating Android entry point for %d components...", this.components.size()));
        boolean hasContentProviders = false;
        NopStmt beforeContentProvidersStmt = Jimple.v().newNopStmt();
        this.body.getUnits().add((Unit)beforeContentProvidersStmt);
        for (SootClass sootClass : this.components) {
            Local localVal;
            if (this.entryPointUtils.getComponentType(sootClass) != AndroidEntryPointUtils.ComponentType.ContentProvider || (localVal = this.generateClassConstructor(sootClass)) == null) continue;
            this.localVarsForClasses.put(sootClass, localVal);
            NopStmt thenStmt = Jimple.v().newNopStmt();
            this.createIfStmt((Unit)thenStmt);
            this.searchAndBuildMethod("boolean onCreate()", sootClass, localVal);
            this.body.getUnits().add((Unit)thenStmt);
            hasContentProviders = true;
        }
        if (hasContentProviders) {
            this.createIfStmt((Unit)beforeContentProvidersStmt);
        }
        this.initializeApplicationClass();
        if (this.applicationClass != null) {
            this.applicationLocal = this.generateClassConstructor(this.applicationClass);
            this.localVarsForClasses.put(this.applicationClass, this.applicationLocal);
            if (this.applicationLocal != null) {
                boolean hasActivityLifecycleCallbacks;
                this.localVarsForClasses.put(this.applicationClass, this.applicationLocal);
                boolean hasApplicationCallbacks = this.applicationCallbackClasses != null && !this.applicationCallbackClasses.isEmpty();
                boolean bl = hasActivityLifecycleCallbacks = this.activityLifecycleCallbacks != null && !this.activityLifecycleCallbacks.isEmpty();
                if (hasApplicationCallbacks || hasActivityLifecycleCallbacks) {
                    NopStmt beforeCbCons = Jimple.v().newNopStmt();
                    this.body.getUnits().add((Unit)beforeCbCons);
                    if (hasApplicationCallbacks) {
                        this.createClassInstances(this.applicationCallbackClasses.keySet());
                    }
                    if (hasActivityLifecycleCallbacks) {
                        this.createClassInstances(this.activityLifecycleCallbacks.keySet());
                        for (SootClass sc : this.activityLifecycleCallbacks.keySet()) {
                            SootField fld = this.callbackClassToField.get(sc);
                            Local lc = (Local)this.localVarsForClasses.get(sc);
                            if (sc == null || lc == null) continue;
                            this.body.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)Jimple.v().newStaticFieldRef(fld.makeRef()), (Value)lc));
                        }
                    }
                    this.createIfStmt((Unit)beforeCbCons);
                }
                this.searchAndBuildMethod("void onCreate()", this.applicationClass, this.applicationLocal);
                Iterator<Object> scApplicationHolder = LibraryClassPatcher.createOrGetApplicationHolder();
                this.body.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)Jimple.v().newStaticFieldRef(scApplicationHolder.getFieldByName("application").makeRef()), (Value)this.applicationLocal));
            }
        }
        NopStmt outerStartStmt = Jimple.v().newNopStmt();
        this.body.getUnits().add((Unit)outerStartStmt);
        HashMap<SootClass, SootMethod> fragmentToMainMethod = new HashMap<SootClass, SootMethod>();
        for (SootClass sootClass : this.fragmentClasses.keySet()) {
            Set fragments = this.fragmentClasses.get((Object)sootClass);
            for (SootClass fragment : fragments) {
                FragmentEntryPointCreator entryPointCreator = new FragmentEntryPointCreator(fragment, this.applicationClass, this.manifest);
                entryPointCreator.setDummyClassName(this.mainMethod.getDeclaringClass().getName());
                entryPointCreator.setCallbacks(this.callbackFunctions.get((Object)fragment));
                SootMethod fragmentMethod = entryPointCreator.createDummyMain();
                fragmentToMainMethod.put(fragment, fragmentMethod);
                this.componentToInfo.put(fragment, fragmentMethod);
            }
        }
        for (SootClass sootClass : this.components) {
            sootClass.setApplicationClass();
            AndroidEntryPointUtils.ComponentType componentType = this.entryPointUtils.getComponentType(sootClass);
            NopStmt beforeComponentStmt = Jimple.v().newNopStmt();
            NopStmt afterComponentStmt = Jimple.v().newNopStmt();
            this.body.getUnits().add((Unit)beforeComponentStmt);
            AbstractComponentEntryPointCreator componentCreator = null;
            switch (componentType) {
                case Activity: {
                    Set fragments;
                    HashMap<SootClass, SootMethod> curActivityToFragmentMethod = new HashMap<SootClass, SootMethod>();
                    if (this.fragmentClasses != null && (fragments = this.fragmentClasses.get((Object)sootClass)) != null && !fragments.isEmpty()) {
                        for (SootClass fragment : fragments) {
                            curActivityToFragmentMethod.put(fragment, (SootMethod)fragmentToMainMethod.get(fragment));
                        }
                    }
                    componentCreator = new ActivityEntryPointCreator(sootClass, this.applicationClass, this.activityLifecycleCallbacks, this.callbackClassToField, curActivityToFragmentMethod, this.manifest);
                    break;
                }
                case Service: 
                case GCMBaseIntentService: 
                case GCMListenerService: 
                case HostApduService: {
                    componentCreator = new ServiceEntryPointCreator(sootClass, this.applicationClass, this.manifest);
                    break;
                }
                case ServiceConnection: {
                    componentCreator = new ServiceConnectionEntryPointCreator(sootClass, this.applicationClass, this.manifest);
                    break;
                }
                case BroadcastReceiver: {
                    componentCreator = new BroadcastReceiverEntryPointCreator(sootClass, this.applicationClass, this.manifest);
                    break;
                }
                case ContentProvider: {
                    componentCreator = new ContentProviderEntryPointCreator(sootClass, this.applicationClass, this.manifest);
                    break;
                }
                default: {
                    componentCreator = null;
                }
            }
            this.createIfStmt((Unit)afterComponentStmt);
            if (componentCreator != null) {
                componentCreator.setDummyClassName(this.mainMethod.getDeclaringClass().getName());
                componentCreator.setCallbacks(this.callbackFunctions.get((Object)sootClass));
                SootMethod lifecycleMethod = componentCreator.createDummyMain();
                this.componentToInfo.put(sootClass, componentCreator.getComponentInfo());
                if (this.shouldAddLifecycleCall(sootClass)) {
                    this.body.getUnits().add((Unit)Jimple.v().newInvokeStmt((Value)Jimple.v().newStaticInvokeExpr(lifecycleMethod.makeRef(), Collections.singletonList(NullConstant.v()))));
                }
            }
            this.createIfStmt((Unit)beforeComponentStmt);
            this.body.getUnits().add((Unit)afterComponentStmt);
        }
        if (this.applicationLocal != null) {
            NopStmt beforeAppCallbacks = Jimple.v().newNopStmt();
            this.body.getUnits().add((Unit)beforeAppCallbacks);
            this.addApplicationCallbackMethods();
            this.createIfStmt((Unit)beforeAppCallbacks);
        }
        this.createJavascriptCallbacks();
        this.createIfStmt((Unit)outerStartStmt);
        if (this.applicationLocal != null) {
            this.searchAndBuildMethod("void onTerminate()", this.applicationClass, this.applicationLocal);
        }
        this.body.getUnits().add((Unit)Jimple.v().newReturnVoidStmt());
        NopEliminator.v().transform(this.body);
        this.eliminateSelfLoops();
        this.eliminateFallthroughIfs(this.body);
        if (Options.v().validate()) {
            this.mainMethod.getActiveBody().validate();
        }
        return this.mainMethod;
    }

    private void createJavascriptCallbacks() {
        Jimple j = Jimple.v();
        for (SootMethod m : this.javascriptInterfaceStmts.keySet()) {
            Set statements = this.javascriptInterfaceStmts.get((Object)m);
            for (Stmt s : statements) {
                UnitPatchingChain units = m.retrieveActiveBody().getUnits();
                SootField f = null;
                Value arg = s.getInvokeExpr().getArg(0);
                DummyMainFieldElementTag dm = (DummyMainFieldElementTag)s.getTag("DummyMainFieldElementTag");
                if (dm != null) {
                    f = this.mainMethod.getDeclaringClass().getFieldByNameUnsafe(dm.getFieldName());
                }
                if (f == null) {
                    f = this.createField(arg.getType(), "jsInterface");
                    AssignStmt assign = j.newAssignStmt((Value)j.newStaticFieldRef(f.makeRef()), arg);
                    assign.addTag((Tag)SimulatedCodeElementTag.TAG);
                    s.addTag((Tag)new DummyMainFieldElementTag(f.getName()));
                    units.insertAfter((Unit)assign, (Unit)s);
                }
                Local l = j.newLocal(f.getName(), f.getType());
                this.body.getLocals().add((Object)l);
                AssignStmt assignF = j.newAssignStmt((Value)l, (Value)j.newStaticFieldRef(f.makeRef()));
                this.body.getUnits().add((Unit)assignF);
                SootClass cbtype = ((RefType)f.getType()).getSootClass();
                for (SootClass c : TypeUtils.getAllDerivedClasses((SootClass)cbtype)) {
                    for (SootMethod cbm : c.getMethods()) {
                        if (!AndroidEntryPointUtils.isCallableFromJS(cbm)) continue;
                        ArrayList<Value> args = new ArrayList<Value>();
                        for (Type t : cbm.getParameterTypes()) {
                            args.add(this.getSimpleDefaultValue(t));
                        }
                        InvokeStmt st = j.newInvokeStmt((Value)j.newVirtualInvokeExpr(l, cbm.makeRef(), args));
                        this.body.getUnits().add((Unit)st);
                    }
                }
                this.createIfStmt((Unit)assignF);
            }
        }
    }

    protected boolean shouldAddLifecycleCall(SootClass clazz) {
        return true;
    }

    private void initializeApplicationClass() {
        IAndroidApplication app = this.manifest.getApplication();
        if (app != null) {
            String applicationName = app.getName();
            if (applicationName == null || applicationName.isEmpty()) {
                return;
            }
            for (SootClass currentClass : this.components) {
                if (!this.entryPointUtils.isApplicationClass(currentClass) || !currentClass.getName().equals(applicationName)) continue;
                if (this.applicationClass != null && currentClass != this.applicationClass) {
                    throw new RuntimeException("Multiple application classes in app");
                }
                this.applicationClass = currentClass;
                break;
            }
        }
        if (this.applicationClass == null) {
            return;
        }
        SootClass scActCallbacks = Scene.v().getSootClassUnsafe("android.app.Application$ActivityLifecycleCallbacks");
        Set callbacks = this.callbackFunctions.get((Object)this.applicationClass);
        if (callbacks != null) {
            for (SootMethod smCallback : callbacks) {
                if (smCallback == null) continue;
                if (scActCallbacks != null && Scene.v().getOrMakeFastHierarchy().canStoreType((Type)smCallback.getDeclaringClass().getType(), (Type)scActCallbacks.getType())) {
                    this.activityLifecycleCallbacks.put((Object)smCallback.getDeclaringClass(), (Object)smCallback.getSignature());
                    continue;
                }
                this.applicationCallbackClasses.put((Object)smCallback.getDeclaringClass(), (Object)smCallback.getSignature());
            }
        }
        for (SootClass callbackClass : this.activityLifecycleCallbacks.keySet()) {
            String baseName = callbackClass.getName();
            if (baseName.contains(".")) {
                baseName = baseName.substring(baseName.lastIndexOf(".") + 1);
            }
            SootField fld = this.createField((Type)RefType.v((SootClass)callbackClass), baseName);
            this.callbackClassToField.put(callbackClass, fld);
        }
    }

    protected SootField createField(Type type, String baseName) {
        SootClass dummyMainClass = this.mainMethod.getDeclaringClass();
        int idx = 0;
        String fieldName = baseName;
        while (dummyMainClass.declaresFieldByName(fieldName)) {
            fieldName = baseName + "_" + idx;
            ++idx;
        }
        SootField fld = Scene.v().makeSootField(fieldName, type, 10);
        this.mainMethod.getDeclaringClass().addField(fld);
        return fld;
    }

    private void eliminateFallthroughIfs(Body body) {
        boolean changed = false;
        do {
            changed = false;
            IfStmt ifs = null;
            Iterator unitIt = body.getUnits().snapshotIterator();
            while (unitIt.hasNext()) {
                Unit u = (Unit)unitIt.next();
                if (ifs != null && ifs.getTarget() == u) {
                    body.getUnits().remove(ifs);
                    changed = true;
                }
                ifs = null;
                if (!(u instanceof IfStmt)) continue;
                ifs = (IfStmt)u;
            }
        } while (changed);
    }

    private void addApplicationCallbackMethods() {
        if (!this.callbackFunctions.containsKey((Object)this.applicationClass)) {
            return;
        }
        if (this.applicationClass.isAbstract()) {
            return;
        }
        if (this.applicationClass.isPhantom()) {
            this.logger.warn("Skipping possible application callbacks in phantom class %s", (Object)this.applicationClass);
            return;
        }
        List<String> lifecycleMethods = AndroidEntryPointConstants.getApplicationLifecycleMethods();
        for (SootClass sc : this.applicationCallbackClasses.keySet()) {
            for (String methodSig : this.applicationCallbackClasses.get((Object)sc)) {
                SootMethodAndClass methodAndClass = SootMethodRepresentationParser.v().parseSootMethodString(methodSig);
                String subSig = methodAndClass.getSubSignature();
                SootMethod method = this.findMethod(Scene.v().getSootClass(sc.getName()), subSig);
                if (sc == this.applicationClass && lifecycleMethods.contains(subSig) || this.activityLifecycleCallbacks.containsKey((Object)sc) && lifecycleMethods.contains(subSig) || method == null || SystemClassHandler.v().isClassInSystemPackage(method.getDeclaringClass().getName())) continue;
                Local local = (Local)this.localVarsForClasses.get(sc);
                if (local == null) {
                    this.logger.warn(String.format("Could not create call to application callback %s. Local was null.", method.getSignature()));
                    continue;
                }
                NopStmt thenStmt = Jimple.v().newNopStmt();
                this.createIfStmt((Unit)thenStmt);
                this.buildMethodCall(method, local);
                this.body.getUnits().add((Unit)thenStmt);
            }
        }
    }

    public Collection<String> getRequiredClasses() {
        HashSet<String> requiredClasses = new HashSet<String>(this.components.size());
        for (SootClass sc : this.components) {
            requiredClasses.add(sc.getName());
        }
        return requiredClasses;
    }

    public void setFragments(MultiMap<SootClass, SootClass> fragments) {
        this.fragmentClasses = fragments;
    }

    public Collection<SootMethod> getAdditionalMethods() {
        return this.componentToInfo.getLifecycleMethods();
    }

    public Collection<SootField> getAdditionalFields() {
        return this.componentToInfo.getAdditionalFields();
    }

    public ComponentEntryPointCollection getComponentToEntryPointInfo() {
        return this.componentToInfo;
    }

    public void setCallbackFunctions(MultiMap<SootClass, SootMethod> callbackFunctions) {
        this.callbackFunctions = callbackFunctions;
    }

    public MultiMap<SootClass, SootMethod> getCallbackFunctions() {
        return this.callbackFunctions;
    }

    public void reset() {
        super.reset();
        for (SootMethod sm : this.getAdditionalMethods()) {
            if (!sm.isDeclared()) continue;
            sm.getDeclaringClass().removeMethod(sm);
        }
        for (SootField sf : this.getAdditionalFields()) {
            if (!sf.isDeclared()) continue;
            sf.getDeclaringClass().removeField(sf);
        }
        for (SootField fld : this.callbackClassToField.values()) {
            if (!fld.isDeclared()) continue;
            fld.getDeclaringClass().removeField(fld);
        }
        this.componentToInfo.clear();
        this.callbackClassToField.clear();
    }

    public void setComponents(Collection<SootClass> components) {
        this.components = components;
    }

    public void removeGeneratedMethods(boolean removeClass) {
        SootClass mainClass = this.mainMethod.getDeclaringClass();
        if (removeClass) {
            Scene.v().removeClass(mainClass);
        } else {
            mainClass.removeMethod(this.mainMethod);
        }
        for (SootMethod sm : this.getAdditionalMethods()) {
            SootClass declaringClass;
            if (!sm.isDeclared() || !(declaringClass = sm.getDeclaringClass()).isInScene()) continue;
            declaringClass.removeMethod(sm);
        }
    }

    public void setJavaScriptInterfaces(MultiMap<SootMethod, Stmt> javascriptInterfaceStmts) {
        this.javascriptInterfaceStmts = javascriptInterfaceStmts;
    }
}

