/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.entryPointCreators;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.FastHierarchy;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.infoflow.android.entryPointCreators.AndroidEntryPointConstants;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.tagkit.AnnotationTag;
import soot.tagkit.Tag;
import soot.tagkit.VisibilityAnnotationTag;

public class AndroidEntryPointUtils {
    private static final Logger logger = LoggerFactory.getLogger(AndroidEntryPointUtils.class);
    private Map<SootClass, ComponentType> componentTypeCache = new HashMap<SootClass, ComponentType>();
    private SootClass osClassApplication = Scene.v().getSootClassUnsafe("android.app.Application");
    private SootClass osClassActivity = Scene.v().getSootClassUnsafe("android.app.Activity");
    private SootClass osClassMapActivity;
    private SootClass osClassService = Scene.v().getSootClassUnsafe("android.app.Service");
    private SootClass osClassFragment = Scene.v().getSootClassUnsafe("android.app.Fragment");
    private SootClass osClassSupportFragment = Scene.v().getSootClassUnsafe("android.support.v4.app.Fragment");
    private SootClass osClassAndroidXFragment = Scene.v().getSootClassUnsafe("androidx.fragment.app.Fragment");
    private SootClass osClassBroadcastReceiver = Scene.v().getSootClassUnsafe("android.content.BroadcastReceiver");
    private SootClass osClassContentProvider = Scene.v().getSootClassUnsafe("android.content.ContentProvider");
    private SootClass osClassGCMBaseIntentService = Scene.v().getSootClassUnsafe("com.google.android.gcm.GCMBaseIntentService");
    private SootClass osClassGCMListenerService = Scene.v().getSootClassUnsafe("com.google.android.gms.gcm.GcmListenerService");
    private SootClass osClassHostApduService = Scene.v().getSootClassUnsafe("android.nfc.cardemulation.HostApduService");
    private SootClass osInterfaceServiceConnection = Scene.v().getSootClassUnsafe("android.content.ServiceConnection");
    private static final String JS_INTERFACE = "Landroid/webkit/JavascriptInterface;";

    public AndroidEntryPointUtils() {
        this.osClassMapActivity = Scene.v().getSootClassUnsafe("com.google.android.maps.MapActivity");
    }

    public ComponentType getComponentType(SootClass currentClass) {
        if (this.componentTypeCache.containsKey(currentClass)) {
            return this.componentTypeCache.get(currentClass);
        }
        ComponentType ctype = ComponentType.Plain;
        FastHierarchy fh = Scene.v().getOrMakeFastHierarchy();
        if (fh != null) {
            if (this.osClassFragment != null && Scene.v().getOrMakeFastHierarchy().canStoreType((Type)currentClass.getType(), (Type)this.osClassFragment.getType())) {
                ctype = ComponentType.Fragment;
            } else if (this.osClassSupportFragment != null && fh.canStoreType((Type)currentClass.getType(), (Type)this.osClassSupportFragment.getType())) {
                ctype = ComponentType.Fragment;
            } else if (this.osClassAndroidXFragment != null && fh.canStoreType((Type)currentClass.getType(), (Type)this.osClassAndroidXFragment.getType())) {
                ctype = ComponentType.Fragment;
            } else if (this.osClassGCMBaseIntentService != null && fh.canStoreType((Type)currentClass.getType(), (Type)this.osClassGCMBaseIntentService.getType())) {
                ctype = ComponentType.GCMBaseIntentService;
            } else if (this.osClassGCMListenerService != null && fh.canStoreType((Type)currentClass.getType(), (Type)this.osClassGCMListenerService.getType())) {
                ctype = ComponentType.GCMListenerService;
            } else if (this.osClassHostApduService != null && fh.canStoreType((Type)currentClass.getType(), (Type)this.osClassHostApduService.getType())) {
                ctype = ComponentType.HostApduService;
            } else if (this.osInterfaceServiceConnection != null && fh.canStoreType((Type)currentClass.getType(), (Type)this.osInterfaceServiceConnection.getType())) {
                ctype = ComponentType.ServiceConnection;
            } else if (this.osClassMapActivity != null && fh.canStoreType((Type)currentClass.getType(), (Type)this.osClassMapActivity.getType())) {
                ctype = ComponentType.Activity;
            } else if (this.osClassApplication != null && fh.canStoreType((Type)currentClass.getType(), (Type)this.osClassApplication.getType())) {
                ctype = ComponentType.Application;
            } else if (this.osClassService != null && fh.canStoreType((Type)currentClass.getType(), (Type)this.osClassService.getType())) {
                ctype = ComponentType.Service;
            } else if (this.osClassActivity != null && fh.canStoreType((Type)currentClass.getType(), (Type)this.osClassActivity.getType())) {
                ctype = ComponentType.Activity;
            } else if (this.osClassBroadcastReceiver != null && fh.canStoreType((Type)currentClass.getType(), (Type)this.osClassBroadcastReceiver.getType())) {
                ctype = ComponentType.BroadcastReceiver;
            } else if (this.osClassContentProvider != null && fh.canStoreType((Type)currentClass.getType(), (Type)this.osClassContentProvider.getType())) {
                ctype = ComponentType.ContentProvider;
            }
        } else {
            logger.warn(String.format("No FastHierarchy, assuming %s is a plain class", currentClass.getName()));
        }
        this.componentTypeCache.put(currentClass, ctype);
        return ctype;
    }

    public boolean isApplicationClass(SootClass clazz) {
        return this.osClassApplication != null && Scene.v().getOrMakeFastHierarchy().canStoreType((Type)clazz.getType(), (Type)this.osClassApplication.getType());
    }

    public boolean isEntryPointMethod(SootMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Given method is null");
        }
        ComponentType componentType = this.getComponentType(method.getDeclaringClass());
        String subsignature = method.getSubSignature();
        if (componentType == ComponentType.Activity && AndroidEntryPointConstants.getActivityLifecycleMethods().contains(subsignature)) {
            return true;
        }
        if (componentType == ComponentType.Service && AndroidEntryPointConstants.getServiceLifecycleMethods().contains(subsignature)) {
            return true;
        }
        if (componentType == ComponentType.Application && AndroidEntryPointConstants.getApplicationLifecycleMethods().contains(subsignature)) {
            return true;
        }
        if (componentType == ComponentType.Fragment && AndroidEntryPointConstants.getFragmentLifecycleMethods().contains(subsignature)) {
            return true;
        }
        if (componentType == ComponentType.BroadcastReceiver && AndroidEntryPointConstants.getBroadcastLifecycleMethods().contains(subsignature)) {
            return true;
        }
        if (componentType == ComponentType.ContentProvider && AndroidEntryPointConstants.getContentproviderLifecycleMethods().contains(subsignature)) {
            return true;
        }
        if (componentType == ComponentType.GCMBaseIntentService && AndroidEntryPointConstants.getGCMIntentServiceMethods().contains(subsignature)) {
            return true;
        }
        if (componentType == ComponentType.GCMListenerService && AndroidEntryPointConstants.getGCMListenerServiceMethods().contains(subsignature)) {
            return true;
        }
        if (componentType == ComponentType.ServiceConnection && AndroidEntryPointConstants.getServiceConnectionMethods().contains(subsignature)) {
            return true;
        }
        return componentType == ComponentType.HostApduService && AndroidEntryPointConstants.getHostApduServiceMethods().contains(subsignature);
    }

    public Collection<? extends MethodOrMethodContext> getLifecycleMethods(SootClass sc) {
        return AndroidEntryPointUtils.getLifecycleMethods(this.getComponentType(sc), sc);
    }

    public static Collection<? extends MethodOrMethodContext> getLifecycleMethods(ComponentType componentType, SootClass sc) {
        switch (componentType) {
            case Activity: {
                return AndroidEntryPointUtils.getLifecycleMethods(sc, AndroidEntryPointConstants.getActivityLifecycleMethods());
            }
            case Service: {
                return AndroidEntryPointUtils.getLifecycleMethods(sc, AndroidEntryPointConstants.getServiceLifecycleMethods());
            }
            case Application: {
                return AndroidEntryPointUtils.getLifecycleMethods(sc, AndroidEntryPointConstants.getApplicationLifecycleMethods());
            }
            case BroadcastReceiver: {
                return AndroidEntryPointUtils.getLifecycleMethods(sc, AndroidEntryPointConstants.getBroadcastLifecycleMethods());
            }
            case Fragment: {
                return AndroidEntryPointUtils.getLifecycleMethods(sc, AndroidEntryPointConstants.getFragmentLifecycleMethods());
            }
            case ContentProvider: {
                return AndroidEntryPointUtils.getLifecycleMethods(sc, AndroidEntryPointConstants.getContentproviderLifecycleMethods());
            }
            case GCMBaseIntentService: {
                return AndroidEntryPointUtils.getLifecycleMethods(sc, AndroidEntryPointConstants.getGCMIntentServiceMethods());
            }
            case GCMListenerService: {
                return AndroidEntryPointUtils.getLifecycleMethods(sc, AndroidEntryPointConstants.getGCMListenerServiceMethods());
            }
            case ServiceConnection: {
                return AndroidEntryPointUtils.getLifecycleMethods(sc, AndroidEntryPointConstants.getServiceConnectionMethods());
            }
            case Plain: {
                return Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }

    private static Collection<? extends MethodOrMethodContext> getLifecycleMethods(SootClass sc, List<String> methods) {
        HashSet<SootMethod> lifecycleMethods = new HashSet<SootMethod>();
        SootClass currentClass = sc;
        while (currentClass != null) {
            for (String sig : methods) {
                SootMethod sm = currentClass.getMethodUnsafe(sig);
                if (sm == null || SystemClassHandler.v().isClassInSystemPackage(sm.getDeclaringClass().getName())) continue;
                lifecycleMethods.add(sm);
            }
            currentClass = currentClass.hasSuperclass() ? currentClass.getSuperclass() : null;
        }
        return lifecycleMethods;
    }

    public static boolean isCallableFromJS(SootMethod m) {
        if (!m.isPublic() || m.isStatic() || m.isAbstract()) {
            return false;
        }
        for (Tag tag : m.getTags()) {
            if (!(tag instanceof VisibilityAnnotationTag)) continue;
            VisibilityAnnotationTag vatag = (VisibilityAnnotationTag)tag;
            for (AnnotationTag t : vatag.getAnnotations()) {
                if (!t.getType().equals(JS_INTERFACE)) continue;
                return true;
            }
        }
        return false;
    }

    public static enum ComponentType {
        Application,
        Activity,
        Service,
        Fragment,
        BroadcastReceiver,
        ContentProvider,
        GCMBaseIntentService,
        GCMListenerService,
        HostApduService,
        ServiceConnection,
        Plain;

    }
}

