/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.resources.controls;

import java.util.HashMap;
import java.util.Map;
import soot.SootClass;
import soot.jimple.infoflow.android.axml.AXmlAttribute;
import soot.jimple.infoflow.resources.controls.LayoutControl;

public abstract class AndroidLayoutControl
extends LayoutControl {
    protected int id;
    protected SootClass viewClass;
    protected String clickListener = null;
    private Map<String, Object> additionalAttributes = null;

    AndroidLayoutControl(SootClass viewClass) {
        this(-1, viewClass);
    }

    public AndroidLayoutControl(int id, SootClass viewClass) {
        this.id = id;
        this.viewClass = viewClass;
    }

    public AndroidLayoutControl(int id, SootClass viewClass, Map<String, Object> additionalAttributes) {
        this(id, viewClass);
        this.additionalAttributes = additionalAttributes;
    }

    public int getID() {
        return this.id;
    }

    public SootClass getViewClass() {
        return this.viewClass;
    }

    public void addAdditionalAttribute(String key, String value) {
        if (this.additionalAttributes != null) {
            this.additionalAttributes = new HashMap<String, Object>();
        }
        this.additionalAttributes.put(key, value);
    }

    public String getClickListener() {
        return this.clickListener;
    }

    public Map<String, Object> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    void setId(int id) {
        this.id = id;
    }

    void handleAttribute(AXmlAttribute<?> attribute, boolean loadOptionalData) {
        String attrName = attribute.getName().trim();
        int type = attribute.getType();
        if (attrName.equals("id")) {
            this.id = attribute.asInteger();
        } else if (this.isActionListener(attrName) && type == 3 && attribute.getValue() instanceof String) {
            this.clickListener = attribute.asString().trim();
        } else if (loadOptionalData) {
            if (this.additionalAttributes == null) {
                this.additionalAttributes = new HashMap<String, Object>();
            }
            this.additionalAttributes.put(attrName, attribute.getValue());
        }
    }

    protected boolean isActionListener(String name) {
        return name.equals("onClick");
    }

    public String toString() {
        return this.id + " - " + this.viewClass;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.additionalAttributes == null ? 0 : this.additionalAttributes.hashCode());
        result = 31 * result + (this.clickListener == null ? 0 : this.clickListener.hashCode());
        result = 31 * result + this.id;
        result = 31 * result + (this.viewClass == null ? 0 : this.viewClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AndroidLayoutControl other = (AndroidLayoutControl)((Object)obj);
        if (this.additionalAttributes == null ? other.additionalAttributes != null : !this.additionalAttributes.equals(other.additionalAttributes)) {
            return false;
        }
        if (this.clickListener == null ? other.clickListener != null : !this.clickListener.equals(other.clickListener)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        return !(this.viewClass == null ? other.viewClass != null : !this.viewClass.equals(other.viewClass));
    }
}

