/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.resources.controls;

import java.util.Map;
import soot.Scene;
import soot.SootClass;
import soot.Type;
import soot.jimple.infoflow.android.axml.AXmlAttribute;
import soot.jimple.infoflow.android.axml.AXmlNode;
import soot.jimple.infoflow.android.resources.controls.AndroidLayoutControl;
import soot.jimple.infoflow.android.resources.controls.EditTextControl;
import soot.jimple.infoflow.android.resources.controls.GenericLayoutControl;

public class LayoutControlFactory {
    private boolean loadAdditionalAttributes = false;
    private SootClass scEditText = null;

    public AndroidLayoutControl createLayoutControl(String layoutFile, SootClass layoutClass, AXmlNode node) {
        if (this.scEditText == null) {
            this.scEditText = Scene.v().getSootClassUnsafe("android.widget.EditText");
        }
        AndroidLayoutControl lc = this.createLayoutControl(layoutClass);
        this.applyAttributes(node, lc);
        return lc;
    }

    protected void applyAttributes(AXmlNode node, AndroidLayoutControl lc) {
        Map<String, AXmlAttribute<?>> attributes = node.getAttributes();
        for (Map.Entry<String, AXmlAttribute<?>> entry : attributes.entrySet()) {
            if (entry.getKey() == null) continue;
            String attrName = entry.getKey().trim();
            AXmlAttribute<?> attr = entry.getValue();
            if (attrName.isEmpty() || !this.isAndroidNamespace(attr.getNamespace())) continue;
            lc.handleAttribute(attr, this.loadAdditionalAttributes);
        }
    }

    protected AndroidLayoutControl createLayoutControl(SootClass layoutClass) {
        if (this.scEditText != null && Scene.v().getFastHierarchy().canStoreType((Type)layoutClass.getType(), (Type)this.scEditText.getType())) {
            return new EditTextControl(layoutClass);
        }
        return new GenericLayoutControl(layoutClass);
    }

    public void setLoadAdditionalAttributes(boolean loadAdditionalAttributes) {
        this.loadAdditionalAttributes = loadAdditionalAttributes;
    }

    protected boolean isAndroidNamespace(String ns) {
        if (ns == null) {
            return false;
        }
        if ((ns = ns.trim()).startsWith("*")) {
            ns = ns.substring(1);
        }
        return ns.equals("http://schemas.android.com/apk/res/android");
    }
}

