/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.axml;

import soot.jimple.infoflow.android.axml.AXmlElement;
import soot.jimple.infoflow.android.resources.ARSCFileParser;

public class AXmlAttribute<T>
extends AXmlElement {
    protected String name;
    protected int type;
    protected T value;
    protected int resourceId;

    public AXmlAttribute(String name, T value, String ns) {
        this(name, -1, value, ns, true);
    }

    public AXmlAttribute(String name, int resourceId, T value, String ns) {
        this(name, resourceId, value, ns, true);
    }

    public AXmlAttribute(String name, int resourceId, T value, String ns, boolean added) {
        this(name, resourceId, -1, value, ns, added);
    }

    public AXmlAttribute(String name, int resourceId, int type, T value, String ns, boolean added) {
        super(ns, added);
        this.name = name;
        this.resourceId = resourceId;
        this.type = type;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public int getResourceId() {
        return this.resourceId;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public int getType() {
        if (this.value instanceof Integer) {
            return 17;
        }
        if (this.value instanceof Boolean) {
            return 18;
        }
        return 3;
    }

    public int getAttributeType() {
        return this.type;
    }

    public String toString() {
        return this.name + "=\"" + String.valueOf(this.value) + "\"";
    }

    public boolean asBoolean() {
        return !this.getValue().equals(Boolean.FALSE);
    }

    public boolean asBoolean(ARSCFileParser arscParser) {
        if (this.type == 1 && this.value instanceof Integer) {
            ARSCFileParser.AbstractResource res = arscParser.findResource((Integer)this.value);
            if (res instanceof ARSCFileParser.BooleanResource) {
                return ((ARSCFileParser.BooleanResource)res).getValue();
            }
            return false;
        }
        return this.asBoolean();
    }

    public String asString() {
        return (String)this.value;
    }

    public String asString(ARSCFileParser arscParser) {
        if (this.type == 1 && this.value instanceof Integer) {
            ARSCFileParser.AbstractResource res = arscParser.findResource((Integer)this.value);
            if (res instanceof ARSCFileParser.StringResource) {
                return ((ARSCFileParser.StringResource)res).getValue();
            }
            return null;
        }
        return this.asString();
    }

    public int asInteger() {
        if (this.value instanceof Integer) {
            return (Integer)this.value;
        }
        return this.value == null ? -1 : Integer.valueOf((String)this.value);
    }

    public int asInteger(ARSCFileParser arscParser) {
        if (this.type == 1 && this.value instanceof Integer) {
            ARSCFileParser.AbstractResource res = arscParser.findResource((Integer)this.value);
            if (res instanceof ARSCFileParser.IntegerResource) {
                return ((ARSCFileParser.IntegerResource)res).getValue();
            }
            return -1;
        }
        return this.asInteger();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.resourceId;
        result = 31 * result + this.type;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AXmlAttribute other = (AXmlAttribute)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.resourceId != other.resourceId) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

