/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.callbacks;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.solver.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.AnySubType;
import soot.Body;
import soot.FastHierarchy;
import soot.Local;
import soot.PointsToSet;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.ClassConstant;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.infoflow.android.InfoflowAndroidConfiguration;
import soot.jimple.infoflow.android.callbacks.AndroidCallbackDefinition;
import soot.jimple.infoflow.android.callbacks.filters.ICallbackFilter;
import soot.jimple.infoflow.android.source.parsers.xml.ResourceUtils;
import soot.jimple.infoflow.typing.TypeUtils;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.jimple.infoflow.values.IValueProvider;
import soot.jimple.infoflow.values.SimpleConstantValueProvider;
import soot.jimple.toolkits.callgraph.Edge;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.SimpleLocalDefs;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public abstract class AbstractCallbackAnalyzer {
    private static final String SIG_CAR_CREATE = "<android.car.Car: android.car.Car createCar(android.content.Context,android.content.ServiceConnection)>";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final SootClass scContext = Scene.v().getSootClassUnsafe("android.content.Context");
    protected final SootClass scBroadcastReceiver = Scene.v().getSootClassUnsafe("android.content.BroadcastReceiver");
    protected final SootClass scServiceConnection = Scene.v().getSootClassUnsafe("android.content.ServiceConnection");
    protected final SootClass scFragmentTransaction = Scene.v().getSootClassUnsafe("android.app.FragmentTransaction");
    protected final SootClass scFragment = Scene.v().getSootClassUnsafe("android.app.Fragment");
    protected final SootClass scSupportFragmentTransaction = Scene.v().getSootClassUnsafe("android.support.v4.app.FragmentTransaction");
    protected final SootClass scAndroidXFragmentTransaction = Scene.v().getSootClassUnsafe("androidx.fragment.app.FragmentTransaction");
    protected final SootClass scSupportFragment = Scene.v().getSootClassUnsafe("android.support.v4.app.Fragment");
    protected final SootClass scAndroidXFragment = Scene.v().getSootClassUnsafe("androidx.fragment.app.Fragment");
    protected final SootClass scSupportViewPager = Scene.v().getSootClassUnsafe("android.support.v4.view.ViewPager");
    protected final SootClass scAndroidXViewPager = Scene.v().getSootClassUnsafe("androidx.viewpager.widget.ViewPager");
    protected final SootClass scFragmentStatePagerAdapter = Scene.v().getSootClassUnsafe("android.support.v4.app.FragmentStatePagerAdapter");
    protected final SootClass scFragmentPagerAdapter = Scene.v().getSootClassUnsafe("android.support.v4.app.FragmentPagerAdapter");
    protected final SootClass scAndroidXFragmentStatePagerAdapter = Scene.v().getSootClassUnsafe("androidx.fragment.app.FragmentStatePagerAdapter");
    protected final SootClass scAndroidXFragmentPagerAdapter = Scene.v().getSootClassUnsafe("androidx.fragment.app.FragmentPagerAdapter");
    protected final InfoflowAndroidConfiguration config;
    protected final Set<SootClass> entryPointClasses;
    protected final Set<String> androidCallbacks;
    protected final MultiMap<SootClass, AndroidCallbackDefinition> callbackMethods = new HashMultiMap();
    protected final MultiMap<SootClass, Integer> layoutClasses = new HashMultiMap();
    protected final Set<SootClass> dynamicManifestComponents = new HashSet<SootClass>();
    protected final MultiMap<SootClass, SootClass> fragmentClasses = new HashMultiMap();
    protected final MultiMap<SootClass, SootClass> fragmentClassesRev = new HashMultiMap();
    protected final Map<SootClass, Integer> fragmentIDs = new HashMap<SootClass, Integer>();
    protected final List<ICallbackFilter> callbackFilters = new ArrayList<ICallbackFilter>();
    protected final Set<SootClass> excludedEntryPoints = new HashSet<SootClass>();
    protected IValueProvider valueProvider = new SimpleConstantValueProvider();
    protected LoadingCache<SootField, List<Type>> arrayToContentTypes = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<SootField, List<Type>>(){

        public List<Type> load(SootField field) throws Exception {
            ArrayList<Type> typeList = new ArrayList<Type>();
            field.getDeclaringClass().getMethods().stream().filter(m -> m.isConcrete()).map(m -> m.retrieveActiveBody()).forEach(b -> {
                Value lop;
                Value rop;
                AssignStmt assignStmt;
                HashSet<Local> arrayLocals = new HashSet<Local>();
                for (Unit u : b.getUnits()) {
                    if (!(u instanceof AssignStmt)) continue;
                    assignStmt = (AssignStmt)u;
                    rop = assignStmt.getRightOp();
                    lop = assignStmt.getLeftOp();
                    if (rop instanceof FieldRef && ((FieldRef)rop).getField() == field) {
                        arrayLocals.add((Local)lop);
                        continue;
                    }
                    if (!(lop instanceof FieldRef) || ((FieldRef)lop).getField() != field) continue;
                    arrayLocals.add((Local)rop);
                }
                for (Unit u : b.getUnits()) {
                    if (!(u instanceof AssignStmt)) continue;
                    assignStmt = (AssignStmt)u;
                    rop = assignStmt.getRightOp();
                    lop = assignStmt.getLeftOp();
                    if (!(rop instanceof CastExpr)) continue;
                    CastExpr ce = (CastExpr)rop;
                    if (arrayLocals.contains(ce.getOp())) {
                        arrayLocals.add((Local)lop);
                        continue;
                    }
                    if (!arrayLocals.contains(lop)) continue;
                    arrayLocals.add((Local)ce.getOp());
                }
                for (Unit u : b.getUnits()) {
                    Type t;
                    ArrayRef arrayRef;
                    if (!(u instanceof AssignStmt)) continue;
                    assignStmt = (AssignStmt)u;
                    rop = assignStmt.getRightOp();
                    lop = assignStmt.getLeftOp();
                    if (!(lop instanceof ArrayRef) || !arrayLocals.contains((arrayRef = (ArrayRef)lop).getBase()) || !((t = rop.getType()) instanceof RefType)) continue;
                    typeList.add(rop.getType());
                }
            });
            return typeList;
        }
    });
    private MultiMap<SootMethod, Stmt> javaScriptInterfaces = new HashMultiMap();

    public AbstractCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<SootClass> entryPointClasses) throws IOException {
        this(config, entryPointClasses, "AndroidCallbacks.txt");
    }

    public AbstractCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<SootClass> entryPointClasses, String callbackFile) throws IOException {
        this(config, entryPointClasses, AbstractCallbackAnalyzer.loadAndroidCallbacks(callbackFile));
    }

    public AbstractCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<SootClass> entryPointClasses, InputStream inputStream) throws IOException {
        this(config, entryPointClasses, AbstractCallbackAnalyzer.loadAndroidCallbacks(new InputStreamReader(inputStream)));
    }

    public AbstractCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<SootClass> entryPointClasses, Reader reader) throws IOException {
        this(config, entryPointClasses, AbstractCallbackAnalyzer.loadAndroidCallbacks(reader));
    }

    public AbstractCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<SootClass> entryPointClasses, Set<String> androidCallbacks) throws IOException {
        this.config = config;
        this.entryPointClasses = entryPointClasses;
        this.androidCallbacks = androidCallbacks;
    }

    private static Set<String> loadAndroidCallbacks(String androidCallbackFile) throws IOException {
        String fileName = androidCallbackFile;
        if (!new File(fileName).exists() && !new File(fileName = "../soot-infoflow-android/AndroidCallbacks.txt").exists()) {
            try (InputStream is = ResourceUtils.getResourceStream("/AndroidCallbacks.txt");){
                Set<String> set = AbstractCallbackAnalyzer.loadAndroidCallbacks(new InputStreamReader(is));
                return set;
            }
        }
        try (FileReader fr = new FileReader(fileName);){
            Set<String> set = AbstractCallbackAnalyzer.loadAndroidCallbacks(fr);
            return set;
        }
    }

    public static Set<String> loadAndroidCallbacks(Reader reader) throws IOException {
        HashSet<String> androidCallbacks = new HashSet<String>();
        try (BufferedReader bufReader = new BufferedReader(reader);){
            String line;
            while ((line = bufReader.readLine()) != null) {
                if (line.isEmpty()) continue;
                androidCallbacks.add(line);
            }
        }
        return androidCallbacks;
    }

    public void collectCallbackMethods() {
        for (ICallbackFilter filter : this.callbackFilters) {
            filter.reset();
        }
    }

    protected void analyzeMethodForCallbackRegistrations(SootClass lifecycleElement, SootMethod method) {
        if (SystemClassHandler.v().isClassInSystemPackage(method.getDeclaringClass())) {
            return;
        }
        if (!method.isConcrete()) {
            return;
        }
        HashSet<SootClass> callbackClasses = new HashSet<SootClass>();
        for (Unit u : method.retrieveActiveBody().getUnits()) {
            Stmt stmt = (Stmt)u;
            if (!stmt.containsInvokeExpr() || !(stmt.getInvokeExpr() instanceof InstanceInvokeExpr)) continue;
            InstanceInvokeExpr iinv = (InstanceInvokeExpr)stmt.getInvokeExpr();
            SootMethodRef mref = iinv.getMethodRef();
            for (int i = 0; i < iinv.getArgCount(); ++i) {
                String param;
                Type type = mref.getParameterType(i);
                if (!(type instanceof RefType) || !this.androidCallbacks.contains(param = type.toString())) continue;
                Value arg = iinv.getArg(i);
                if (!SystemClassHandler.v().isClassInSystemPackage(iinv.getMethod().getDeclaringClass()) || !(arg instanceof Local)) continue;
                Set possibleTypes = Scene.v().getPointsToAnalysis().reachingObjects((Local)arg).possibleTypes();
                if (possibleTypes.isEmpty()) {
                    Type argType = ((Local)arg).getType();
                    this.checkAndAddCallback(callbackClasses, argType);
                    continue;
                }
                for (Type possibleType : possibleTypes) {
                    this.checkAndAddCallback(callbackClasses, possibleType);
                }
            }
        }
        for (SootClass callbackClass : callbackClasses) {
            this.analyzeClassInterfaceCallbacks(callbackClass, callbackClass, lifecycleElement);
        }
    }

    protected void checkAndAddCallback(Set<SootClass> callbackClasses, Type argType) {
        if (argType instanceof RefType) {
            RefType baseType = (RefType)argType;
            SootClass targetClass = baseType.getSootClass();
            if (!SystemClassHandler.v().isClassInSystemPackage(targetClass)) {
                callbackClasses.add(targetClass);
            }
        } else if (argType instanceof AnySubType) {
            RefType baseType = ((AnySubType)argType).getBase();
            SootClass baseClass = baseType.getSootClass();
            for (SootClass sc : TypeUtils.getAllDerivedClasses((SootClass)baseClass)) {
                if (SystemClassHandler.v().isClassInSystemPackage(sc)) continue;
                callbackClasses.add(sc);
            }
        } else {
            this.logger.warn("Unsupported type detected in callback analysis");
        }
    }

    private boolean filterAccepts(SootClass lifecycleElement, SootClass targetClass) {
        for (ICallbackFilter filter : this.callbackFilters) {
            if (filter.accepts(lifecycleElement, targetClass)) continue;
            return false;
        }
        return true;
    }

    private boolean filterAccepts(SootClass lifecycleElement, SootMethod targetMethod) {
        for (ICallbackFilter filter : this.callbackFilters) {
            if (filter.accepts(lifecycleElement, targetMethod)) continue;
            return false;
        }
        return true;
    }

    protected void analyzeMethodForDynamicBroadcastReceiver(SootMethod method) {
        if (SystemClassHandler.v().isClassInSystemPackage(method.getDeclaringClass())) {
            return;
        }
        if (!method.isConcrete() || !method.hasActiveBody()) {
            return;
        }
        FastHierarchy fastHierarchy = Scene.v().getFastHierarchy();
        RefType contextType = this.scContext.getType();
        for (Unit u : method.getActiveBody().getUnits()) {
            Value br;
            InvokeExpr iexpr;
            SootMethodRef methodRef;
            Stmt stmt = (Stmt)u;
            if (!stmt.containsInvokeExpr() || !(methodRef = (iexpr = stmt.getInvokeExpr()).getMethodRef()).getName().equals("registerReceiver") || iexpr.getArgCount() <= 0 || !fastHierarchy.canStoreType((Type)methodRef.getDeclaringClass().getType(), (Type)contextType) || !((br = iexpr.getArg(0)).getType() instanceof RefType)) continue;
            RefType rt = (RefType)br.getType();
            if (SystemClassHandler.v().isClassInSystemPackage(rt.getSootClass())) continue;
            this.dynamicManifestComponents.add(rt.getSootClass());
        }
    }

    protected void analyzeMethodForJavascriptInterfaces(SootMethod method) {
        if (SystemClassHandler.v().isClassInSystemPackage(method.getDeclaringClass().getName())) {
            return;
        }
        if (!method.isConcrete() || !method.hasActiveBody()) {
            return;
        }
        FastHierarchy fastHierarchy = Scene.v().getFastHierarchy();
        RefType webViewType = RefType.v((String)"android.webkit.WebView");
        for (Unit u : method.getActiveBody().getUnits()) {
            InvokeExpr iexpr;
            SootMethodRef methodRef;
            Stmt stmt = (Stmt)u;
            if (!stmt.containsInvokeExpr() || !(methodRef = (iexpr = stmt.getInvokeExpr()).getMethodRef()).getName().equals("addJavascriptInterface") || iexpr.getArgCount() != 2 || !fastHierarchy.canStoreType((Type)methodRef.getDeclaringClass().getType(), (Type)webViewType)) continue;
            this.javaScriptInterfaces.put((Object)method, (Object)stmt);
        }
    }

    protected void analyzeMethodForServiceConnection(SootMethod method) {
        if (SystemClassHandler.v().isClassInSystemPackage(method.getDeclaringClass())) {
            return;
        }
        if (!method.isConcrete() || !method.hasActiveBody()) {
            return;
        }
        for (Unit u : method.getActiveBody().getUnits()) {
            InvokeExpr iexpr;
            SootMethodRef methodRef;
            Stmt stmt = (Stmt)u;
            if (!stmt.containsInvokeExpr() || !(methodRef = (iexpr = stmt.getInvokeExpr()).getMethodRef()).getSignature().equals(SIG_CAR_CREATE)) continue;
            Value br = iexpr.getArg(1);
            if (br instanceof Local && Scene.v().hasPointsToAnalysis()) {
                PointsToSet pts = Scene.v().getPointsToAnalysis().reachingObjects((Local)br);
                for (Type tp : pts.possibleTypes()) {
                    if (!(tp instanceof RefType)) continue;
                    RefType rt = (RefType)tp;
                    if (SystemClassHandler.v().isClassInSystemPackage(rt.getSootClass())) continue;
                    this.dynamicManifestComponents.add(rt.getSootClass());
                }
            }
            if (!(br.getType() instanceof RefType)) continue;
            RefType rt = (RefType)br.getType();
            if (SystemClassHandler.v().isClassInSystemPackage(rt.getSootClass())) continue;
            this.dynamicManifestComponents.add(rt.getSootClass());
        }
    }

    protected void analyzeMethodForFragmentTransaction(SootClass lifecycleElement, SootMethod method) {
        Stmt stmt;
        if (!(this.scFragment != null && this.scFragmentTransaction != null || this.scSupportFragment != null && this.scSupportFragmentTransaction != null || this.scAndroidXFragment != null && this.scAndroidXFragmentTransaction != null)) {
            return;
        }
        if (!method.isConcrete() || !method.hasActiveBody()) {
            return;
        }
        boolean isFragmentManager = false;
        boolean isFragmentTransaction = false;
        boolean isAddTransaction = false;
        for (Unit u : method.getActiveBody().getUnits()) {
            Value arg;
            Integer fragmentID;
            stmt = (Stmt)u;
            if (!stmt.containsInvokeExpr()) continue;
            String methodName = stmt.getInvokeExpr().getMethod().getName();
            if (methodName.equals("getFragmentManager") || methodName.equals("getSupportFragmentManager")) {
                isFragmentManager = true;
                continue;
            }
            if (methodName.equals("beginTransaction")) {
                isFragmentTransaction = true;
                continue;
            }
            if (methodName.equals("add") || methodName.equals("replace")) {
                isAddTransaction = true;
                continue;
            }
            if (!methodName.equals("inflate") || stmt.getInvokeExpr().getArgCount() <= 1 || (fragmentID = (Integer)this.valueProvider.getValue(method, stmt, arg = stmt.getInvokeExpr().getArg(0), Integer.class)) == null) continue;
            this.fragmentIDs.put(lifecycleElement, fragmentID);
        }
        if (isFragmentManager && isFragmentTransaction && isAddTransaction) {
            for (Unit u : method.getActiveBody().getUnits()) {
                InvokeExpr invExpr;
                stmt = (Stmt)u;
                if (!stmt.containsInvokeExpr() || !((invExpr = stmt.getInvokeExpr()) instanceof InstanceInvokeExpr)) continue;
                InstanceInvokeExpr iinvExpr = (InstanceInvokeExpr)invExpr;
                isFragmentTransaction = this.scFragmentTransaction != null && Scene.v().getFastHierarchy().canStoreType(iinvExpr.getBase().getType(), (Type)this.scFragmentTransaction.getType());
                isFragmentTransaction |= this.scSupportFragmentTransaction != null && Scene.v().getFastHierarchy().canStoreType(iinvExpr.getBase().getType(), (Type)this.scSupportFragmentTransaction.getType());
                boolean bl = isAddTransaction = stmt.getInvokeExpr().getMethod().getName().equals("add") || stmt.getInvokeExpr().getMethod().getName().equals("replace");
                if (!(isFragmentTransaction |= this.scAndroidXFragmentTransaction != null && Scene.v().getFastHierarchy().canStoreType(iinvExpr.getBase().getType(), (Type)this.scAndroidXFragmentTransaction.getType())) || !isAddTransaction) continue;
                for (int i = 0; i < stmt.getInvokeExpr().getArgCount(); ++i) {
                    Value br = stmt.getInvokeExpr().getArg(i);
                    if (!(br.getType() instanceof RefType)) continue;
                    RefType rt = (RefType)br.getType();
                    if (br instanceof ClassConstant) {
                        rt = (RefType)((ClassConstant)br).toSootType();
                    }
                    boolean addFragment = this.scFragment != null && Scene.v().getFastHierarchy().canStoreType((Type)rt, (Type)this.scFragment.getType());
                    addFragment |= this.scSupportFragment != null && Scene.v().getFastHierarchy().canStoreType((Type)rt, (Type)this.scSupportFragment.getType());
                    if (!(addFragment |= this.scAndroidXFragment != null && Scene.v().getFastHierarchy().canStoreType((Type)rt, (Type)this.scAndroidXFragment.getType()))) continue;
                    this.checkAndAddFragment(method.getDeclaringClass(), rt.getSootClass());
                }
            }
        }
    }

    protected void analyzeMethodForViewPagers(SootClass clazz, SootMethod method) {
        if (this.scSupportViewPager == null && this.scAndroidXViewPager == null) {
            return;
        }
        if (this.scFragmentStatePagerAdapter == null && this.scAndroidXFragmentStatePagerAdapter == null && this.scFragmentPagerAdapter == null && this.scAndroidXFragmentPagerAdapter == null) {
            return;
        }
        if (!method.isConcrete()) {
            return;
        }
        Body body = method.retrieveActiveBody();
        for (Unit u : body.getUnits()) {
            Body b;
            Value pa;
            InstanceInvokeExpr iinvExpr;
            InvokeExpr invExpr;
            Stmt stmt = (Stmt)u;
            if (!stmt.containsInvokeExpr() || !((invExpr = stmt.getInvokeExpr()) instanceof InstanceInvokeExpr) || !this.safeIsType((iinvExpr = (InstanceInvokeExpr)invExpr).getBase(), this.scSupportViewPager) && !this.safeIsType(iinvExpr.getBase(), this.scAndroidXViewPager) || !stmt.getInvokeExpr().getMethod().getName().equals("setAdapter") || stmt.getInvokeExpr().getArgCount() != 1 || !((pa = stmt.getInvokeExpr().getArg(0)).getType() instanceof RefType)) continue;
            RefType rt = (RefType)pa.getType();
            if (!this.safeIsType(pa, this.scFragmentStatePagerAdapter) && !this.safeIsType(pa, this.scAndroidXFragmentStatePagerAdapter) && !this.safeIsType(pa, this.scFragmentPagerAdapter) && !this.safeIsType(pa, this.scAndroidXFragmentPagerAdapter)) continue;
            SootMethod getItem = rt.getSootClass().getMethodUnsafe("android.support.v4.app.Fragment getItem(int)");
            if (getItem == null) {
                getItem = rt.getSootClass().getMethodUnsafe("androidx.fragment.app.Fragment getItem(int)");
            }
            if (getItem == null || !getItem.isConcrete() || (b = getItem.retrieveActiveBody()) == null) continue;
            for (Unit getItemUnit : b.getUnits()) {
                ReturnStmt rs;
                Value rv;
                Type type;
                if (!(getItemUnit instanceof ReturnStmt) || !((type = (rv = (rs = (ReturnStmt)getItemUnit).getOp()).getType()) instanceof RefType)) continue;
                SootClass rtClass = ((RefType)type).getSootClass();
                if (rv instanceof Local && (rtClass.getName().startsWith("android.") || rtClass.getName().startsWith("androidx."))) {
                    this.analyzeFragmentCandidates((Stmt)rs, getItem, (Local)rv);
                    continue;
                }
                this.checkAndAddFragment(method.getDeclaringClass(), rtClass);
            }
        }
    }

    private void analyzeFragmentCandidates(Stmt s, SootMethod m, Local l) {
        ExceptionalUnitGraph g = ExceptionalUnitGraphFactory.createExceptionalUnitGraph((Body)m.getActiveBody());
        SimpleLocalDefs lds = new SimpleLocalDefs((UnitGraph)g);
        ArrayList<Pair> toSearch = new ArrayList<Pair>();
        HashSet<Pair> doneSet = new HashSet<Pair>();
        toSearch.add(new Pair((Object)l, (Object)s));
        while (!toSearch.isEmpty()) {
            Pair pair = (Pair)toSearch.remove(0);
            if (!doneSet.add(pair)) continue;
            List defs = lds.getDefsOfAt((Local)pair.getO1(), (Unit)pair.getO2());
            for (Unit def : defs) {
                if (!(def instanceof AssignStmt)) continue;
                AssignStmt assignStmt = (AssignStmt)def;
                Value rop = assignStmt.getRightOp();
                if (rop instanceof ArrayRef) {
                    ArrayRef arrayRef = (ArrayRef)rop;
                    toSearch.add(new Pair((Object)((Local)arrayRef.getBase()), (Object)assignStmt));
                    continue;
                }
                if (!(rop instanceof FieldRef)) continue;
                FieldRef fieldRef = (FieldRef)rop;
                try {
                    List typeList = (List)this.arrayToContentTypes.get((Object)fieldRef.getField());
                    typeList.stream().map(t -> ((RefType)t).getSootClass()).forEach(c -> this.checkAndAddFragment(m.getDeclaringClass(), (SootClass)c));
                }
                catch (ExecutionException e) {
                    this.logger.error(String.format("Could not load potential types for field %s", fieldRef.getField().getSignature()), (Throwable)e);
                }
            }
        }
    }

    private boolean safeIsType(Value val, SootClass clazz) {
        return clazz != null && Scene.v().getFastHierarchy().canStoreType(val.getType(), (Type)clazz.getType());
    }

    protected boolean isInheritedMethod(Stmt stmt, String ... classNames) {
        if (!stmt.containsInvokeExpr()) {
            return false;
        }
        SootMethod tgt = stmt.getInvokeExpr().getMethod();
        for (String className : classNames) {
            if (!className.equals(tgt.getDeclaringClass().getName())) continue;
            return true;
        }
        if (Scene.v().hasCallGraph()) {
            Iterator edgeIt = Scene.v().getCallGraph().edgesOutOf((Unit)stmt);
            while (edgeIt.hasNext()) {
                Edge edge = (Edge)edgeIt.next();
                String targetClass = edge.getTgt().method().getDeclaringClass().getName();
                for (String className : classNames) {
                    if (!className.equals(targetClass)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean invokesSetContentView(InvokeExpr inv) {
        String methodName = SootMethodRepresentationParser.v().getMethodNameFromSubSignature(inv.getMethodRef().getSubSignature().getString());
        if (!methodName.equals("setContentView")) {
            return false;
        }
        SootClass curClass = inv.getMethod().getDeclaringClass();
        while (curClass != null) {
            String curClassName = curClass.getName();
            if (curClassName.equals("android.app.Activity") || curClassName.equals("android.support.v7.app.ActionBarActivity") || curClassName.equals("android.support.v7.app.AppCompatActivity") || curClassName.equals("androidx.appcompat.app.AppCompatActivity")) {
                return true;
            }
            curClass = curClass.hasSuperclass() ? curClass.getSuperclass() : null;
        }
        return false;
    }

    protected boolean invokesInflate(InvokeExpr inv) {
        String methodName = SootMethodRepresentationParser.v().getMethodNameFromSubSignature(inv.getMethodRef().getSubSignature().getString());
        if (!methodName.equals("inflate")) {
            return false;
        }
        SootClass curClass = inv.getMethod().getDeclaringClass();
        while (curClass != null) {
            String curClassName = curClass.getName();
            if (curClassName.equals("android.app.Fragment") || curClassName.equals("android.view.LayoutInflater")) {
                return true;
            }
            curClass = curClass.hasSuperclass() ? curClass.getSuperclass() : null;
        }
        return false;
    }

    protected void analyzeMethodOverrideCallbacks(SootClass sootClass) {
        if (!sootClass.isConcrete()) {
            return;
        }
        if (sootClass.isInterface()) {
            return;
        }
        if (this.config.getIgnoreFlowsInSystemPackages() && SystemClassHandler.v().isClassInSystemPackage(sootClass)) {
            return;
        }
        HashMap<String, SootMethod> systemMethods = new HashMap<String, SootMethod>(10000);
        for (SootClass parentClass : Scene.v().getActiveHierarchy().getSuperclassesOf(sootClass)) {
            if (!SystemClassHandler.v().isClassInSystemPackage(parentClass)) continue;
            for (SootMethod sm : parentClass.getMethods()) {
                if (sm.isConstructor()) continue;
                systemMethods.put(sm.getSubSignature(), sm);
            }
        }
        for (SootClass parentClass : Scene.v().getActiveHierarchy().getSuperclassesOfIncluding(sootClass)) {
            if (SystemClassHandler.v().isClassInSystemPackage(parentClass)) continue;
            for (SootMethod method : parentClass.getMethods()) {
                SootMethod parentMethod;
                if (method.hasTag("SimulatedCodeElementTag") || (parentMethod = (SootMethod)systemMethods.get(method.getSubSignature())) == null || !this.checkAndAddMethod(method, parentMethod, sootClass, AndroidCallbackDefinition.CallbackType.Default)) continue;
                systemMethods.remove(parentMethod.getSubSignature());
            }
        }
    }

    private SootMethod getMethodFromHierarchyEx(SootClass c, String methodSignature) {
        SootMethod m = c.getMethodUnsafe(methodSignature);
        if (m != null) {
            return m;
        }
        SootClass superClass = c.getSuperclassUnsafe();
        if (superClass != null) {
            return this.getMethodFromHierarchyEx(superClass, methodSignature);
        }
        return null;
    }

    protected void analyzeClassInterfaceCallbacks(SootClass baseClass, SootClass sootClass, SootClass lifecycleElement) {
        if (!baseClass.isConcrete()) {
            return;
        }
        if (SystemClassHandler.v().isClassInSystemPackage(baseClass)) {
            return;
        }
        if (SystemClassHandler.v().isClassInSystemPackage(sootClass)) {
            return;
        }
        if (!this.filterAccepts(lifecycleElement, baseClass)) {
            return;
        }
        if (!this.filterAccepts(lifecycleElement, sootClass)) {
            return;
        }
        SootClass superClass = sootClass.getSuperclassUnsafe();
        if (superClass != null) {
            this.analyzeClassInterfaceCallbacks(baseClass, superClass, lifecycleElement);
        }
        for (SootClass i : this.collectAllInterfaces(sootClass)) {
            this.checkAndAddCallback(i, baseClass, lifecycleElement);
        }
        for (SootClass c : this.collectAllSuperClasses(sootClass)) {
            this.checkAndAddCallback(c, baseClass, lifecycleElement);
        }
    }

    private void checkAndAddCallback(SootClass sc, SootClass baseClass, SootClass lifecycleElement) {
        if (this.androidCallbacks.contains(sc.getName())) {
            AndroidCallbackDefinition.CallbackType callbackType = this.isUICallback(sc) ? AndroidCallbackDefinition.CallbackType.Widget : AndroidCallbackDefinition.CallbackType.Default;
            for (SootMethod sm : sc.getMethods()) {
                SootMethod callbackImplementation = this.getMethodFromHierarchyEx(baseClass, sm.getSubSignature());
                if (callbackImplementation == null) continue;
                this.checkAndAddMethod(callbackImplementation, sm, lifecycleElement, callbackType);
            }
        }
    }

    private boolean isUICallback(SootClass i) {
        return i.getName().startsWith("android.widget") || i.getName().startsWith("android.view") || i.getName().startsWith("android.content.DialogInterface$");
    }

    protected boolean checkAndAddMethod(SootMethod method, SootMethod parentMethod, SootClass lifecycleClass, AndroidCallbackDefinition.CallbackType callbackType) {
        if (SystemClassHandler.v().isClassInSystemPackage(method.getDeclaringClass())) {
            return false;
        }
        if (method.isConcrete() && this.isEmpty(method.retrieveActiveBody())) {
            return false;
        }
        if (method.isConstructor() || method.isStaticInitializer()) {
            return false;
        }
        if (!this.filterAccepts(lifecycleClass, method.getDeclaringClass())) {
            return false;
        }
        if (!this.filterAccepts(lifecycleClass, method)) {
            return false;
        }
        return this.callbackMethods.put((Object)lifecycleClass, (Object)new AndroidCallbackDefinition(method, parentMethod, callbackType));
    }

    protected void checkAndAddFragment(SootClass componentClass, SootClass fragmentClass) {
        this.fragmentClasses.put((Object)componentClass, (Object)fragmentClass);
        this.fragmentClassesRev.put((Object)fragmentClass, (Object)componentClass);
    }

    private boolean isEmpty(Body activeBody) {
        for (Unit u : activeBody.getUnits()) {
            if (u instanceof IdentityStmt || u instanceof ReturnVoidStmt) continue;
            return false;
        }
        return true;
    }

    private Set<SootClass> collectAllInterfaces(SootClass sootClass) {
        HashSet<SootClass> interfaces = new HashSet<SootClass>((Collection<SootClass>)sootClass.getInterfaces());
        for (SootClass i : sootClass.getInterfaces()) {
            interfaces.addAll(this.collectAllInterfaces(i));
        }
        return interfaces;
    }

    private Set<SootClass> collectAllSuperClasses(SootClass sootClass) {
        HashSet<SootClass> classes = new HashSet<SootClass>();
        if (sootClass.hasSuperclass()) {
            classes.add(sootClass.getSuperclass());
            classes.addAll(this.collectAllSuperClasses(sootClass.getSuperclass()));
        }
        return classes;
    }

    public MultiMap<SootClass, AndroidCallbackDefinition> getCallbackMethods() {
        return this.callbackMethods;
    }

    public MultiMap<SootClass, Integer> getLayoutClasses() {
        return this.layoutClasses;
    }

    public MultiMap<SootClass, SootClass> getFragmentClasses() {
        return this.fragmentClasses;
    }

    public Set<SootClass> getDynamicManifestComponents() {
        return this.dynamicManifestComponents;
    }

    public void addCallbackFilter(ICallbackFilter filter) {
        this.callbackFilters.add(filter);
    }

    public void excludeEntryPoint(SootClass entryPoint) {
        this.excludedEntryPoints.add(entryPoint);
    }

    public boolean isExcludedEntryPoint(SootClass entryPoint) {
        return this.excludedEntryPoints.contains(entryPoint);
    }

    public void setValueProvider(IValueProvider valueProvider) {
        this.valueProvider = valueProvider;
    }

    public MultiMap<SootMethod, Stmt> getJavaScriptInterfaces() {
        return this.javaScriptInterfaces;
    }
}

