/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.android.InfoflowAndroidConfiguration;
import soot.jimple.infoflow.android.data.CategoryDefinition;
import soot.jimple.infoflow.android.source.parsers.xml.ResourceUtils;

public class XMLConfigurationParser {
    private static final String XSD_FILE_PATH = "schema/FlowDroidConfiguration.xsd";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private final InputStream xmlStream;

    public static XMLConfigurationParser fromFile(String fileName) throws IOException {
        if (!XMLConfigurationParser.verifyXML(fileName)) {
            throw new RuntimeException("The XML-File isn't valid");
        }
        FileInputStream inputStream = new FileInputStream(fileName);
        return XMLConfigurationParser.fromStream(inputStream);
    }

    public static XMLConfigurationParser fromStream(InputStream inputStream) throws IOException {
        XMLConfigurationParser pmp = new XMLConfigurationParser(inputStream);
        return pmp;
    }

    private XMLConfigurationParser(InputStream stream) {
        this.xmlStream = stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean verifyXML(String fileName) throws IOException {
        SchemaFactory sf = SchemaFactory.newInstance(W3C_XML_SCHEMA);
        StreamSource xsdFile = new StreamSource(ResourceUtils.getResourceStream(XSD_FILE_PATH));
        StreamSource xmlFile = new StreamSource(new File(fileName));
        boolean validXML = false;
        try {
            Schema schema = sf.newSchema(xsdFile);
            Validator validator = schema.newValidator();
            try {
                validator.validate(xmlFile);
                validXML = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!validXML) {
                new IOException("File isn't  valid against the xsd");
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        finally {
            xsdFile.getInputStream().close();
            if (xmlFile.getInputStream() != null) {
                xmlFile.getInputStream().close();
            }
        }
        return validXML;
    }

    public void parse(InfoflowAndroidConfiguration config) {
        SAXParserFactory pf = SAXParserFactory.newInstance();
        try {
            SAXParser parser = pf.newSAXParser();
            parser.parse(this.xmlStream, (DefaultHandler)new SAXHandler(config));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() throws IOException {
        this.xmlStream.close();
    }

    private class SAXHandler
    extends DefaultHandler {
        private final InfoflowAndroidConfiguration config;
        private String currentElement = "";
        private Stack<XMLSection> parseStack = new Stack();
        private boolean enableIccTracking = false;

        public SAXHandler(InfoflowAndroidConfiguration config) {
            this.config = config;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            XMLSection stackElement;
            super.startElement(uri, localName, qName, attributes);
            XMLSection xMLSection = stackElement = this.parseStack.isEmpty() ? null : this.parseStack.peek();
            if (this.parseStack.isEmpty()) {
                if (qName.equals("configuration")) {
                    this.parseStack.push(XMLSection.CONFIGURATION);
                }
            } else if (stackElement == XMLSection.CONFIGURATION) {
                if (qName.equals("inputFiles")) {
                    this.parseStack.push(XMLSection.INPUT_FILES);
                } else if (qName.equals("sources")) {
                    this.parseStack.push(XMLSection.SOURCES);
                    String strDefaultMode = attributes.getValue("defaultMode");
                    if (strDefaultMode != null && !strDefaultMode.isEmpty()) {
                        this.config.getSourceSinkConfig().setSourceFilterMode(InfoflowConfiguration.SourceSinkFilterMode.valueOf((String)strDefaultMode));
                    }
                } else if (qName.equals("sinks")) {
                    this.parseStack.push(XMLSection.SINKS);
                    String strDefaultMode = attributes.getValue("defaultMode");
                    if (strDefaultMode != null && !strDefaultMode.isEmpty()) {
                        this.config.getSourceSinkConfig().setSinkFilterMode(InfoflowConfiguration.SourceSinkFilterMode.valueOf((String)strDefaultMode));
                    }
                } else if (qName.equals("androidConfiguration")) {
                    this.parseStack.push(XMLSection.ANDROID_CONFIGURATION);
                } else if (qName.equals("iccConfiguration")) {
                    this.parseStack.push(XMLSection.ICC_CONFIGURATION);
                } else if (qName.equals("dataFlowConfiguration")) {
                    this.parseStack.push(XMLSection.DATA_FLOW_CONFIGURATION);
                }
            } else if (stackElement == XMLSection.SOURCES) {
                if (qName.equals("category")) {
                    String strId = attributes.getValue("id");
                    String strMode = attributes.getValue("mode");
                    CategoryDefinition catDef = new CategoryDefinition(strId);
                    this.config.getSourceSinkConfig().addSourceCategory(catDef, InfoflowConfiguration.CategoryMode.valueOf((String)strMode));
                }
            } else if (stackElement == XMLSection.SINKS && qName.equals("category")) {
                String strId = attributes.getValue("id");
                String strMode = attributes.getValue("mode");
                CategoryDefinition catDef = new CategoryDefinition(strId);
                this.config.getSourceSinkConfig().addSinkCategory(catDef, InfoflowConfiguration.CategoryMode.valueOf((String)strMode));
            }
            if (stackElement == XMLSection.INPUT_FILES || stackElement == XMLSection.ANDROID_CONFIGURATION || stackElement == XMLSection.ICC_CONFIGURATION || stackElement == XMLSection.DATA_FLOW_CONFIGURATION || stackElement == XMLSection.SINKS || stackElement == XMLSection.SOURCES) {
                this.currentElement = qName;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if (this.currentElement == null || this.currentElement.isEmpty()) {
                this.parseStack.pop();
            }
            this.currentElement = "";
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            String data = new String(ch, start, length);
            if (!this.parseStack.isEmpty()) {
                if (this.parseStack.peek() == XMLSection.INPUT_FILES) {
                    InfoflowAndroidConfiguration.AnalysisFileConfiguration fileConfig = this.config.getAnalysisFileConfig();
                    if (this.currentElement.equals("targetAPK")) {
                        fileConfig.setTargetAPKFile(new File(data));
                    } else if (this.currentElement.equals("sourceSinkFile")) {
                        fileConfig.setSourceSinkFile(new File(data));
                    } else if (this.currentElement.equals("androidPlatform")) {
                        fileConfig.setAndroidPlatformDir(new File(data));
                    } else if (this.currentElement.equals("outputFile")) {
                        fileConfig.setOutputFile(data);
                    }
                } else if (this.parseStack.peek() == XMLSection.ANDROID_CONFIGURATION) {
                    InfoflowAndroidConfiguration.CallbackConfiguration callbackConfig = this.config.getCallbackConfig();
                    InfoflowAndroidConfiguration.SourceSinkConfiguration sourceSinkConfig = this.config.getSourceSinkConfig();
                    if (this.currentElement.equals("enableCallbacks")) {
                        callbackConfig.setEnableCallbacks(Boolean.valueOf(data));
                    } else if (this.currentElement.equals("filterThreadCallbacks")) {
                        callbackConfig.setFilterThreadCallbacks(Boolean.valueOf(data));
                    } else if (this.currentElement.equals("maxCallbacksPerComponent")) {
                        callbackConfig.setMaxCallbacksPerComponent(Integer.valueOf(data));
                    } else if (this.currentElement.equals("maxCallbackDepth")) {
                        callbackConfig.setMaxAnalysisCallbackDepth(Integer.valueOf(data));
                    } else if (this.currentElement.equals("layoutMatchingMode")) {
                        sourceSinkConfig.setLayoutMatchingMode(InfoflowConfiguration.LayoutMatchingMode.valueOf((String)data));
                    } else if (this.currentElement.equals("mergeDexFiles")) {
                        this.config.setMergeDexFiles(Boolean.valueOf(data));
                    } else if (this.currentElement.equals("callbackSourceMode")) {
                        sourceSinkConfig.setCallbackSourceMode(InfoflowConfiguration.CallbackSourceMode.valueOf((String)data));
                    } else if (this.currentElement.equals("callbackAnalysisTimeout")) {
                        callbackConfig.setCallbackAnalysisTimeout(Integer.valueOf(data));
                    }
                } else if (this.parseStack.peek() == XMLSection.ICC_CONFIGURATION) {
                    InfoflowAndroidConfiguration.IccConfiguration iccConfig = this.config.getIccConfig();
                    if (this.currentElement.equals("enableICCTracking")) {
                        this.enableIccTracking = Boolean.valueOf(data);
                    } else if (this.currentElement.equals("modelFile")) {
                        iccConfig.setIccModel(data);
                    } else if (this.currentElement.equals("purifyResults")) {
                        iccConfig.setIccResultsPurify(Boolean.valueOf(data));
                    }
                } else if (this.parseStack.peek() == XMLSection.DATA_FLOW_CONFIGURATION) {
                    InfoflowConfiguration.PathConfiguration pathConfig = this.config.getPathConfiguration();
                    InfoflowConfiguration.SolverConfiguration solverConfig = this.config.getSolverConfiguration();
                    if (this.currentElement.equals("maxJoinPointAbstractions")) {
                        solverConfig.setMaxJoinPointAbstractions(Integer.valueOf(data).intValue());
                    } else if (this.currentElement.equals("maxCalleesPerCallSite")) {
                        solverConfig.setMaxCalleesPerCallSite(Integer.valueOf(data).intValue());
                    } else if (this.currentElement.equals("implicitFlowMode")) {
                        this.config.setImplicitFlowMode(InfoflowConfiguration.ImplicitFlowMode.valueOf((String)data));
                    } else if (this.currentElement.equals("staticFieldTrackingMode")) {
                        this.config.setStaticFieldTrackingMode(InfoflowConfiguration.StaticFieldTrackingMode.valueOf((String)data));
                    } else if (this.currentElement.equals("enableExceptions")) {
                        this.config.setEnableExceptionTracking(Boolean.valueOf(data));
                    } else if (this.currentElement.equals("enableArrays")) {
                        this.config.setEnableArrayTracking(Boolean.valueOf(data));
                    } else if (this.currentElement.equals("enableReflection")) {
                        this.config.setEnableReflection(Boolean.valueOf(data));
                    } else if (this.currentElement.equals("enableLineNumbers")) {
                        this.config.setEnableLineNumbers(Boolean.valueOf(data));
                    } else if (this.currentElement.equals("enableOriginalNames")) {
                        this.config.setEnableOriginalNames(Boolean.valueOf(data));
                    } else if (this.currentElement.equals("flowSensitiveAliasing")) {
                        this.config.setFlowSensitiveAliasing(Boolean.valueOf(data));
                    } else if (this.currentElement.equals("logSourcesAndSinks")) {
                        this.config.setLogSourcesAndSinks(Boolean.valueOf(data));
                    } else if (this.currentElement.equals("enableArraySizeTainting")) {
                        this.config.setEnableArraySizeTainting(Boolean.valueOf(data));
                    } else if (this.currentElement.equals("pathReconstructionMode")) {
                        pathConfig.setPathReconstructionMode(InfoflowConfiguration.PathReconstructionMode.valueOf((String)data));
                    } else if (this.currentElement.equals("pathAgnosticResults")) {
                        this.config.setPathAgnosticResults(Boolean.valueOf(data));
                    } else if (this.currentElement.equals("maxCallStackSize")) {
                        pathConfig.setMaxCallStackSize(Integer.valueOf(data).intValue());
                    } else if (this.currentElement.equals("maxPathLength")) {
                        pathConfig.setMaxPathLength(Integer.valueOf(data).intValue());
                    } else if (this.currentElement.equals("maxPathsPerAbstraction")) {
                        pathConfig.setMaxPathsPerAbstraction(Integer.valueOf(data).intValue());
                    } else if (this.currentElement.equals("dataFlowTimeout")) {
                        this.config.setDataFlowTimeout(Long.valueOf(data));
                    } else if (this.currentElement.equals("pathReconstructionTimeout")) {
                        pathConfig.setPathReconstructionTimeout(Long.valueOf(data).longValue());
                    } else if (this.currentElement.equals("pathReconstructionTimeout")) {
                        pathConfig.setPathReconstructionTimeout(Long.valueOf(data).longValue());
                    } else if (this.currentElement.equals("pathReconstructionBatchSize")) {
                        pathConfig.setPathReconstructionBatchSize(Integer.valueOf(data).intValue());
                    } else if (this.currentElement.equals("writeOutputFiles")) {
                        this.config.setWriteOutputFiles(Boolean.valueOf(data));
                    }
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
            if (!this.enableIccTracking) {
                this.config.getIccConfig().setIccModel(null);
            }
        }
    }

    private static enum XMLSection {
        CONFIGURATION,
        INPUT_FILES,
        SOURCES,
        SINKS,
        ANDROID_CONFIGURATION,
        ICC_CONFIGURATION,
        DATA_FLOW_CONFIGURATION,
        DUMMY;

    }
}

