/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.iccta;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.infoflow.android.iccta.App;
import soot.jimple.infoflow.android.iccta.Ic3Data;
import soot.jimple.infoflow.android.iccta.Ic3ResultLoader;
import soot.jimple.infoflow.android.iccta.IccLink;
import soot.jimple.infoflow.android.iccta.IccLinkProvider;
import soot.jimple.infoflow.android.iccta.Intent;

public class Ic3Provider
implements IccLinkProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String ic3Model = null;

    public Ic3Provider(String ic3Model) {
        this.ic3Model = ic3Model;
    }

    @Override
    public List<IccLink> getIccLinks() {
        ArrayList<IccLink> iccLinks = new ArrayList<IccLink>();
        App app = Ic3ResultLoader.load(this.ic3Model);
        if (null == app) {
            this.logger.error("[IccTA] %s is not a valid IC3 model", (Object)this.ic3Model);
            return iccLinks;
        }
        Set<Intent> intents = app.getIntents();
        for (Intent intent : intents) {
            SootMethod fromSM;
            if (intent.isImplicit()) {
                if (null == intent.getAction()) continue;
                List<Ic3Data.Application.Component> targetedComps = intent.resolve(app.getComponentList());
                for (Ic3Data.Application.Component targetComp : targetedComps) {
                    if (!this.availableTargetedComponent(intent.getApp(), targetComp.getName())) continue;
                    SootMethod fromSM2 = Scene.v().grabMethod(intent.getLoggingPoint().getCallerMethodSignature());
                    Stmt fromU = this.linkWithTarget(fromSM2, intent.getLoggingPoint().getStmtSequence());
                    IccLink iccLink = new IccLink(fromSM2, (Unit)fromU, Scene.v().getSootClassUnsafe(targetComp.getName()));
                    iccLink.setExit_kind(targetComp.getKind().name());
                    iccLinks.add(iccLink);
                }
                continue;
            }
            String targetCompName = intent.getComponentClass();
            if (!this.availableTargetedComponent(intent.getApp(), targetCompName) || (fromSM = Scene.v().grabMethod(intent.getLoggingPoint().getCallerMethodSignature())) == null) continue;
            Stmt fromU = this.linkWithTarget(fromSM, intent.getLoggingPoint().getStmtSequence());
            IccLink iccLink = new IccLink(fromSM, (Unit)fromU, Scene.v().getSootClassUnsafe(targetCompName));
            for (Ic3Data.Application.Component comp : intent.getApp().getComponentList()) {
                if (!comp.getName().equals(targetCompName)) continue;
                iccLink.setExit_kind(comp.getKind().name());
            }
            iccLinks.add(iccLink);
        }
        return iccLinks;
    }

    private Stmt linkWithTarget(SootMethod fromSM, int stmtIdx) {
        Body body = fromSM.retrieveActiveBody();
        int i = 0;
        Iterator iter = body.getUnits().snapshotIterator();
        while (iter.hasNext()) {
            Stmt stmt = (Stmt)iter.next();
            if (i == stmtIdx) {
                return stmt;
            }
            ++i;
        }
        return null;
    }

    private boolean availableTargetedComponent(App app, String targetedComponentName) {
        for (Ic3Data.Application.Component comp : app.getComponentList()) {
            if (!comp.getName().equals(targetedComponentName)) continue;
            return true;
        }
        return false;
    }
}

