/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.manifest.binary;

import soot.jimple.infoflow.android.axml.AXmlAttribute;
import soot.jimple.infoflow.android.axml.AXmlNode;
import soot.jimple.infoflow.android.manifest.BaseProcessManifest;
import soot.jimple.infoflow.android.manifest.IAndroidApplication;
import soot.jimple.infoflow.android.resources.ARSCFileParser;

public class BinaryAndroidApplication
implements IAndroidApplication {
    protected final AXmlNode node;
    protected final BaseProcessManifest<?, ?, ?, ?> manifest;
    protected boolean enabled;
    protected boolean debuggable;
    protected boolean allowBackup;
    protected String name;
    protected Boolean usesCleartextTraffic;

    public BinaryAndroidApplication(AXmlNode node, BaseProcessManifest<?, ?, ?, ?> manifest) {
        this.node = node;
        this.manifest = manifest;
        ARSCFileParser arscParser = manifest.getArscParser();
        AXmlAttribute<?> attrEnabled = node.getAttribute("enabled");
        this.enabled = attrEnabled == null || attrEnabled.asBoolean(arscParser);
        AXmlAttribute<?> attrDebuggable = node.getAttribute("debuggable");
        this.debuggable = attrDebuggable != null && attrDebuggable.asBoolean(arscParser);
        AXmlAttribute<?> attrAllowBackup = node.getAttribute("allowBackup");
        this.allowBackup = attrAllowBackup == null || attrAllowBackup.asBoolean(arscParser);
        AXmlAttribute<?> attrCleartextTraffic = node.getAttribute("usesCleartextTraffic");
        if (attrCleartextTraffic != null) {
            this.usesCleartextTraffic = attrCleartextTraffic.asBoolean(arscParser);
        }
        this.name = this.loadApplicationName();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private String loadApplicationName() {
        AXmlAttribute<?> attr = this.node.getAttribute("name");
        if (attr != null) {
            return attr.asString(this.manifest.getArscParser());
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public AXmlNode getAXmlNode() {
        return this.node;
    }

    @Override
    public boolean isDebuggable() {
        return this.debuggable;
    }

    @Override
    public boolean isAllowBackup() {
        return this.allowBackup;
    }

    @Override
    public Boolean isUsesCleartextTraffic() {
        return this.usesCleartextTraffic;
    }
}

