/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.source.parsers.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.android.data.AndroidMethod;
import soot.jimple.infoflow.android.source.parsers.xml.AbstractXMLSourceSinkParser;
import soot.jimple.infoflow.android.source.parsers.xml.ResourceUtils;
import soot.jimple.infoflow.data.AbstractMethodAndClass;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.sourcesSinks.definitions.AccessPathTuple;
import soot.jimple.infoflow.sourcesSinks.definitions.FieldSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.IAccessPathBasedSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkCategory;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinitionProvider;
import soot.jimple.infoflow.sourcesSinks.definitions.MethodSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.SourceSinkCondition;
import soot.jimple.infoflow.sourcesSinks.definitions.SourceSinkType;
import soot.util.HashMultiMap;

public class XMLSourceSinkParser
extends AbstractXMLSourceSinkParser
implements ISourceSinkDefinitionProvider {
    private static final Logger logger = LoggerFactory.getLogger(XMLSourceSinkParser.class);
    protected static final String XSD_FILE_PATH = "schema/SourcesAndSinks.xsd";
    protected static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

    public static XMLSourceSinkParser fromFile(String fileName) throws IOException {
        return XMLSourceSinkParser.fromFile(fileName, null);
    }

    public static XMLSourceSinkParser fromFile(File file) throws IOException {
        return XMLSourceSinkParser.fromFile(file, null);
    }

    public static XMLSourceSinkParser fromFile(String fileName, AbstractXMLSourceSinkParser.ICategoryFilter categoryFilter) throws IOException {
        logger.info(String.format("Loading sources and sinks from %s...", fileName));
        try (InputStream is = XMLSourceSinkParser.getStream(fileName);){
            XMLSourceSinkParser.verifyXML(is);
        }
        try (InputStream inputStream = XMLSourceSinkParser.getStream(fileName);){
            XMLSourceSinkParser xMLSourceSinkParser = XMLSourceSinkParser.fromStream(inputStream, categoryFilter);
            return xMLSourceSinkParser;
        }
    }

    public static XMLSourceSinkParser fromFile(File file, AbstractXMLSourceSinkParser.ICategoryFilter categoryFilter) throws IOException {
        logger.info(String.format("Loading sources and sinks from %s...", file.getAbsolutePath()));
        try (FileInputStream is = new FileInputStream(file);){
            XMLSourceSinkParser.verifyXML(is);
        }
        try (FileInputStream inputStream = new FileInputStream(file);){
            XMLSourceSinkParser xMLSourceSinkParser = XMLSourceSinkParser.fromStream(inputStream, categoryFilter);
            return xMLSourceSinkParser;
        }
    }

    protected static InputStream getStream(String fileName) throws IOException {
        File f = new File(fileName);
        if (f.exists()) {
            return new FileInputStream(f);
        }
        return ResourceUtils.getResourceStream(fileName);
    }

    public static XMLSourceSinkParser fromStream(InputStream inputStream) throws IOException {
        return XMLSourceSinkParser.fromStream(inputStream, null);
    }

    public static XMLSourceSinkParser fromStream(InputStream inputStream, AbstractXMLSourceSinkParser.ICategoryFilter categoryFilter) throws IOException {
        XMLSourceSinkParser pmp = new XMLSourceSinkParser(categoryFilter);
        pmp.parseInputStream(inputStream);
        return pmp;
    }

    protected XMLSourceSinkParser(AbstractXMLSourceSinkParser.ICategoryFilter categoryFilter) {
        this.sourcesAndSinks = new HashMultiMap();
        this.categoryFilter = categoryFilter;
    }

    @Override
    protected void buildSourceSinkLists() {
        for (ISourceSinkDefinition def : this.sourcesAndSinks.values()) {
            MethodSourceSinkDefinition methodSink;
            ISourceSinkDefinition sinkDef;
            ISourceSinkDefinition sourceDef = def.getSourceOnlyDefinition();
            if (sourceDef != null && !sourceDef.isEmpty()) {
                MethodSourceSinkDefinition methodSrc;
                if (sourceDef instanceof MethodSourceSinkDefinition && (methodSrc = (MethodSourceSinkDefinition)sourceDef).getMethod() instanceof AndroidMethod) {
                    AndroidMethod am = (AndroidMethod)methodSrc.getMethod();
                    am.setSourceSinkType(am.getSourceSinkType().addType(SourceSinkType.Source));
                }
                this.sources.add(sourceDef);
            }
            if ((sinkDef = def.getSinkOnlyDefinition()) == null || sinkDef.isEmpty()) continue;
            if (sourceDef instanceof MethodSourceSinkDefinition && (methodSink = (MethodSourceSinkDefinition)sourceDef).getMethod() instanceof AndroidMethod) {
                AndroidMethod am = (AndroidMethod)methodSink.getMethod();
                am.setSourceSinkType(am.getSourceSinkType().addType(SourceSinkType.Sink));
            }
            this.sinks.add(sinkDef);
        }
        logger.info(String.format("Loaded %d sources and %d sinks from the XML file", this.sources.size(), this.sinks.size()));
    }

    private static void verifyXML(InputStream inp) throws IOException {
        SchemaFactory sf = SchemaFactory.newInstance(W3C_XML_SCHEMA);
        StreamSource xsdFile = new StreamSource(ResourceUtils.getResourceStream(InfoflowConfiguration.getBaseDirectory() + XSD_FILE_PATH));
        StreamSource xmlFile = new StreamSource(inp);
        try {
            Schema schema = sf.newSchema(xsdFile);
            Validator validator = schema.newValidator();
            try {
                validator.validate(xmlFile);
            }
            catch (IOException e) {
                throw new IOException("File isn't  valid against the xsd", e);
            }
        }
        catch (SAXException e) {
            throw new IOException("File isn't  valid against the xsd", e);
        }
        finally {
            xsdFile.getInputStream().close();
            xmlFile.getInputStream().close();
        }
    }

    @Override
    protected ISourceSinkDefinition createMethodSourceSinkDefinition(AbstractMethodAndClass method, Set<AccessPathTuple> baseAPs, Set<AccessPathTuple>[] paramAPs, Set<AccessPathTuple> returnAPs, MethodSourceSinkDefinition.CallType callType, ISourceSinkCategory category) {
        if (method instanceof AndroidMethod) {
            AndroidMethod amethod = (AndroidMethod)method;
            return new MethodSourceSinkDefinition((SootMethodAndClass)amethod, baseAPs, (Set[])paramAPs, returnAPs, callType, category);
        }
        return null;
    }

    @Override
    protected ISourceSinkDefinition createMethodSourceSinkDefinition(AbstractMethodAndClass method, Set<AccessPathTuple> baseAPs, Set<AccessPathTuple>[] paramAPs, Set<AccessPathTuple> returnAPs, MethodSourceSinkDefinition.CallType callType, ISourceSinkCategory category, Set<SourceSinkCondition> conditions) {
        ISourceSinkDefinition ssdef = this.createMethodSourceSinkDefinition(method, baseAPs, paramAPs, returnAPs, callType, category);
        if (ssdef != null) {
            ssdef.setConditions(conditions);
        }
        return ssdef;
    }

    protected IAccessPathBasedSourceSinkDefinition createFieldSourceSinkDefinition(String signature, Set<AccessPathTuple> baseAPs) {
        return new FieldSourceSinkDefinition(signature, baseAPs);
    }

    protected IAccessPathBasedSourceSinkDefinition createFieldSourceSinkDefinition(String signature, Set<AccessPathTuple> baseAPs, Set<SourceSinkCondition> conditions) {
        IAccessPathBasedSourceSinkDefinition ssdef = this.createFieldSourceSinkDefinition(signature, baseAPs);
        ssdef.setConditions(conditions);
        return ssdef;
    }

    @Override
    protected void runParse(SAXParser parser, InputStream stream) {
        try {
            parser.parse(stream, (DefaultHandler)new AbstractXMLSourceSinkParser.SAXHandler(this, this.categoryFilter));
        }
        catch (IOException | SAXException e) {
            e.printStackTrace();
        }
    }
}

