/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.collections.codeOptimization;

import java.io.File;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.android.InfoflowAndroidConfiguration;
import soot.jimple.infoflow.android.SetupApplication;
import soot.jimple.infoflow.android.resources.ARSCFileParser;
import soot.jimple.infoflow.codeOptimization.ICodeOptimizer;
import soot.jimple.infoflow.collections.codeOptimization.ReplacementCandidates;
import soot.jimple.infoflow.entryPointCreators.SimulatedCodeElementTag;
import soot.jimple.infoflow.sourcesSinks.manager.ISourceSinkManager;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.tagkit.Tag;
import soot.util.queue.QueueReader;

public class StringResourcesResolver
implements ICodeOptimizer {
    private static final String CONTEXT_CLASS = "android.content.Context";
    private static final String RESOURCE_CLASS = "android.content.res.Resources";
    private static final String GET_STRING_SUBSIG = "java.lang.String getString(int)";
    private static final String GET_INT_SUBSIG = "int getInteger(int)";
    private static final String GET_BOOL_SUBSIG = "boolean getBoolean(int)";
    private static final String GET_FLOAT_SUBSIG = "float getFloat(int)";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SetupApplication setupApplication;
    private File apkFile = null;
    private int runtime = -1;
    private int replaced = -1;

    public StringResourcesResolver(SetupApplication setupApplication) {
        this.setupApplication = setupApplication;
    }

    public int getRuntime() {
        return this.runtime;
    }

    public int getReplacedStatementCount() {
        return this.replaced;
    }

    public void initialize(InfoflowConfiguration config) {
        if (config instanceof InfoflowAndroidConfiguration) {
            this.apkFile = ((InfoflowAndroidConfiguration)config).getAnalysisFileConfig().getTargetAPKFile();
        }
    }

    public void run(InfoflowManager manager, Collection<SootMethod> excluded, ISourceSinkManager sourcesSinks, ITaintPropagationWrapper taintWrapper) {
        SootClass resourceClass;
        if (manager.getConfig().getCodeEliminationMode() == InfoflowConfiguration.CodeEliminationMode.NoCodeElimination) {
            return;
        }
        if (this.apkFile == null) {
            return;
        }
        long beforeOptimization = System.nanoTime();
        ARSCFileParser parser = this.setupApplication.getResources();
        if (parser == null) {
            this.logger.error("Could get the ARSC file parser! Aborting string resource resolving...");
            return;
        }
        assert (parser != null);
        SootClass contextClass = Scene.v().getSootClassUnsafe(CONTEXT_CLASS);
        if (contextClass == null) {
            this.logger.warn("Could not load class android.content.Context.");
        }
        if ((resourceClass = Scene.v().getSootClassUnsafe(RESOURCE_CLASS)) == null) {
            this.logger.warn("Could not load class android.content.res.Resources.");
        }
        ReplacementCandidates rcs = new ReplacementCandidates();
        QueueReader rdr = Scene.v().getReachableMethods().listener();
        while (rdr.hasNext()) {
            MethodOrMethodContext sm = (MethodOrMethodContext)rdr.next();
            SootMethod method = sm.method();
            if (method == null || !method.isConcrete() || excluded.contains(method)) continue;
            UnitPatchingChain chain = method.retrieveActiveBody().getUnits();
            for (Unit unit : chain) {
                StringConstant c;
                Value arg0;
                boolean resourceGet;
                boolean contextGetString;
                Stmt stmt = (Stmt)unit;
                if (!stmt.containsInvokeExpr() || !(stmt instanceof AssignStmt)) continue;
                SootMethod callee = stmt.getInvokeExpr().getMethod();
                String subSig = callee.getSubSignature();
                boolean bl = contextGetString = contextClass != null && manager.getHierarchy().isSubclass(callee.getDeclaringClass(), contextClass) && subSig.equals(GET_STRING_SUBSIG);
                if (!contextGetString && !(resourceGet = resourceClass != null && manager.getHierarchy().isSubclass(callee.getDeclaringClass(), resourceClass) && (subSig.equals(GET_STRING_SUBSIG) || subSig.equals(GET_INT_SUBSIG) || subSig.equals(GET_BOOL_SUBSIG) || subSig.equals(GET_FLOAT_SUBSIG))) || !((arg0 = stmt.getInvokeExpr().getArg(0)) instanceof IntConstant)) continue;
                int resourceId = ((IntConstant)arg0).value;
                ARSCFileParser.AbstractResource res = parser.findResource(resourceId);
                if (res instanceof ARSCFileParser.StringResource) {
                    String str = ((ARSCFileParser.StringResource)res).getValue();
                    c = StringConstant.v((String)str);
                } else if (res instanceof ARSCFileParser.IntegerResource) {
                    int i = ((ARSCFileParser.IntegerResource)res).getValue();
                    c = IntConstant.v((int)i);
                } else if (res instanceof ARSCFileParser.BooleanResource) {
                    boolean b = ((ARSCFileParser.BooleanResource)res).getValue();
                    c = IntConstant.v((int)(b ? 1 : 0));
                } else {
                    if (!(res instanceof ARSCFileParser.FloatResource)) continue;
                    float f = ((ARSCFileParser.FloatResource)res).getValue();
                    c = FloatConstant.v((float)f);
                }
                AssignStmt constantAssign = Jimple.v().newAssignStmt(((AssignStmt)stmt).getLeftOp(), (Value)c);
                constantAssign.addTag((Tag)SimulatedCodeElementTag.TAG);
                rcs.add(method, stmt, (Stmt)constantAssign);
            }
        }
        rcs.replace(manager.getICFG());
        this.replaced = rcs.size();
        this.runtime = (int)Math.round((double)(System.nanoTime() - beforeOptimization) / 1.0E9);
        this.logger.info(String.format("Resolved %d android string resources in %d seconds.", this.replaced, this.runtime));
    }
}

