/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.axml;

public class AXmlColorValue {
    private final int a;
    private final int r;
    private final int g;
    private final int b;

    public AXmlColorValue(int a, int r, int g, int b) {
        this.a = a;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public AXmlColorValue(int r, int g, int b) {
        this.a = -1;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public int getA() {
        return this.a;
    }

    public int getR() {
        return this.r;
    }

    public int getG() {
        return this.g;
    }

    public int getB() {
        return this.b;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('#');
        if (this.a >= 0) {
            sb.append(AXmlColorValue.toHexComponent(this.a));
        }
        sb.append(AXmlColorValue.toHexComponent(this.r));
        sb.append(AXmlColorValue.toHexComponent(this.g));
        sb.append(AXmlColorValue.toHexComponent(this.b));
        return sb.toString();
    }

    public String toRGBString() {
        StringBuilder sb = new StringBuilder();
        sb.append('#');
        sb.append(AXmlColorValue.toHexComponent(this.r));
        sb.append(AXmlColorValue.toHexComponent(this.g));
        sb.append(AXmlColorValue.toHexComponent(this.b));
        return sb.toString();
    }

    private static String toHexComponent(int val) {
        Object s = Integer.toHexString(val);
        if (((String)s).length() < 2) {
            s = "0" + (String)s;
        }
        return s;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.a;
        result = 31 * result + this.b;
        result = 31 * result + this.g;
        result = 31 * result + this.r;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AXmlColorValue other = (AXmlColorValue)obj;
        if (this.a != other.a) {
            return false;
        }
        if (this.b != other.b) {
            return false;
        }
        if (this.g != other.g) {
            return false;
        }
        return this.r == other.r;
    }
}

