/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.axml;

import java.nio.ByteBuffer;
import pxb.android.Item;

public class AXmlComplexValue
implements Item {
    private final Unit unit;
    private final int mantissa;
    private final int radix;

    public AXmlComplexValue(Unit unit, int mantissa, int radix) {
        this.unit = unit;
        this.mantissa = mantissa;
        this.radix = radix;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public int getMantissa() {
        return this.mantissa;
    }

    public int getRadix() {
        return this.radix;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toString(this.mantissa));
        sb.append('.');
        sb.append(Integer.toString(this.radix));
        sb.append(this.unit.toString());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mantissa;
        result = 31 * result + this.radix;
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AXmlComplexValue other = (AXmlComplexValue)obj;
        if (this.mantissa != other.mantissa) {
            return false;
        }
        if (this.radix != other.radix) {
            return false;
        }
        return this.unit == other.unit;
    }

    public void writeout(ByteBuffer out) {
        out.putInt(this.getInt());
    }

    public int getInt() {
        int val = 0;
        val |= this.mantissa;
        val <<= 4;
        val |= this.radix;
        val <<= 4;
        return val |= this.unit.getUnit();
    }

    public static AXmlComplexValue parseComplexValue(int complexValue) {
        int unitVal = complexValue >> 0;
        Unit complexUnit = AXmlComplexValue.parseComplexUnit(unitVal &= 0xF);
        int radixVal = complexValue >> 4;
        int mantissa = complexValue >> 8;
        return new AXmlComplexValue(complexUnit, mantissa &= 0xFFFFFF, radixVal &= 3);
    }

    public static Unit parseComplexUnit(int unitVal) {
        switch (unitVal) {
            case 1: {
                return Unit.DIP;
            }
            case 4: {
                return Unit.IN;
            }
            case 5: {
                return Unit.MM;
            }
            case 3: {
                return Unit.PT;
            }
            case 0: {
                return Unit.PX;
            }
            case 2: {
                return Unit.SP;
            }
        }
        throw new RuntimeException(String.format("Unknown complex unit %d", unitVal));
    }

    public static enum Unit {
        DIP(1),
        Fraction(0),
        FractionParent(1),
        IN(4),
        MM(5),
        PT(3),
        PX(0),
        SP(2);

        private int unit;

        private Unit(int c) {
            this.unit = c;
        }

        public int getUnit() {
            return this.unit;
        }

        public String toString() {
            switch (this) {
                case DIP: {
                    return "dip";
                }
                case Fraction: 
                case FractionParent: {
                    return "%";
                }
                case IN: {
                    return "in";
                }
                case MM: {
                    return "mm";
                }
                case PT: {
                    return "pt";
                }
                case PX: {
                    return "px";
                }
                case SP: {
                    return "sp";
                }
            }
            return "";
        }
    }
}

