/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.entryPointCreators.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.Local;
import soot.LocalGenerator;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.infoflow.android.entryPointCreators.AbstractAndroidEntryPointCreator;
import soot.jimple.infoflow.android.entryPointCreators.components.ComponentEntryPointInfo;
import soot.jimple.infoflow.android.manifest.IManifestHandler;
import soot.jimple.infoflow.entryPointCreators.SimulatedCodeElementTag;
import soot.jimple.toolkits.scalar.NopEliminator;
import soot.tagkit.Tag;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public abstract class AbstractComponentEntryPointCreator
extends AbstractAndroidEntryPointCreator {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final SootClass component;
    protected final SootClass applicationClass;
    protected Set<SootMethod> callbacks = null;
    protected Local thisLocal = null;
    protected Local intentLocal = null;
    protected SootField intentField = null;
    private RefType INTENT_TYPE = RefType.v((String)"android.content.Intent");

    public AbstractComponentEntryPointCreator(SootClass component, SootClass applicationClass, IManifestHandler manifest) {
        super(manifest);
        this.component = component;
        this.applicationClass = applicationClass;
        this.overwriteDummyMainMethod = true;
    }

    public void setCallbacks(Set<SootMethod> callbacks) {
        this.callbacks = callbacks;
    }

    protected void createAdditionalFields() {
        super.createAdditionalFields();
        Object fieldName = "ipcIntent";
        int fieldIdx = 0;
        while (this.component.declaresFieldByName((String)fieldName)) {
            fieldName = "ipcIntent_" + fieldIdx++;
        }
        this.intentField = Scene.v().makeSootField((String)fieldName, (Type)RefType.v((String)"android.content.Intent"), 1);
        this.intentField.addTag((Tag)SimulatedCodeElementTag.TAG);
        this.component.addField(this.intentField);
    }

    protected void createEmptyMainMethod() {
        String componentPart = this.component.getName();
        if (componentPart.contains(".")) {
            componentPart = componentPart.replace("_", "__").replace(".", "_");
        }
        String baseMethodName = this.dummyMethodName + "_" + componentPart;
        int methodIndex = 0;
        String methodName = baseMethodName;
        SootClass mainClass = Scene.v().getSootClass(this.dummyClassName);
        if (!this.overwriteDummyMainMethod) {
            while (mainClass.declaresMethodByName(methodName)) {
                methodName = baseMethodName + "_" + methodIndex++;
            }
        }
        this.mainMethod = mainClass.getMethodByNameUnsafe(methodName);
        if (this.mainMethod != null) {
            mainClass.removeMethod(this.mainMethod);
            this.mainMethod = null;
        }
        List<Type> defaultParams = this.getDefaultMainMethodParams();
        List<Type> additionalParams = this.getAdditionalMainMethodParams();
        ArrayList<Type> argList = new ArrayList<Type>(defaultParams);
        if (additionalParams != null && !additionalParams.isEmpty()) {
            argList.addAll(additionalParams);
        }
        this.mainMethod = Scene.v().makeSootMethod(methodName, argList, (Type)this.component.getType());
        JimpleBody body = Jimple.v().newBody();
        body.setMethod(this.mainMethod);
        this.mainMethod.setActiveBody((Body)body);
        mainClass.addMethod(this.mainMethod);
        mainClass.setApplicationClass();
        this.mainMethod.setModifiers(9);
        body.insertIdentityStmts();
        this.intentLocal = body.getParameterLocal(0);
        for (int i = 0; i < argList.size(); ++i) {
            Local lc = body.getParameterLocal(i);
            if (!(lc.getType() instanceof RefType)) continue;
            RefType rt = (RefType)lc.getType();
            this.localVarsForClasses.put(rt.getSootClass(), lc);
        }
    }

    protected final List<Type> getDefaultMainMethodParams() {
        return Collections.singletonList(RefType.v((String)"android.content.Intent"));
    }

    protected List<Type> getAdditionalMainMethodParams() {
        return null;
    }

    public Collection<String> getRequiredClasses() {
        return null;
    }

    protected SootMethod createDummyMainInternal() {
        NopStmt beforeComponentStmt = Jimple.v().newNopStmt();
        this.body.getUnits().add((Unit)beforeComponentStmt);
        NopStmt endClassStmt = Jimple.v().newNopStmt();
        try {
            this.createIfStmt((Unit)endClassStmt);
            this.thisLocal = this.generateClassConstructor(this.component);
            if (this.thisLocal != null) {
                this.localVarsForClasses.put(this.component, this.thisLocal);
                this.body.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)this.thisLocal, this.intentField.makeRef()), (Value)this.intentLocal));
                this.generateComponentLifecycle();
            }
            this.createIfStmt((Unit)beforeComponentStmt);
        }
        finally {
            this.body.getUnits().add((Unit)endClassStmt);
            if (this.thisLocal == null) {
                this.body.getUnits().add((Unit)Jimple.v().newReturnStmt((Value)NullConstant.v()));
            } else {
                this.body.getUnits().add((Unit)Jimple.v().newReturnStmt((Value)this.thisLocal));
            }
        }
        NopEliminator.v().transform(this.body);
        this.instrumentDummyMainMethod();
        return this.mainMethod;
    }

    protected void instrumentDummyMainMethod() {
        Body body = this.mainMethod.getActiveBody();
        UnitPatchingChain units = body.getUnits();
        Iterator iter = units.snapshotIterator();
        while (iter.hasNext()) {
            InvokeExpr iexpr;
            Stmt stmt = (Stmt)iter.next();
            if (stmt instanceof IdentityStmt || !stmt.containsInvokeExpr() || (iexpr = stmt.getInvokeExpr()).getMethodRef().isConstructor()) continue;
            List types = stmt.getInvokeExpr().getMethod().getParameterTypes();
            for (int i = 0; i < types.size(); ++i) {
                Type type = (Type)types.get(i);
                if (!type.equals(this.INTENT_TYPE)) continue;
                try {
                    this.assignIntent(this.component, stmt.getInvokeExpr().getMethod(), i);
                    continue;
                }
                catch (Exception ex) {
                    this.logger.error("Assign Intent for " + stmt.getInvokeExpr().getMethod() + " fails.", (Throwable)ex);
                }
            }
        }
    }

    public void assignIntent(SootClass hostComponent, SootMethod method, int indexOfArgs) {
        if (method.isConcrete() && !method.isStatic()) {
            JimpleBody body = (JimpleBody)method.retrieveActiveBody();
            SootMethod m = hostComponent.getMethodUnsafe("android.content.Intent getIntent()");
            if (m != null) {
                UnitPatchingChain units = body.getUnits();
                Local thisLocal = body.getThisLocal();
                Local intentV = body.getParameterLocal(indexOfArgs);
                Iterator iter = units.snapshotIterator();
                while (iter.hasNext()) {
                    Stmt stmt = (Stmt)iter.next();
                    if (stmt.getTag("SimulatedCodeElementTag") == null || !stmt.containsInvokeExpr() || !stmt.getInvokeExpr().getMethod().equals(m)) continue;
                    return;
                }
                Stmt stmt = body.getFirstNonIdentityStmt();
                AssignStmt setIntentU = Jimple.v().newAssignStmt((Value)intentV, (Value)Jimple.v().newVirtualInvokeExpr(thisLocal, m.makeRef()));
                setIntentU.addTag((Tag)SimulatedCodeElementTag.TAG);
                units.insertBefore((Unit)setIntentU, (Unit)stmt);
            }
        }
    }

    protected abstract void generateComponentLifecycle();

    public Collection<SootMethod> getAdditionalMethods() {
        return Collections.emptySet();
    }

    public Collection<SootField> getAdditionalFields() {
        if (this.intentField == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.intentField);
    }

    protected boolean addCallbackMethods() {
        return this.addCallbackMethods(null, "");
    }

    protected boolean addCallbackMethods(Set<SootClass> referenceClasses, String callbackSignature) {
        if (this.callbacks == null) {
            return false;
        }
        RefType rtView = RefType.v((String)"android.view.View");
        Value viewVal = this.getValueForType((Type)rtView, referenceClasses, null, null, true);
        if (viewVal instanceof Local) {
            this.localVarsForClasses.put(rtView.getSootClass(), (Local)viewVal);
        }
        MultiMap<SootClass, SootMethod> callbackClasses = this.getCallbackMethods(callbackSignature);
        referenceClasses = new HashSet<SootClass>();
        if (referenceClasses == null || referenceClasses.isEmpty()) {
            referenceClasses.add(this.component);
        } else {
            referenceClasses.addAll(referenceClasses);
            referenceClasses.add(this.component);
        }
        referenceClasses.add(rtView.getSootClass());
        NopStmt beforeCallbacks = Jimple.v().newNopStmt();
        this.body.getUnits().add((Unit)beforeCallbacks);
        boolean callbackFound = false;
        for (SootClass callbackClass : callbackClasses.keySet()) {
            Set callbackMethods = callbackClasses.get((Object)callbackClass);
            boolean hasParentClass = false;
            for (SootClass parentClass : referenceClasses) {
                Local parentLocal = (Local)this.localVarsForClasses.get(parentClass);
                if (!this.isCompatible(parentClass, callbackClass)) continue;
                this.addSingleCallbackMethod(referenceClasses, callbackMethods, callbackClass, parentLocal);
                callbackFound = true;
                hasParentClass = true;
            }
            if (hasParentClass) continue;
            Local classLocal = (Local)this.localVarsForClasses.get(callbackClass);
            HashSet tempLocals = new HashSet();
            if (classLocal == null && (classLocal = this.generateClassConstructor(callbackClass, new HashSet(), referenceClasses, tempLocals)) == null) continue;
            this.addSingleCallbackMethod(referenceClasses, callbackMethods, callbackClass, classLocal);
            callbackFound = true;
            for (Local tempLocal : tempLocals) {
                this.body.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)tempLocal, (Value)NullConstant.v()));
            }
        }
        if (callbackFound) {
            this.createIfStmt((Unit)beforeCallbacks);
        }
        return callbackFound;
    }

    private MultiMap<SootClass, SootMethod> getCallbackMethods(String callbackSignature) {
        HashMultiMap callbackClasses = new HashMultiMap();
        for (SootMethod theMethod : this.callbacks) {
            if (!callbackSignature.isEmpty() && !callbackSignature.equals(theMethod.getSubSignature()) || this.entryPointUtils.isEntryPointMethod(theMethod)) continue;
            callbackClasses.put((Object)theMethod.getDeclaringClass(), (Object)theMethod);
        }
        return callbackClasses;
    }

    private void addSingleCallbackMethod(Set<SootClass> referenceClasses, Set<SootMethod> callbackMethods, SootClass callbackClass, Local classLocal) {
        for (SootMethod callbackMethod : callbackMethods) {
            NopStmt thenStmt = Jimple.v().newNopStmt();
            this.createIfStmt((Unit)thenStmt);
            this.buildMethodCall(callbackMethod, classLocal, referenceClasses);
            this.body.getUnits().add((Unit)thenStmt);
        }
    }

    protected void reset() {
        super.reset();
        this.component.removeField(this.intentField);
        this.intentField = null;
    }

    public ComponentEntryPointInfo getComponentInfo() {
        ComponentEntryPointInfo info = new ComponentEntryPointInfo(this.mainMethod);
        info.setIntentField(this.intentField);
        return info;
    }

    protected void createGetIntentMethod() {
        if (this.component.declaresMethod("android.content.Intent getIntent()")) {
            return;
        }
        RefType intentType = RefType.v((String)"android.content.Intent");
        SootMethod sm = Scene.v().makeSootMethod("getIntent", Collections.emptyList(), (Type)intentType, 1);
        sm.addTag((Tag)SimulatedCodeElementTag.TAG);
        this.component.addMethod(sm);
        sm.addTag((Tag)SimulatedCodeElementTag.TAG);
        JimpleBody b = Jimple.v().newBody(sm);
        sm.setActiveBody((Body)b);
        b.insertIdentityStmts();
        LocalGenerator localGen = Scene.v().createLocalGenerator((Body)b);
        Local lcIntent = localGen.generateLocal((Type)intentType);
        b.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)lcIntent, (Value)Jimple.v().newInstanceFieldRef((Value)b.getThisLocal(), this.intentField.makeRef())));
        b.getUnits().add((Unit)Jimple.v().newReturnStmt((Value)lcIntent));
    }
}

