/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.manifest;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import soot.jimple.infoflow.android.manifest.IActivity;
import soot.jimple.infoflow.android.manifest.IAndroidApplication;
import soot.jimple.infoflow.android.manifest.IAndroidComponent;
import soot.jimple.infoflow.android.manifest.IBroadcastReceiver;
import soot.jimple.infoflow.android.manifest.IComponentContainer;
import soot.jimple.infoflow.android.manifest.IContentProvider;
import soot.jimple.infoflow.android.manifest.IService;
import soot.jimple.infoflow.util.SystemClassHandler;

public interface IManifestHandler<A extends IActivity, S extends IService, C extends IContentProvider, B extends IBroadcastReceiver>
extends Closeable {
    public String getPackageName();

    public IComponentContainer<? extends A> getActivities();

    public IComponentContainer<? extends C> getContentProviders();

    public IComponentContainer<? extends S> getServices();

    public IComponentContainer<? extends B> getBroadcastReceivers();

    public IAndroidApplication getApplication();

    default public List<? extends IAndroidComponent> getAllComponents() {
        List<B> receivers;
        List<S> services;
        List<C> providers;
        ArrayList<Object> components = new ArrayList<Object>();
        List<A> activities = this.getActivities().asList();
        if (activities != null && !activities.isEmpty()) {
            components.addAll(activities);
        }
        if ((providers = this.getContentProviders().asList()) != null && !providers.isEmpty()) {
            components.addAll(providers);
        }
        if ((services = this.getServices().asList()) != null && !services.isEmpty()) {
            components.addAll(services);
        }
        if ((receivers = this.getBroadcastReceivers().asList()) != null && !receivers.isEmpty()) {
            components.addAll(receivers);
        }
        return components;
    }

    default public Set<String> getEntryPointClasses() {
        String appName;
        IAndroidApplication app = this.getApplication();
        if (app != null && !app.isEnabled()) {
            return Collections.emptySet();
        }
        HashSet<String> entryPoints = new HashSet<String>();
        for (IAndroidComponent node : this.getAllComponents()) {
            this.checkAndAddComponent(entryPoints, node);
        }
        if (entryPoints.isEmpty()) {
            List<IAndroidComponent> allEnabled = this.getAllComponents().stream().filter(c -> c.isEnabled()).collect(Collectors.toList());
            allEnabled.forEach(e -> entryPoints.add(e.getNameString()));
        }
        if (app != null && (appName = app.getName()) != null && !appName.isEmpty()) {
            entryPoints.add(appName);
        }
        return entryPoints;
    }

    default public void checkAndAddComponent(Set<String> entryPoints, IAndroidComponent component) {
        String className;
        String packageName = this.getPackageName() + ".";
        if (component.isEnabled() && (className = component.getNameString()) != null && !className.isEmpty() && (className.startsWith(packageName) || !SystemClassHandler.v().isClassInSystemPackage(className))) {
            entryPoints.add(className);
        }
    }
}

