/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.resources;

import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.infoflow.android.resources.IResourceHandler;

public abstract class AbstractResourceParser {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected void handleAndroidResourceFiles(File apk, Set<String> fileNameFilter, IResourceHandler handler) {
        if (!apk.exists()) {
            throw new RuntimeException("file '" + apk + "' does not exist!");
        }
        try (ZipFile archive = new ZipFile(apk);){
            Enumeration<? extends ZipEntry> entries = archive.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                InputStream is = archive.getInputStream(entry);
                try {
                    handler.handleResourceFile(entryName, fileNameFilter, is);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error when looking for XML resource files in apk " + apk, (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

