/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.resources;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import soot.FastHierarchy;
import soot.PackManager;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.Transform;
import soot.Transformer;
import soot.Type;
import soot.jimple.infoflow.android.axml.AXmlAttribute;
import soot.jimple.infoflow.android.axml.AXmlHandler;
import soot.jimple.infoflow.android.axml.AXmlNode;
import soot.jimple.infoflow.android.axml.parsers.AXML20Parser;
import soot.jimple.infoflow.android.resources.ARSCFileParser;
import soot.jimple.infoflow.android.resources.AbstractResourceParser;
import soot.jimple.infoflow.android.resources.IResourceHandler;
import soot.jimple.infoflow.android.resources.controls.AndroidLayoutControl;
import soot.jimple.infoflow.android.resources.controls.LayoutControlFactory;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class LayoutFileParser
extends AbstractResourceParser {
    protected final MultiMap<String, AndroidLayoutControl> userControls = new HashMultiMap();
    protected final MultiMap<String, String> callbackMethods = new HashMultiMap();
    protected final MultiMap<String, String> includeDependencies = new HashMultiMap();
    protected final MultiMap<String, SootClass> fragments = new HashMultiMap();
    protected final String packageName;
    protected final ARSCFileParser resParser;
    private boolean loadOnlySensitiveControls = false;
    protected SootClass scViewGroup = null;
    protected SootClass scView = null;
    protected SootClass scWebView = null;
    private LayoutControlFactory controlFactory = new LayoutControlFactory();

    public LayoutFileParser(String packageName, ARSCFileParser resParser) {
        this.packageName = packageName;
        this.resParser = resParser;
    }

    private boolean isRealClass(SootClass sc) {
        if (sc == null) {
            return false;
        }
        return !sc.isPhantom() || sc.getMethodCount() != 0 || sc.getFieldCount() != 0;
    }

    private SootClass getLayoutClass(String className) {
        if (className.startsWith(";")) {
            className = className.substring(1);
        }
        if (className.contains("(") || className.contains("<") || className.contains("/")) {
            this.logger.warn("Invalid class name %s", (Object)className);
            return null;
        }
        SootClass sc = Scene.v().forceResolve(className, 3);
        if ((sc == null || sc.isPhantom()) && !this.packageName.isEmpty()) {
            sc = Scene.v().forceResolve(this.packageName + "." + className, 3);
        }
        if (!this.isRealClass(sc)) {
            sc = Scene.v().forceResolve("android.view." + className, 3);
        }
        if (!this.isRealClass(sc)) {
            sc = Scene.v().forceResolve("android.widget." + className, 3);
        }
        if (!this.isRealClass(sc)) {
            sc = Scene.v().forceResolve("android.webkit." + className, 3);
        }
        if (!this.isRealClass(sc)) {
            return null;
        }
        return sc;
    }

    private boolean isLayoutClass(SootClass theClass) {
        return theClass != null && Scene.v().getOrMakeFastHierarchy().canStoreType((Type)theClass.getType(), (Type)this.scViewGroup.getType());
    }

    private boolean isViewClass(SootClass theClass) {
        if (theClass == null) {
            return false;
        }
        FastHierarchy fh = Scene.v().getOrMakeFastHierarchy();
        if (this.scView != null && fh.canStoreType((Type)theClass.getType(), (Type)this.scView.getType())) {
            return true;
        }
        if (this.scWebView != null && fh.canStoreType((Type)theClass.getType(), (Type)this.scWebView.getType())) {
            return true;
        }
        this.logger.warn(String.format("Layout class %s is not derived from android.view.View", theClass.getName()));
        return false;
    }

    private void addCallbackMethod(String layoutFile, String callback) {
        layoutFile = layoutFile.replace("/layout-large/", "/layout/");
        this.callbackMethods.put((Object)layoutFile, (Object)callback);
        if (this.includeDependencies.containsKey((Object)layoutFile)) {
            for (String target : this.includeDependencies.get((Object)layoutFile)) {
                this.addCallbackMethod(target, callback);
            }
        }
    }

    private void addFragment(String layoutFile, SootClass fragment) {
        if (fragment == null) {
            return;
        }
        layoutFile = layoutFile.replace("/layout-large/", "/layout/");
        this.fragments.put((Object)layoutFile, (Object)fragment);
        if (this.includeDependencies.containsKey((Object)layoutFile)) {
            for (String target : this.includeDependencies.get((Object)layoutFile)) {
                this.addFragment(target, fragment);
            }
        }
    }

    public void parseLayoutFile(final File apkFile) {
        Transform transform = new Transform("wjtp.lfp", (Transformer)new SceneTransformer(){

            protected void internalTransform(String phaseName, Map options) {
                LayoutFileParser.this.parseLayoutFileDirect(apkFile);
            }
        });
        PackManager.v().getPack("wjtp").add(transform);
    }

    public void parseLayoutFileDirect(File apkFile) {
        this.handleAndroidResourceFiles(apkFile, null, new IResourceHandler(){

            @Override
            public void handleResourceFile(String fileName, Set<String> fileNameFilter, InputStream stream) {
                if (!fileName.startsWith("res/layout") && !fileName.startsWith("res/navigation")) {
                    return;
                }
                if (!fileName.endsWith(".xml")) {
                    LayoutFileParser.this.logger.warn(String.format("Skipping file %s in layout folder...", fileName));
                    return;
                }
                LayoutFileParser.this.scViewGroup = Scene.v().getSootClassUnsafe("android.view.ViewGroup");
                LayoutFileParser.this.scView = Scene.v().getSootClassUnsafe("android.view.View");
                LayoutFileParser.this.scWebView = Scene.v().getSootClassUnsafe("android.webkit.WebView");
                Object entryClass = fileName.substring(0, fileName.lastIndexOf("."));
                if (!LayoutFileParser.this.packageName.isEmpty()) {
                    entryClass = LayoutFileParser.this.packageName + "." + (String)entryClass;
                }
                if (fileNameFilter != null) {
                    boolean found = false;
                    for (String s : fileNameFilter) {
                        if (!s.equalsIgnoreCase((String)entryClass)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        return;
                    }
                }
                try {
                    AXmlHandler handler = new AXmlHandler(stream, new AXML20Parser());
                    LayoutFileParser.this.parseLayoutNode(fileName, handler.getDocument().getRootNode());
                }
                catch (Exception ex) {
                    LayoutFileParser.this.logger.error("Could not read binary XML file: " + ex.getMessage(), (Throwable)ex);
                }
            }
        });
    }

    protected void parseLayoutNode(String layoutFile, AXmlNode rootNode) {
        if (rootNode.getTag() == null || rootNode.getTag().isEmpty()) {
            this.logger.warn("Encountered a null or empty node name in file %s, skipping node...", (Object)layoutFile);
            return;
        }
        String tname = rootNode.getTag().trim();
        if (!tname.equals("dummy")) {
            if (tname.equals("include")) {
                this.parseIncludeAttributes(layoutFile, rootNode);
            } else if (!tname.equals("merge")) {
                if (tname.equals("fragment")) {
                    AXmlAttribute<?> attr = rootNode.getAttribute("name");
                    if (attr == null) {
                        this.logger.warn("Fragment without class name or id detected");
                    } else if (rootNode.getAttribute("navGraph") != null) {
                        this.parseIncludeAttributes(layoutFile, rootNode);
                    } else {
                        this.addFragment(layoutFile, this.getLayoutClass(attr.getValue().toString()));
                        if (attr.getType() != 3) {
                            this.logger.warn("Invalid target resource " + attr.getValue() + "for fragment class value");
                        }
                        this.getLayoutClass(attr.getValue().toString());
                    }
                } else {
                    SootClass childClass = this.getLayoutClass(tname);
                    if (childClass != null && (this.isLayoutClass(childClass) || this.isViewClass(childClass))) {
                        this.parseLayoutAttributes(layoutFile, childClass, rootNode);
                    }
                }
            }
        }
        for (AXmlNode childNode : rootNode.getChildren()) {
            this.parseLayoutNode(layoutFile, childNode);
        }
    }

    private void parseIncludeAttributes(String layoutFile, AXmlNode rootNode) {
        for (Map.Entry<String, AXmlAttribute<?>> entry : rootNode.getAttributes().entrySet()) {
            String attrName = entry.getKey();
            if (attrName == null || attrName.isEmpty()) continue;
            attrName = attrName.trim();
            AXmlAttribute<?> attr = entry.getValue();
            if (!attrName.equals("layout") && !attrName.equals("navGraph") || attr.getType() != 1 && attr.getType() != 17 || !(attr.getValue() instanceof Integer)) continue;
            ARSCFileParser.AbstractResource targetRes = this.resParser.findResource((Integer)attr.getValue());
            if (targetRes == null) {
                this.logger.warn("Target resource " + attr.getValue() + " for layout include not found");
                return;
            }
            if (!(targetRes instanceof ARSCFileParser.StringResource)) {
                this.logger.warn(String.format("Invalid target node for include tag in layout XML, was %s", targetRes.getClass().getName()));
                return;
            }
            String targetFile = ((ARSCFileParser.StringResource)targetRes).getValue();
            if (this.callbackMethods.containsKey((Object)targetFile)) {
                for (String callback : this.callbackMethods.get((Object)targetFile)) {
                    this.addCallbackMethod(layoutFile, callback);
                }
                continue;
            }
            this.includeDependencies.put((Object)targetFile, (Object)layoutFile);
        }
    }

    private void parseLayoutAttributes(String layoutFile, SootClass layoutClass, AXmlNode rootNode) {
        AndroidLayoutControl lc = this.controlFactory.createLayoutControl(layoutFile, layoutClass, rootNode);
        if (lc.getClickListener() != null) {
            this.addCallbackMethod(layoutFile, lc.getClickListener());
        }
        if (!this.loadOnlySensitiveControls || lc.isSensitive()) {
            this.userControls.put((Object)layoutFile, (Object)lc);
        }
    }

    public Map<Integer, AndroidLayoutControl> getUserControlsByID() {
        HashMap<Integer, AndroidLayoutControl> res = new HashMap<Integer, AndroidLayoutControl>();
        for (AndroidLayoutControl lc : this.userControls.values()) {
            if (lc.getID() == -1) continue;
            res.put(lc.getID(), lc);
        }
        return res;
    }

    public MultiMap<String, AndroidLayoutControl> getUserControls() {
        return this.userControls;
    }

    public MultiMap<String, String> getCallbackMethods() {
        return this.callbackMethods;
    }

    public MultiMap<String, SootClass> getFragments() {
        return this.fragments;
    }

    public boolean getLoadOnlySensitiveControls() {
        return this.loadOnlySensitiveControls;
    }

    public void setControlFactory(LayoutControlFactory controlFactory) {
        this.controlFactory = controlFactory;
    }
}

