/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.data.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.ClosedChannelException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.infoflow.collect.ConcurrentHashSet;
import soot.jimple.infoflow.methodSummary.data.provider.AbstractMethodSummaryProvider;
import soot.jimple.infoflow.methodSummary.data.summary.ClassMethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.ClassSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.MethodClear;
import soot.jimple.infoflow.methodSummary.data.summary.MethodFlow;
import soot.jimple.infoflow.methodSummary.data.summary.MethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.SummaryMetaData;
import soot.jimple.infoflow.methodSummary.xml.MetaDataReader;
import soot.jimple.infoflow.methodSummary.xml.SummaryReader;
import soot.util.MultiMap;

public abstract class XMLSummaryProvider
extends AbstractMethodSummaryProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String FILE_META_DATA = "SummaryMetaData.xml";
    protected final SummaryReader summaryReader = new SummaryReader();
    protected MetaDataReader metaDataReader = new MetaDataReader();
    protected ClassSummaries summaries = this.createClassSummaries();
    protected Set<String> loadedClasses = new ConcurrentHashSet();
    protected Set<String> subsigMethodsWithSummaries = new ConcurrentHashSet();
    protected boolean hasLoadingErrors;

    protected XMLSummaryProvider() {
    }

    protected ClassSummaries createClassSummaries() {
        return new ClassSummaries();
    }

    protected void loadSummariesFromFiles(List<File> files, Consumer<File> summaryLoader) {
        SummaryMetaData metadata = null;
        for (File f : files) {
            if (!f.exists()) {
                throw new RuntimeException("Input file does not exist: " + f);
            }
            if (f.isFile()) {
                summaryLoader.accept(f);
                continue;
            }
            if (f.isDirectory()) {
                File[] filesInDir = f.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith(".xml");
                    }
                });
                if (filesInDir == null) {
                    throw new RuntimeException("Could not get files in directory " + f);
                }
                for (File f2 : filesInDir) {
                    if (f2.getName().equals(FILE_META_DATA)) {
                        metadata = this.loadMetaDataFile(f2);
                        this.summaries.setMetaData(metadata);
                        continue;
                    }
                    summaryLoader.accept(f2);
                }
                continue;
            }
            throw new RuntimeException("Invalid input file: " + f);
        }
        if (metadata != null) {
            metadata.mergeHierarchyData(this.summaries);
        }
    }

    protected void loadSummariesFromJAR(String folderInJar, Class<?> parentClass, Consumer<Path> summaryLoader) throws URISyntaxException, IOException {
        SummaryMetaData metadata = null;
        Path path = this.getPathInJar(folderInJar, parentClass);
        try (Stream<Path> walk = Files.walk(path, 1, new FileVisitOption[0]);){
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Path classp = (Path)it.next();
                String name = this.getFileName(classp);
                if (!name.endsWith(".xml")) continue;
                if (name.equals(FILE_META_DATA)) {
                    metadata = this.loadMetaDataFile(classp);
                    this.summaries.setMetaData(metadata);
                    continue;
                }
                summaryLoader.accept(classp);
            }
        }
        if (metadata != null) {
            metadata.mergeHierarchyData(this.summaries);
        }
    }

    protected SummaryMetaData loadMetaDataFile(File f) {
        SummaryMetaData summaryMetaData;
        InputStreamReader rdr = new InputStreamReader(new FileInputStream(f));
        try {
            summaryMetaData = this.metaDataReader.read(rdr);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)rdr).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.logger.error(String.format("An error occurred while loading the meta data of %s", f.getAbsolutePath()));
                return null;
            }
        }
        ((Reader)rdr).close();
        return summaryMetaData;
    }

    protected SummaryMetaData loadMetaDataFile(Path path) {
        block9: {
            if (!this.hasLoadingErrors) {
                SummaryMetaData summaryMetaData;
                InputStreamReader rdr = new InputStreamReader(path.getFileSystem().provider().newInputStream(path, new OpenOption[0]));
                try {
                    summaryMetaData = this.metaDataReader.read(rdr);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((Reader)rdr).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (ClosedChannelException e) {
                        this.logger.error("Channel closed for path loading, ending summary loading.");
                        this.hasLoadingErrors = true;
                        break block9;
                    }
                    catch (Exception e) {
                        this.logger.error(String.format("An error occurred while loading the meta data of %s", path.toString()));
                    }
                }
                ((Reader)rdr).close();
                return summaryMetaData;
            }
        }
        return null;
    }

    protected Path getPathInJar(String folderInJar, Class<?> parentClass) throws URISyntaxException, IOException {
        Path path;
        URI uri = null;
        String jarRelativePath = folderInJar.startsWith("/") ? folderInJar : "/" + folderInJar;
        URL resourceURL = parentClass.getResource(jarRelativePath);
        if (resourceURL == null) {
            this.logger.warn(String.format("Could not find folder %s in JAR, trying normal folder on disk...", folderInJar));
            String classLocation = parentClass.getProtectionDomain().getCodeSource().getLocation().getPath();
            File classFile = new File(new URI("file:///" + classLocation));
            if (classFile.getCanonicalPath().endsWith("build" + File.separator + "classes")) {
                classFile = classFile.getParentFile().getParentFile();
            }
            if ((classFile = new File(classFile, folderInJar)).exists()) {
                uri = classFile.toURI();
            }
        } else {
            uri = resourceURL.toURI();
        }
        if (uri == null) {
            throw new RuntimeException(String.format("Could not find summaries in folder %s", folderInJar));
        }
        FileSystem fileSystem = null;
        if (uri.getScheme().equals("jar")) {
            try {
                fileSystem = FileSystems.getFileSystem(uri);
            }
            catch (FileSystemNotFoundException e) {
                fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
            }
            path = fileSystem.getPath(folderInJar, new String[0]);
        } else {
            path = Paths.get(uri);
        }
        return path;
    }

    protected String getFileName(Path path) {
        return path.getFileName().toString();
    }

    protected SummaryReader getSummaryReader() {
        return this.summaryReader;
    }

    @Override
    public boolean supportsClass(String clazz) {
        return this.loadedClasses.contains(clazz);
    }

    @Override
    public ClassSummaries getMethodFlows(Set<String> classes, String methodSignature) {
        return this.summaries.filterForMethod(classes, methodSignature);
    }

    @Override
    public ClassMethodSummaries getMethodFlows(String className, String methodSignature) {
        ClassMethodSummaries classSummaries = this.getClassSummaries(className);
        return classSummaries == null ? null : classSummaries.filterForMethod(methodSignature);
    }

    protected ClassMethodSummaries getClassSummaries(String className) {
        ClassMethodSummaries classSummaries = this.summaries.getClassSummaries(className);
        return classSummaries;
    }

    protected void loadClass(Path path) {
        this.loadClass(this.fileToClass(this.getFileName(path)), path);
    }

    protected void loadClass(String clazz, Path path) {
        try (InputStream inputStream = Files.newInputStream(path, StandardOpenOption.READ);
             InputStreamReader rdr = new InputStreamReader(inputStream);){
            ClassMethodSummaries classSummaries = new ClassMethodSummaries(clazz);
            this.summaryReader.read(rdr, classSummaries);
            this.addMethodSummaries(classSummaries);
            this.onClassSummariesLoaded(clazz);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error(String.format("An error occurred while loading the summary of %s", clazz), (Throwable)e);
            this.hasLoadingErrors = true;
        }
    }

    protected void loadClass(File f) {
        this.loadClass(this.fileToClass(f), f);
    }

    protected void loadClass(String clazz, File f) {
        try {
            ClassMethodSummaries classSummaries = new ClassMethodSummaries(clazz);
            this.summaryReader.read(f, classSummaries);
            this.addMethodSummaries(classSummaries);
            this.onClassSummariesLoaded(clazz);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error(String.format("An error occurred while loading the summary of %s", clazz), (Throwable)e);
            this.hasLoadingErrors = true;
        }
    }

    protected void onClassSummariesLoaded(String clazz) {
    }

    protected void addMethodSummaries(ClassMethodSummaries newSummaries) {
        this.addSubsigsForMethod(newSummaries.getMethodSummaries());
        this.summaries.merge(newSummaries);
        this.loadedClasses.add(newSummaries.getClassName());
    }

    protected void addSubsigsForMethod(MethodSummaries read) {
        MultiMap<String, MethodFlow> flows = read.getFlows();
        MultiMap<String, MethodClear> clears = read.getClears();
        if (flows != null) {
            this.subsigMethodsWithSummaries.addAll(flows.keySet());
        }
        if (clears != null) {
            this.subsigMethodsWithSummaries.addAll(clears.keySet());
        }
    }

    public boolean hasLoadingErrors() {
        return this.hasLoadingErrors;
    }

    protected String fileToClass(File f) {
        return this.fileToClass(f.getName());
    }

    protected String fileToClass(String s) {
        String ext;
        int idx = s.lastIndexOf(".");
        if (idx >= 0 && (ext = s.substring(idx)).equals(".xml")) {
            s = s.substring(0, idx);
        }
        return s;
    }

    @Override
    public Set<String> getSupportedClasses() {
        return this.loadedClasses;
    }

    @Override
    public ClassSummaries getSummaries() {
        return this.summaries;
    }

    @Override
    public ClassMethodSummaries getClassFlows(String className) {
        return this.summaries.getClassSummaries(className);
    }

    @Override
    public boolean mayHaveSummaryForMethod(String subsig) {
        return this.subsigMethodsWithSummaries.contains(subsig);
    }

    @Override
    public boolean isMethodExcluded(String className, String subSignature) {
        ClassMethodSummaries summaries = this.getClassSummaries(className);
        return summaries != null && summaries.getMethodSummaries().isExcluded(subSignature);
    }
}

