/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.data.sourceSink;

import java.util.Map;
import soot.jimple.infoflow.methodSummary.data.sourceSink.AbstractFlowSinkSource;
import soot.jimple.infoflow.methodSummary.data.sourceSink.InvalidFlowSpecificationException;
import soot.jimple.infoflow.methodSummary.data.summary.GapDefinition;
import soot.jimple.infoflow.methodSummary.data.summary.SourceSinkType;
import soot.jimple.infoflow.methodSummary.taintWrappers.AccessPathFragment;

public class FlowSource
extends AbstractFlowSinkSource
implements Cloneable {
    public static final int ANY_PARAMETER = -2;

    public FlowSource(SourceSinkType type, String baseType) {
        super(type, -1, baseType, null, null, false);
    }

    public FlowSource(SourceSinkType type, String baseType, GapDefinition gap) {
        super(type, -1, baseType, null, gap, null, false);
    }

    public FlowSource(SourceSinkType type, String baseType, GapDefinition gap, boolean matchStrict) {
        super(type, -1, baseType, null, gap, null, matchStrict);
    }

    public FlowSource(SourceSinkType type, String baseType, AccessPathFragment accessPath) {
        super(type, -1, baseType, accessPath, false);
    }

    public FlowSource(SourceSinkType type, String baseType, AccessPathFragment accessPath, GapDefinition gap) {
        super(type, -1, baseType, accessPath, gap, false);
    }

    public FlowSource(SourceSinkType type, String baseType, AccessPathFragment accessPath, GapDefinition gap, boolean matchStrict) {
        super(type, -1, baseType, accessPath, gap, matchStrict);
    }

    public FlowSource(SourceSinkType type, int parameterIdx, String baseType) {
        super(type, parameterIdx, baseType, null, null, false);
    }

    public FlowSource(SourceSinkType type, int parameterIdx, String baseType, GapDefinition gap) {
        super(type, parameterIdx, baseType, null, gap, null, false);
    }

    public FlowSource(SourceSinkType type, int parameterIdx, String baseType, AccessPathFragment accessPath) {
        super(type, parameterIdx, baseType, accessPath, false);
    }

    public FlowSource(SourceSinkType type, int parameterIdx, String baseType, AccessPathFragment accessPath, GapDefinition gap) {
        super(type, parameterIdx, baseType, accessPath, gap, false);
    }

    public FlowSource(SourceSinkType type, int parameterIdx, String baseType, AccessPathFragment accessPath, GapDefinition gap, boolean matchStrict) {
        super(type, parameterIdx, baseType, accessPath, gap, matchStrict);
    }

    public FlowSource(SourceSinkType type, int parameterIdx, String baseType, AccessPathFragment accessPath, GapDefinition gap, Object userData, boolean matchStrict) {
        super(type, parameterIdx, baseType, accessPath, gap, userData, matchStrict);
    }

    public String toString() {
        String gapString;
        String string = gapString = this.getGap() == null ? "" : "Gap " + this.getGap().getSignature() + " ";
        if (this.isParameter()) {
            return gapString + "Parameter " + this.getParameterIndex() + (this.accessPath == null ? "" : " " + AccessPathFragment.toString(this.accessPath));
        }
        if (this.isField()) {
            return gapString + "Field" + (this.accessPath == null ? "" : " " + AccessPathFragment.toString(this.accessPath));
        }
        if (this.isThis()) {
            return "THIS";
        }
        if (this.isReturn() && this.gap != null) {
            return "Return value of gap " + this.gap.getSignature() + (this.accessPath == null ? "" : " " + AccessPathFragment.toString(this.accessPath));
        }
        if (this.isReturn()) {
            return "Return value" + (this.accessPath == null ? "" : " " + AccessPathFragment.toString(this.accessPath));
        }
        if (this.isCustom()) {
            return "CUSTOM " + gapString + "Parameter " + this.getParameterIndex() + (this.accessPath == null ? "" : " " + AccessPathFragment.toString(this.accessPath));
        }
        return "<unknown>";
    }

    public void validate(String methodName) {
        if (this.getType() == SourceSinkType.Return && this.getGap() == null) {
            throw new InvalidFlowSpecificationException("Return values cannot be sources. Offending method: " + methodName, this);
        }
    }

    @Override
    public FlowSource replaceGaps(Map<Integer, GapDefinition> replacementMap) {
        if (this.gap == null) {
            return this;
        }
        GapDefinition newGap = replacementMap.get(this.gap.getID());
        if (newGap == null) {
            return this;
        }
        return new FlowSource(this.type, this.parameterIdx, this.baseType, this.accessPath, newGap, this.matchStrict);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new FlowSource(this.type, this.parameterIdx, this.baseType, this.accessPath, this.gap, this.userData, this.matchStrict);
    }
}

