/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.data.summary;

import java.util.HashSet;
import java.util.Set;
import soot.jimple.infoflow.methodSummary.data.summary.MethodClear;
import soot.jimple.infoflow.methodSummary.data.summary.MethodSummaries;

public class ClassMethodSummaries {
    private final String className;
    private final MethodSummaries methodSummaries;
    private final Set<String> interfaces = new HashSet<String>();
    private String superClass;
    private Boolean isInterface = null;
    private boolean isExclusiveForClass = true;

    public ClassMethodSummaries(String className) {
        this.className = className;
        this.methodSummaries = new MethodSummaries();
    }

    public ClassMethodSummaries(String className, MethodSummaries methodSummaries) {
        this.className = className;
        this.methodSummaries = methodSummaries;
    }

    public String getClassName() {
        return this.className;
    }

    public MethodSummaries getMethodSummaries() {
        return this.methodSummaries;
    }

    public boolean isEmpty() {
        return (this.methodSummaries == null || this.methodSummaries.isEmpty()) && !this.hasInterfaces() && !this.hasSuperclass() && this.isInterface == null;
    }

    public ClassMethodSummaries filterForMethod(String signature) {
        if (this.isEmpty()) {
            return null;
        }
        MethodSummaries summaries = this.methodSummaries.filterForMethod(signature);
        return summaries == null ? null : new ClassMethodSummaries(this.className, summaries);
    }

    public boolean merge(MethodSummaries toMerge) {
        return this.methodSummaries.merge(toMerge);
    }

    public void validate() {
        if (this.className == null || this.className.isEmpty()) {
            throw new RuntimeException("No class name given");
        }
        this.methodSummaries.validate();
    }

    public boolean merge(ClassMethodSummaries methodFlows) {
        if (methodFlows == null || methodFlows.isEmpty()) {
            return false;
        }
        String otherClassName = methodFlows.getClassName();
        if (otherClassName == null && this.className != null) {
            throw new RuntimeException("Class name mismatch");
        }
        if (otherClassName != null && this.className == null) {
            throw new RuntimeException("Class name mismatch");
        }
        if (otherClassName != null && !otherClassName.equals(this.className)) {
            throw new RuntimeException("Class name mismatch");
        }
        if (this.hasSuperclass() && methodFlows.hasSuperclass() && !this.superClass.equals(methodFlows.getSuperClass())) {
            throw new RuntimeException("Class name mismatch");
        }
        boolean hasNewData = false;
        if (methodFlows.hasSuperclass() && !this.hasSuperclass()) {
            this.setSuperClass(methodFlows.getSuperClass());
            hasNewData = true;
        }
        if (this.methodSummaries.merge(methodFlows.getMethodSummaries())) {
            hasNewData = true;
        }
        if (methodFlows.hasInterfaces() && this.interfaces.addAll(methodFlows.getInterfaces())) {
            hasNewData = true;
        }
        if (this.isInterface == null && methodFlows.isInterface != null) {
            this.isInterface = methodFlows.isInterface;
        }
        return hasNewData;
    }

    public boolean hasClears() {
        return this.methodSummaries.hasClears();
    }

    public Set<MethodClear> getAllClears() {
        return this.methodSummaries.getAllClears();
    }

    public int getFlowCount() {
        return this.methodSummaries.getFlowCount();
    }

    public boolean isExclusiveForClass() {
        return this.isExclusiveForClass;
    }

    public void setExclusiveForClass(boolean isExclusiveForClass) {
        this.isExclusiveForClass = isExclusiveForClass;
    }

    public Set<String> getInterfaces() {
        return this.interfaces;
    }

    public void addInterface(String className) {
        this.interfaces.add(className);
    }

    public boolean hasInterfaces() {
        return this.interfaces != null && !this.interfaces.isEmpty();
    }

    public boolean hasSuperclass() {
        return this.superClass != null && !this.superClass.isEmpty();
    }

    public String toString() {
        return String.format("Summaries for %s", this.className);
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(String superClass) {
        this.superClass = superClass;
    }

    public boolean isInterface() {
        return this.isInterface != null && this.isInterface != false;
    }

    public boolean hasInterfaceInfo() {
        return this.isInterface != null;
    }

    public void setInterface(boolean isInterface) {
        this.isInterface = isInterface;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.interfaces == null ? 0 : this.interfaces.hashCode());
        result = 31 * result + (this.isExclusiveForClass ? 1231 : 1237);
        result = 31 * result + (this.isInterface == null ? 0 : this.isInterface.hashCode());
        result = 31 * result + (this.methodSummaries == null ? 0 : this.methodSummaries.hashCode());
        result = 31 * result + (this.superClass == null ? 0 : this.superClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassMethodSummaries other = (ClassMethodSummaries)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.interfaces == null ? other.interfaces != null : !this.interfaces.equals(other.interfaces)) {
            return false;
        }
        if (this.isExclusiveForClass != other.isExclusiveForClass) {
            return false;
        }
        if (this.isInterface == null ? other.isInterface != null : !this.isInterface.equals(other.isInterface)) {
            return false;
        }
        if (this.methodSummaries == null ? other.methodSummaries != null : !this.methodSummaries.equals(other.methodSummaries)) {
            return false;
        }
        return !(this.superClass == null ? other.superClass != null : !this.superClass.equals(other.superClass));
    }
}

