/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.generator;

import java.util.Collections;
import java.util.Set;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.nativeCallHandler.AbstractNativeCallHandler;
import soot.jimple.infoflow.nativeCallHandler.DefaultNativeCallHandler;
import soot.jimple.infoflow.nativeCallHandler.INativeCallHandler;

public class SummaryNativeCallHandler
extends AbstractNativeCallHandler {
    private final INativeCallHandler fallbackHandler;

    public SummaryNativeCallHandler() {
        this((INativeCallHandler)new DefaultNativeCallHandler());
    }

    public SummaryNativeCallHandler(INativeCallHandler fallbackHandler) {
        this.fallbackHandler = fallbackHandler;
    }

    public void initialize(InfoflowManager manager) {
        super.initialize(manager);
        this.fallbackHandler.initialize(manager);
    }

    public Set<Abstraction> getTaintedValues(Stmt call, Abstraction source, Value[] params) {
        if (this.fallbackHandler.supportsCall(call)) {
            return this.fallbackHandler.getTaintedValues(call, source, params);
        }
        boolean found = false;
        for (Value val : call.getInvokeExpr().getArgs()) {
            if (val != source.getAccessPath().getPlainValue()) continue;
            found = true;
            break;
        }
        if (!found) {
            return Collections.emptySet();
        }
        if (call instanceof DefinitionStmt) {
            DefinitionStmt defStmt = (DefinitionStmt)call;
            return Collections.singleton(source.deriveNewAbstraction(this.manager.getAccessPathFactory().createAccessPath(defStmt.getLeftOp(), true), call));
        }
        return Collections.emptySet();
    }

    public boolean supportsCall(Stmt call) {
        return true;
    }
}

