/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.generator.gaps;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import soot.jimple.Stmt;
import soot.jimple.infoflow.methodSummary.data.summary.GapDefinition;
import soot.jimple.infoflow.methodSummary.data.summary.MethodSummaries;
import soot.jimple.infoflow.methodSummary.generator.gaps.AbstractGapManager;

public class ConcurrentGapManager
extends AbstractGapManager {
    private final Map<Stmt, GapDefinition> gaps = new ConcurrentHashMap<Stmt, GapDefinition>();
    private AtomicInteger lastGapID = new AtomicInteger();

    @Override
    public GapDefinition getOrCreateGapForCall(MethodSummaries flows, Stmt gapCall) {
        return this.gaps.computeIfAbsent(gapCall, g -> flows.getOrCreateGap(this.lastGapID.incrementAndGet(), gapCall.getInvokeExpr().getMethod().getSignature()));
    }

    @Override
    public GapDefinition getGapForCall(Stmt gapCall) {
        return this.gaps.get(gapCall);
    }

    @Override
    public Collection<Stmt> getAllGapStmts() {
        return this.gaps.keySet();
    }
}

