/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test;

import soot.jimple.infoflow.test.android.ConnectionManager;
import soot.jimple.infoflow.test.android.TelephonyManager;

public class ConstantTestCode {
    static final String tainted = TelephonyManager.getDeviceId();
    static final String[] staticArray = new String[1];
    final String[] fieldArray = new String[1];

    public void easyConstantFieldTest() {
        ConnectionManager cm = new ConnectionManager();
        cm.publish(tainted);
    }

    public void easyConstantVarTest() {
        String e = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(e);
    }

    public void constantArrayTest() {
        String tainted;
        this.fieldArray[0] = tainted = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(this.fieldArray[0]);
    }

    public void constantStaticArrayTest() {
        String tainted;
        ConstantTestCode.staticArray[0] = tainted = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(staticArray[0]);
    }

    public void constantFieldArrayTest() {
        String tainted;
        ConstantTestCode.staticArray[0] = tainted = TelephonyManager.getDeviceId();
        this.fieldArray[0] = tainted;
        ConnectionManager cm = new ConnectionManager();
        cm.publish(staticArray[0]);
        cm.publish(this.fieldArray[0]);
    }

    public void constantFieldTest() {
        ConstantClass c = new ConstantClass();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(c.e);
    }

    public void fpConstIntraproceduralTest1() {
        int i = 3;
        if (i > 5) {
            String tainted = TelephonyManager.getDeviceId();
            ConnectionManager cm = new ConnectionManager();
            cm.publish(tainted);
        }
    }

    public void fpConstInterproceduralTest1() {
        int i = 3;
        this.leakIfGreaterThan(i, 5);
    }

    private void leakIfGreaterThan(int i, int j) {
        if (i > j) {
            String tainted = TelephonyManager.getDeviceId();
            ConnectionManager cm = new ConnectionManager();
            cm.publish(tainted);
        }
    }

    public void fpConstInterproceduralTest2() {
        int i = 3;
        this.indirectLeakIfGreaterThan(i);
    }

    private void indirectLeakIfGreaterThan(int i) {
        this.leakIfGreaterThan(i, 5);
    }

    public void fpConstInterproceduralTest3() {
        int i = 3;
        this.indirectLeakIfGreaterThan2(i);
    }

    private void indirectLeakIfGreaterThan2(int i) {
        int j = i;
        this.leakIfGreaterThan(j, 5);
    }

    public void fpConstInterproceduralTest4() {
        int i = 3;
        this.indirectLeakIfGreaterThan2(i);
        this.indirectLeakIfGreaterThan2(7);
    }

    public void fpConstInterproceduralTest5() {
        int i = 3;
        this.indirectLeakIfGreaterThan2(i);
        this.indirectLeakIfGreaterThan2(3);
    }

    public void constRecursiveTest1() {
        this.leakRecursive(0);
    }

    private void leakRecursive(int i) {
        if (i > 0) {
            String tainted = TelephonyManager.getDeviceId();
            ConnectionManager cm = new ConnectionManager();
            cm.publish(tainted);
            return;
        }
        this.leakRecursive(0);
    }

    public void fpConstInterproceduralTest6() {
        int i = 3;
        this.leakIfGreaterThan(i, this.get5());
    }

    private int get5() {
        return 5;
    }

    public void constantExceptionTest1() {
        try {
            String secret = this.getSecretAndThrow();
            ConnectionManager cm = new ConnectionManager();
            cm.publish(secret);
        }
        catch (MyException ex) {
            ConnectionManager cm = new ConnectionManager();
            cm.publish(ex + TelephonyManager.getDeviceId());
        }
    }

    private String getSecretAndThrow() {
        if (Math.random() < 0.5) {
            return "foo";
        }
        throw new MyException();
    }

    public void allocSiteTest1() {
        String tainted = TelephonyManager.getDeviceId();
        int i = 3;
        Base obj = i > 10 ? new A() : new B();
        String copy = obj.transform(tainted);
        ConnectionManager cm = new ConnectionManager();
        cm.publish(copy);
    }

    private void nextNextLevelConst(int i) {
        if (i > 10) {
            String tainted = TelephonyManager.getDeviceId();
            ConnectionManager cm = new ConnectionManager();
            cm.publish(tainted);
        }
    }

    public void multiLevelConstTest1() {
        this.nextNextLevelConst(1);
        this.nextLevelConst(1);
    }

    private void nextLevelConst(int i) {
        this.nextNextLevelConst(i);
    }

    public void multiLevelReturnTest1() {
        int j;
        int i = this.returnFromNextLevel();
        if (i != (j = this.returnFromNextNextLevel())) {
            String tainted = TelephonyManager.getDeviceId();
            ConnectionManager cm = new ConnectionManager();
            cm.publish(tainted);
        }
    }

    private int returnFromNextLevel() {
        return this.returnFromNextNextLevel();
    }

    private int returnFromNextNextLevel() {
        return 5;
    }

    class ConstantClass {
        final String e = TelephonyManager.getDeviceId();
    }

    private class MyException
    extends RuntimeException {
        private static final long serialVersionUID = 3653915262998567435L;

        private MyException() {
        }
    }

    private class A
    extends Base {
        private A() {
        }

        @Override
        public String transform(String data) {
            return data;
        }
    }

    private class B
    extends Base {
        private B() {
        }

        @Override
        public String transform(String data) {
            return "foo";
        }
    }

    private abstract class Base {
        private Base() {
        }

        public abstract String transform(String var1);
    }
}

