/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test;

import java.util.ArrayList;
import java.util.Random;
import soot.jimple.infoflow.test.android.AccountManager;
import soot.jimple.infoflow.test.android.ConnectionManager;
import soot.jimple.infoflow.test.android.TelephonyManager;
import soot.jimple.infoflow.test.utilclasses.ClassWithField;
import soot.jimple.infoflow.test.utilclasses.ClassWithStatic;

public class HeapTestCode {
    private B b1;
    private B b2;
    private int intData;
    private static B staticB1;
    private static B staticB2;
    private static Tree myTree;
    private Data taintedBySourceSinkManager = null;
    Inner field = new Inner();
    public Book alias;

    public void simpleTest() {
        String taint = TelephonyManager.getDeviceId();
        Y a = new Y();
        Y b = new Y();
        a.set(taint);
        b.set("notaint");
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.f);
    }

    public void argumentTest() {
        ClassWithField x = new ClassWithField();
        HeapTestCode.run(x);
        x.listField = new ArrayList();
        x.listField.add(TelephonyManager.getDeviceId());
    }

    public static void run(ClassWithField o) {
        o = new ClassWithField();
        o.listField = new ArrayList();
        o.listField.add("empty");
        ConnectionManager cm = new ConnectionManager();
        cm.publish(o.field);
    }

    public void negativeTest() {
        String taint = TelephonyManager.getDeviceId();
        MyArrayList notRelevant = new MyArrayList();
        MyArrayList list = new MyArrayList();
        notRelevant.add(taint);
        list.add("test");
        ConnectionManager cm = new ConnectionManager();
        cm.publish(list.get());
    }

    public void doubleCallTest() {
        X a = new X();
        X b = new X();
        a.save("neutral");
        b.save(TelephonyManager.getDeviceId());
        ConnectionManager cm = new ConnectionManager();
        cm.publish(String.valueOf(a.e));
    }

    public void methodTest0() {
        String taint = TelephonyManager.getDeviceId();
        X x = new X();
        A a = new A();
        String str = x.xx(a);
        a.b = taint;
        ConnectionManager cm = new ConnectionManager();
        cm.publish(str);
    }

    public void methodTest0b() {
        String taint = TelephonyManager.getDeviceId();
        A a = new A();
        String str = a.b;
        a.b = taint;
        ConnectionManager cm = new ConnectionManager();
        cm.publish(str);
    }

    public void methodTest1() {
        String tainted = TelephonyManager.getDeviceId();
        new AsyncTask().execute(tainted);
    }

    public void methodTest2() {
        String tainted = TelephonyManager.getDeviceId();
        Worker wo = new Worker(){

            @Override
            public void call() {
                ConnectionManager cm = new ConnectionManager();
                cm.publish(this.mParams);
            }
        };
        wo.mParams = tainted;
        new FutureTask(wo).run();
    }

    public void methodTest3() {
        String tainted = TelephonyManager.getDeviceId();
        new AsyncTask2().execute(tainted);
    }

    public void testForWrapper() {
        ConnectionManager cm = new ConnectionManager();
        cm.publish("");
        ClassWithStatic cws = new ClassWithStatic();
        int i = 7;
        do {
            cws.getTitle();
        } while (i != 8);
        ClassWithStatic.staticString = TelephonyManager.getDeviceId();
    }

    public void testForLoop() {
        while (true) {
            WrapperClass f = new WrapperClass();
            f.sink();
            WrapperClass w = new WrapperClass();
            w.callIt();
        }
    }

    public void testForEarlyTermination() {
        ConnectionManager cm = new ConnectionManager();
        cm.publish(ClassWithStatic.staticString);
        ClassWithStatic c1 = new ClassWithStatic();
        WrapperClass w1 = new WrapperClass();
        w1.callIt();
    }

    public void methodReturn() {
        B b;
        B b2 = b = new B();
        b.attr = this.m();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b2.attr.b);
    }

    public A m() {
        A a = new A();
        a.b = TelephonyManager.getDeviceId();
        return a;
    }

    public void twoLevelTest() {
        SecondLevel l2 = new SecondLevel();
        FirstLevel l1 = new FirstLevel();
        String x = l1.getValue(l2, TelephonyManager.getDeviceId());
        String y = l1.getValue(l2, "test");
        x.toString();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(y);
    }

    public void multiAliasTest() {
        String a;
        DataClass dc3;
        DataClass dc = new DataClass();
        DataClass dc2 = null;
        dc2 = dc3 = new DataClass();
        dc2.next = dc;
        dc.data = a = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(dc3.next.data);
    }

    public void overwriteAliasTest() {
        String a;
        DataClass dc3;
        DataClass dc = new DataClass();
        DataClass dc2 = null;
        dc2 = dc3 = new DataClass();
        dc2.next = dc;
        dc3.next = null;
        dc.data = a = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(dc3.next.data);
    }

    public void arrayAliasTest() {
        String[] a;
        String[] b = a = new String[1];
        a[0] = TelephonyManager.getDeviceId();
        String[] c = b;
        ConnectionManager cm = new ConnectionManager();
        cm.publish(c[0]);
    }

    public void arrayAliasTest2() {
        String[] arr;
        String tainted = TelephonyManager.getDeviceId();
        String[] arr2 = arr = new String[]{"foo", "bar"};
        int size = arr.length;
        arr[1] = tainted;
        String x = arr2[1];
        ConnectionManager cm = new ConnectionManager();
        cm.publish(x);
        System.out.println(size);
    }

    public void functionAliasTest() {
        String tainted = TelephonyManager.getDeviceId();
        DataClass dc1 = new DataClass();
        DataClass dc2 = new DataClass();
        dc1.data = tainted;
        this.copy(dc1, dc2);
        ConnectionManager cm = new ConnectionManager();
        cm.publish(dc2.data);
    }

    private void copy(DataClass dc1, DataClass dc2) {
        dc2.data = dc1.data;
    }

    public void functionAliasTest2() {
        DataClass dc1 = new DataClass();
        DataClass dc2 = new DataClass();
        this.taintMe(dc1);
        this.copy(dc1, dc2);
        ConnectionManager cm = new ConnectionManager();
        cm.publish(dc2.data);
    }

    public void taintMe(DataClass dc) {
        String tainted;
        dc.data = tainted = TelephonyManager.getDeviceId();
    }

    public void multiLevelTaint() {
        String tainted = TelephonyManager.getDeviceId();
        B b = new B();
        A a = b.attr;
        this.taintLevel1(tainted, b);
        ConnectionManager cm = new ConnectionManager();
        cm.publish(a.b);
    }

    private void taintLevel1(String data, B b) {
        this.taintLevel2(data, b.attr);
    }

    private void taintLevel2(String data, A a) {
        a.b = data;
    }

    public void negativeMultiLevelTaint() {
        String tainted = TelephonyManager.getDeviceId();
        B b = new B();
        A a = b.attr;
        ConnectionManager cm = new ConnectionManager();
        cm.publish(a.b);
        this.taintLevel1(tainted, b);
    }

    public void negativeMultiLevelTaint2() {
        String tainted = TelephonyManager.getDeviceId();
        B b = new B();
        this.taintLevel1b(tainted, b);
    }

    private void taintLevel1b(String data, B b) {
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.attr.b);
        this.taintLevel2(data, b.attr);
    }

    public void multiLevelTaint2() {
        String tainted = TelephonyManager.getDeviceId();
        B b = new B();
        this.taintLevel1c(tainted, b);
    }

    private void taintLevel1c(String data, B b) {
        this.taintLevel2(data, b.attr);
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.attr.b);
    }

    public void threeLevelTest() {
        B b = new B();
        A a = b.attr;
        this.taintOnNextLevel(b, a);
    }

    private void taintMe(B b) {
        b.attr.b = TelephonyManager.getDeviceId();
    }

    private void taintOnNextLevel(B b, A a) {
        this.taintMe(b);
        ConnectionManager cm = new ConnectionManager();
        cm.publish(a.b);
    }

    public void recursionTest() {
        RecursiveDataClass rdc = new RecursiveDataClass();
        rdc.data = TelephonyManager.getDeviceId();
        rdc.leakIt();
    }

    public void activationUnitTest1() {
        String tainted;
        B b = new B();
        A a = b.attr;
        a.b = tainted = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.attr.b);
    }

    public void activationUnitTest2() {
        B b = new B();
        A a = b.attr = new A();
        String tainted = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.attr.b);
        a.b = tainted;
    }

    public void activationUnitTest3() {
        String tainted;
        B b = new B();
        b.attr = new A();
        B b2 = new B();
        b2.attr = new A();
        b2.attr.b = b.attr.b = (tainted = TelephonyManager.getDeviceId());
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b2.attr.b);
    }

    public void activationUnitTest4() {
        String tainted;
        B b = new B();
        b.attr = new A();
        B b2 = new B();
        b2.attr = new A();
        b2.attr.b = tainted = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.attr.b);
        b.attr.b = tainted;
    }

    public void activationUnitTest4b() {
        String tainted;
        B b = new B();
        b.attr = new A();
        B b2 = new B();
        b2.attr = new A();
        b2.attr.b = tainted = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.attr.b);
        b.attr = b2.attr;
    }

    public void activationUnitTest5() {
        B b = new B();
        b.attr = new A();
        B b2 = new B();
        b2.attr = new A();
        ConnectionManager cm = new ConnectionManager();
        String tainted = TelephonyManager.getDeviceId();
        cm.publish(b.attr.b);
        cm.publish(b2.attr.b);
        b.attr = b2.attr;
        cm.publish(b.attr.b);
        cm.publish(b2.attr.b);
        b.attr.b = tainted;
    }

    public void returnAliasTest() {
        B b;
        String tainted = TelephonyManager.getDeviceId();
        B c = b = new B();
        A a = this.alias(c);
        c.attr.b = tainted;
        b.attr.b = tainted;
        ConnectionManager cm = new ConnectionManager();
        cm.publish(a.b);
    }

    private A alias(B b) {
        return b.attr;
    }

    public void callPerformanceTest() {
        A a = new A();
        a.b = this.getDeviceId();
        B b = new B();
        b.attr = a;
        this.doIt(b);
    }

    private void doIt(B b) {
        this.throwAround(b);
        System.out.println(b.attr.b);
    }

    private String getDeviceId() {
        String tainted = TelephonyManager.getDeviceId();
        return tainted;
    }

    private void throwAround(B b) {
        this.throwAround2(b.attr);
    }

    private void throwAround2(A a) {
        ConnectionManager cm = new ConnectionManager();
        cm.publish(a.b);
    }

    private void foo(B b1, B b2) {
        this.b1 = b1;
        this.b2 = b2;
    }

    private void foo2(B b1, B b2) {
    }

    private A bar(A a) {
        this.b1.attr = a;
        return this.b2.attr;
    }

    private A bar2(A a) {
        return null;
    }

    public void testAliases() {
        B b = new B();
        A a = new A();
        a.b = TelephonyManager.getDeviceId();
        this.foo(b, b);
        String tainted = this.bar((A)a).b;
        ConnectionManager cm = new ConnectionManager();
        cm.publish(tainted);
    }

    public void testWrapperAliases() {
        B b = new B();
        A a = new A();
        a.b = TelephonyManager.getDeviceId();
        this.foo2(b, b);
        String tainted = this.bar2((A)a).b;
        ConnectionManager cm = new ConnectionManager();
        cm.publish(tainted);
    }

    public void negativeTestAliases() {
        B b = new B();
        A a = new A();
        a.b = TelephonyManager.getDeviceId();
        this.foo(b, b);
        String untainted = this.bar((A)a).c;
        ConnectionManager cm = new ConnectionManager();
        cm.publish(untainted);
    }

    private void alias(B b1, B b2) {
        b2.attr = b1.attr;
    }

    private void set(B a, String secret, B b) {
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.attr.b);
        a.attr.b = secret;
        cm.publish(b.attr.b);
    }

    private void foo(B a) {
        System.out.println(a);
    }

    public void aliasPerformanceTest() {
        B a = new B();
        B b = new B();
        this.alias(a, b);
        this.set(a, TelephonyManager.getDeviceId(), b);
        this.foo(a);
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.attr.b);
    }

    public void backwardsParameterTest() {
        B b1 = new B();
        b1.attr = new A();
        B b2 = new B();
        this.alias(b1, b2);
        b2.attr.b = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b1.attr.b);
    }

    public void aliasTaintLeakTaintTest() {
        B b = new B();
        A a = b.attr = new A();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.attr.b);
        b.attr.b = TelephonyManager.getDeviceId();
        cm.publish(a.b);
    }

    public void fieldBaseOverwriteTest() {
        A a = new A();
        a.b = TelephonyManager.getDeviceId();
        A a2 = a;
        ConnectionManager cm = new ConnectionManager();
        cm.publish(a2.b);
    }

    private A alias(A a) {
        return a;
    }

    public void doubleAliasTest() {
        A a = new A();
        A b = this.alias(a);
        A c = this.alias(a);
        a.b = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.b);
        cm.publish(c.b);
    }

    private A alias2(A a) {
        A a2 = a;
        return a2;
    }

    public void doubleAliasTest2() {
        A a = new A();
        A b = this.alias2(a);
        A c = this.alias2(a);
        a.b = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.b);
        cm.publish(c.b);
    }

    public void tripleAliasTest() {
        A a = new A();
        A b = this.alias(a);
        A c = this.alias(a);
        A d = this.alias(a);
        a.b = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.b);
        cm.publish(c.b);
        cm.publish(d.b);
    }

    public void singleAliasTest() {
        A a = new A();
        A b = this.alias(a);
        a.b = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.b);
    }

    public void negativeSingleAliasTest() {
        A a = new A();
        A b = this.fakeAlias(a);
        a.b = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.b);
    }

    public A doNotFold() {
        A a = new A();
        System.out.println("XXX");
        return a;
    }

    private A fakeAlias(A a) {
        return this.doNotFold();
    }

    private void setIntData() {
        this.intData = TelephonyManager.getIMEI();
    }

    public void intAliasTest() {
        this.setIntData();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(this.intData);
    }

    private void aliasStatic() {
        HeapTestCode.staticB2.attr = HeapTestCode.staticB1.attr;
    }

    public void staticAliasTest() {
        staticB1 = new B();
        staticB2 = new B();
        this.aliasStatic();
        HeapTestCode.staticB1.attr.b = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(HeapTestCode.staticB2.attr.b);
    }

    public void staticAliasTest2() {
        staticB2 = staticB1 = new B();
        HeapTestCode.staticB1.attr.b = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(HeapTestCode.staticB2.attr.b);
    }

    public void unAliasParameterTest() {
        B b1 = new B();
        B b2 = new B();
        b2.attr = b1.attr;
        this.doUnalias(b2);
        b1.attr.b = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b2.attr.b);
    }

    private void doUnalias(B b2) {
        b2.attr = new A();
    }

    public void overwriteParameterTest() {
        B b = new B();
        b.attr.b = TelephonyManager.getDeviceId();
        this.overwriteParameter(b);
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.attr.b);
    }

    private void overwriteParameter(B b) {
        System.out.println(b);
        b = new B();
    }

    public void multiAliasBaseTest() {
        A a = new A();
        B b1 = new B();
        B b2 = new B();
        b1.setAttr(a);
        b2.setAttr(a);
        a.b = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b1.attr.b);
        cm.publish(b2.attr.b);
    }

    public void innerClassTest() {
        Inner1 a = new Inner1();
        Inner1 b = new Inner1();
        a.obj = a.new Inner1.Inner2();
        b.obj = a.new Inner1.Inner2();
        a.obj.set();
        String untainted = b.get();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(untainted);
    }

    public void innerClassTest2() {
        Inner1b a = new Inner1b();
        Inner1b b = new Inner1b();
        a.obj = a.new Inner1b.Inner2b();
        b.obj = a.new Inner1b.Inner2b();
        a.obj.set();
        String untainted = b.get();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(untainted);
    }

    public void innerClassTest3() {
        Inner1b a = new Inner1b();
        Inner1b b = new Inner1b();
        a.obj = a.new Inner1b.Inner2b();
        b.obj = a.new Inner1b.Inner2b();
        b.obj.set();
        String untainted = a.get();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(untainted);
    }

    public void innerClassTest4() {
        Inner1b a = new Inner1b();
        Inner1b b = new Inner1b();
        a.obj = a.new Inner1b.Inner2b();
        b.obj = b.new Inner1b.Inner2b();
        a.obj.set();
        String untainted = b.obj.get();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(untainted);
    }

    public void innerClassTest5() {
        Inner3 a = new Inner3();
        Inner3 b = new Inner3();
        a.obj2 = b.new Inner3.Inner2b();
        a.obj2.foo = b.new Inner3.Inner2();
        a.obj2.foo.set();
        String untainted = a.get();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(untainted);
    }

    public void innerClassTest6() {
        Inner1b a = new Inner1b();
        a.obj = a.new Inner1b.Inner2b();
        a.parentData = TelephonyManager.getDeviceId();
        Inner1b.Inner2b inner = a.obj;
        ConnectionManager cm = new ConnectionManager();
        cm.publish(inner.getParent());
    }

    public void datastructureTest() {
        SimpleTree root = new SimpleTree();
        root.left = new SimpleTree();
        root.right = new SimpleTree();
        root.left.data = TelephonyManager.getDeviceId();
        root.right.data = "foo";
        ConnectionManager cm = new ConnectionManager();
        cm.publish(root.left.data);
    }

    public void datastructureTest2() {
        SimpleTree root = new SimpleTree();
        root.left = new SimpleTree();
        root.right = new SimpleTree();
        root.left.data = TelephonyManager.getDeviceId();
        root.right.data = "foo";
        ConnectionManager cm = new ConnectionManager();
        cm.publish(root.right.data);
    }

    public void staticAccessPathTest() {
        myTree = new Tree();
        HeapTestCode.myTree.left = new Tree();
        HeapTestCode.myTree.left.right = new Tree();
        HeapTestCode.myTree.left.right.left = myTree;
        HeapTestCode.myTree.data = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(HeapTestCode.myTree.left.right.left.data);
    }

    public void separatedTreeTest() {
        SeparatedTree myTree = new SeparatedTree();
        myTree.left = new TreeElement();
        myTree.left.child = new SeparatedTree();
        myTree.left.child.right = new TreeElement();
        myTree.left.child.right.data = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(myTree.left.child.right.data);
    }

    public void overwriteAliasedVariableTest() {
        Y y1;
        Y y2 = y1 = new Y();
        y1.f = TelephonyManager.getDeviceId();
        y2 = new Y();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(y1.f);
        cm.publish(y2.f);
    }

    public void overwriteAliasedVariableTest2() {
        Y y1;
        Y y2 = y1 = new Y();
        y1.f = TelephonyManager.getDeviceId();
        y2.f = "";
        ConnectionManager cm = new ConnectionManager();
        cm.publish(y1.f);
        cm.publish(y2.f);
    }

    public void overwriteAliasedVariableTest3() {
        Y y1;
        Y y2 = y1 = new Y();
        y1.f = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(y1.f);
        y2.f = "";
        cm.publish(y2.f);
    }

    public void overwriteAliasedVariableTest4() {
        Y y1;
        Y y2 = y1 = new Y();
        y1.f = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(y1.f);
        cm.publish(y2.f);
        y2.f = "";
    }

    public void overwriteAliasedVariableTest5() {
        ConnectionManager cm = new ConnectionManager();
        String x = TelephonyManager.getDeviceId();
        String y = new AccountManager().getPassword();
        String z = "";
        String z2 = z = x;
        String z3 = z = y;
        cm.publish(z2);
        cm.publish(z3);
    }

    public void overwriteAliasedVariableTest6() {
        Y y1 = new Y();
        y1.f = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(y1.f);
        y1 = null;
        cm.publish(y1.f);
    }

    public void aliasFlowTest() {
        A y;
        B a = new B();
        B p = new B();
        A b = new A();
        A q = new A();
        if (Math.random() < 0.5) {
            x = a;
            y = b;
        } else {
            x = p;
            y = q;
        }
        x.attr = y;
        q.b = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(a.attr.b);
    }

    private Data getSecretData() {
        return new Data();
    }

    private void leakData(Data e) {
        System.out.println(e);
    }

    public void aliasStrongUpdateTest() {
        Data d = this.getSecretData();
        Data e = d = d.next;
        Data x = new Data();
        x.next = e;
        Data y = x;
        e = y.next;
        e = e.next;
        this.leakData(e);
    }

    public void aliasStrongUpdateTest2() {
        Data x;
        Data d = this.getSecretData();
        Data e = d = d.next;
        Data y = x = new Data();
        x.next = e;
        e = y.next;
        e = e.next;
        this.leakData(e);
    }

    public void aliasStrongUpdateTest3() {
        Data x;
        Data d = this.taintedBySourceSinkManager;
        Data e = d = d.next;
        Data y = x = new Data();
        x.next = e;
        e = y.next;
        e = e.next;
        this.leakData(y.next);
    }

    public void arrayLengthAliasTest1() {
        String tainted = TelephonyManager.getDeviceId();
        String[] arr = new String[]{"foo", "xx", "bar"};
        int size = arr.length;
        arr[1] = tainted;
        ConnectionManager cm = new ConnectionManager();
        cm.publish(size);
    }

    public void arrayLengthAliasTest2() {
        String[] arr;
        String tainted = TelephonyManager.getDeviceId();
        String[] arr2 = arr = new String[]{"foo", "xx", "bar"};
        int size = arr.length;
        arr[1] = tainted;
        int size2 = arr2.length;
        ConnectionManager cm = new ConnectionManager();
        cm.publish(size2);
        System.out.println(size);
    }

    public void arrayLengthAliasTest3() {
        String tainted = TelephonyManager.getDeviceId();
        String[] arr = new String[tainted.length()];
        int size = arr.length;
        arr[1] = tainted;
        ConnectionManager cm = new ConnectionManager();
        cm.publish(size);
    }

    public void arrayLengthAliasTest4() {
        String[] arr;
        String tainted = TelephonyManager.getDeviceId();
        String[] arr2 = arr = new String[tainted.length()];
        int size = arr.length;
        arr[1] = tainted;
        int size2 = arr2.length;
        ConnectionManager cm = new ConnectionManager();
        cm.publish(size2);
        System.out.println(size);
    }

    public void taintPrimitiveFieldTest1() {
        A a;
        A b = a = new A();
        a.i = TelephonyManager.getIMEI();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.i);
    }

    public void taintPrimitiveFieldTest2() {
        A a;
        B b = new B();
        b.attr = a = new A();
        a.i = TelephonyManager.getIMEI();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.attr.i);
    }

    public void multiContextTest1() {
        A a = new A();
        a.b = TelephonyManager.getDeviceId();
        a.c = TelephonyManager.getDeviceId();
        String data = this.id(a.b);
        String data2 = this.id(a.c);
        ConnectionManager cm = new ConnectionManager();
        cm.publish(data);
        cm.publish(data2);
    }

    private String id(String val) {
        return val;
    }

    public void recursiveFollowReturnsPastSeedsTest1() {
        ConnectionManager cm = new ConnectionManager();
        cm.publish(this.doTaintRecursively(new A()));
    }

    private String doTaintRecursively(A a) {
        if (new Random().nextBoolean()) {
            a.b = TelephonyManager.getDeviceId();
            return "";
        }
        A a2 = new A();
        this.doTaintRecursively(a2);
        return a2.b;
    }

    public void doubleAliasTest1() {
        A a1 = new A();
        a1.b = TelephonyManager.getDeviceId();
        A a2 = new A();
        a2.b = new AccountManager().getPassword();
        B b = new B();
        b.attr = new Random().nextBoolean() ? a1 : a2;
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.attr.b);
    }

    public void longAPAliasTest1() {
        C c = new C();
        c.b = new B();
        A a = c.b.attr = new A();
        a.b = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(c.b.attr.b);
    }

    public void simpleFieldTest1() {
        A a = new A();
        B b = new B();
        b.attr = a;
        a.b = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.attr.b);
    }

    public void contextTest1() {
        A a = new A();
        A b = new A();
        String data = TelephonyManager.getDeviceId();
        this.copy(a, data);
        this.copy(b, "Hello World");
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.b);
    }

    private void copy(A b, String string) {
        A c = b;
        c.b = string;
    }

    public void contextTest2() {
        String data = TelephonyManager.getDeviceId();
        A a = this.copy(data);
        A b = this.copy("Hello World");
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.b);
        System.out.println(a);
    }

    private A copy(String data) {
        A a;
        A b = a = new A();
        b.b = data;
        return a;
    }

    public void contextTest3() {
        String data = TelephonyManager.getDeviceId();
        A a = this.copy(data, new AccountManager().getPassword());
        A b = this.copy("Hello World", "Foobar");
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.b);
        System.out.println(a);
    }

    private A copy(String context, String data) {
        A a;
        System.out.println(context);
        A b = a = new A();
        b.b = data;
        return a;
    }

    private void doWrite(Container2 base, String string) {
        base.f.g = string;
    }

    public void summaryTest1() {
        Container2 base1 = new Container2();
        Container2 base2 = new Container2();
        String tainted = TelephonyManager.getDeviceId();
        this.doWrite(base1, tainted);
        Container1 z = base2.f;
        this.doWrite(base2, tainted);
        ConnectionManager cm = new ConnectionManager();
        cm.publish(z.g);
    }

    public void delayedReturnTest1() {
        A a = new A();
        B b = new B();
        this.doAlias(b, a);
        a.b = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(b.attr.b);
    }

    private void doAlias(B b, A a) {
        b.attr = a;
    }

    public void aliasWithOverwriteTest1() {
        D d = new D();
        d.read();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(d.e.str);
    }

    public void aliasWithOverwriteTest2() {
        F f = new F();
        f.read();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(f.g.str);
    }

    public void aliasWithOverwriteTest3() {
        H h = new H();
        h.read();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(h.i.str2);
    }

    public void aliasWithOverwriteTest4() {
        J j = new J();
        j.read();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(j.f.str);
    }

    public void aliasWithOverwriteTest5() {
        D d = new D();
        E e = new E();
        d.setF(e);
        ConnectionManager cm = new ConnectionManager();
        cm.publish(d.e.str);
    }

    public void innerFieldReductionTestNegative() {
        Inner local = new Inner();
        local.secret = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(this.field.secret);
    }

    public void innerFieldReductionTestNegative2() {
        this.field.secret = TelephonyManager.getDeviceId();
        Inner local = new Inner();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(local.secret);
    }

    public void activationStatementTest1() {
        Book b;
        Book a = b = new Book();
        String specialName = b.name + "123";
        a.name = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(specialName);
    }

    public void callSiteCreatesAlias() {
        String tainted = TelephonyManager.getDeviceId();
        Book book1 = new Book();
        this.leakingCallee(tainted, new Book(), book1);
        this.leakingCallee(tainted, book1, book1);
    }

    void leakingCallee(String tainted, Book book1, Book book2) {
        book1.name = tainted;
        ConnectionManager cm = new ConnectionManager();
        cm.publish(book2.name);
    }

    public void lhsNotUpwardsInAliasFlow() {
        this.alias = new Book();
        Book book = new Book();
        Book alias2 = this.alias;
        this.alias = book;
        book.name = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(alias2.name);
    }

    public void identityStmtIsNotAGoodHandoverPoint() {
        Book book = new Book();
        this.callee(book);
        book.name = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(book.name);
    }

    void callee(Book b) {
        System.out.println(b);
    }

    public void testRecursiveAccessPath() {
        OuterClass o = new OuterClass();
        o.i = new InnerClass();
        o.i.o.i.str = TelephonyManager.getDeviceId();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(o.i.o.i.str);
    }

    public void removeEntailedAbstractionsTest1() {
        RecursiveDataClass rdc = new RecursiveDataClass();
        rdc.data = TelephonyManager.getDeviceId();
        rdc.leakIt();
        rdc.child = new RecursiveDataClass();
        rdc.child.data = TelephonyManager.getDeviceId();
        rdc.child.leakIt();
    }

    public void removeEntailedAbstractionsTest2() {
        OuterClass o = new OuterClass();
        o.i = new InnerClass();
        o.i.str = TelephonyManager.getDeviceId();
        o.i.leakIt();
        InnerClass i = new InnerClass();
        i.str = TelephonyManager.getDeviceId();
        i.leakIt();
    }

    private class Data {
        public Data next;

        private Data() {
        }
    }

    class Inner {
        String secret;

        Inner() {
        }
    }

    public class Y {
        String f;

        public void set(String s) {
            this.f = s;
        }
    }

    class MyArrayList {
        String[] elements;

        MyArrayList() {
        }

        public void add(String obj) {
            if (this.elements == null) {
                this.elements = new String[3];
            }
            this.elements[0] = obj;
        }

        public String get() {
            return this.elements[0];
        }
    }

    class X {
        public char[] e;

        X() {
        }

        public String xx(A o) {
            return o.b;
        }

        public void save(String f) {
            this.e = f.toCharArray();
        }
    }

    class A {
        public String b = "Y";
        public String c = "X";
        public int i = 0;

        A() {
        }
    }

    protected class AsyncTask {
        public Worker mWorker;
        public FutureTask mFuture;

        public AsyncTask() {
            this.mWorker = new Worker(){

                @Override
                public void call() {
                    ConnectionManager cm = new ConnectionManager();
                    cm.publish(this.mParams);
                }
            };
            this.mFuture = new FutureTask(this.mWorker);
        }

        public void execute(String t) {
            this.mWorker.mParams = t;
            this.mFuture.run();
        }
    }

    protected class Worker {
        public String mParams;

        protected Worker() {
        }

        public void call() {
        }
    }

    protected class FutureTask {
        private final Worker wo;

        public FutureTask(Worker w) {
            this.wo = w;
        }

        public void run() {
            this.wo.call();
        }
    }

    protected class AsyncTask2 {
        public Worker mWorker;

        public AsyncTask2() {
            this.mWorker = new Worker(){

                @Override
                public void call() {
                    ConnectionManager cm = new ConnectionManager();
                    cm.publish(this.mParams);
                }
            };
        }

        public void execute(String t) {
            this.mWorker.mParams = t;
            this.mWorker.call();
        }
    }

    class WrapperClass {
        WrapperClass() {
        }

        public void callIt() {
            ClassWithStatic.staticString = TelephonyManager.getDeviceId();
        }

        public void sink() {
            ConnectionManager cm = new ConnectionManager();
            cm.publish(ClassWithStatic.staticString);
        }
    }

    public class B {
        public A attr;

        public B() {
            this.attr = new A();
        }

        public void setAttr(A attr) {
            this.attr = attr;
        }
    }

    public class SecondLevel {
        public String id(String i) {
            return i;
        }
    }

    public class FirstLevel {
        public String getValue(SecondLevel l, String c) {
            return l.id(c);
        }
    }

    private class DataClass {
        public String data;
        public DataClass next;

        private DataClass() {
        }
    }

    private class RecursiveDataClass {
        RecursiveDataClass child;
        String data;

        private RecursiveDataClass() {
        }

        public void leakIt() {
            ConnectionManager cm = new ConnectionManager();
            cm.publish(this.data);
            if (this.child != null) {
                this.child.leakIt();
            }
        }
    }

    private class Inner1 {
        private Inner2 obj;

        private Inner1() {
        }

        public String get() {
            return this.obj.data;
        }

        private class Inner2 {
            private String data;

            private Inner2() {
            }

            public void set() {
                this.data = TelephonyManager.getDeviceId();
            }
        }
    }

    private class Inner1b {
        public Inner2b obj;
        public String parentData;

        private Inner1b() {
        }

        public String get() {
            return this.obj.data;
        }

        private class Inner2b {
            public String data;

            private Inner2b() {
            }

            public void set() {
                Inner1b.this.obj.data = TelephonyManager.getDeviceId();
            }

            public String get() {
                return Inner1b.this.obj.data;
            }

            public String getParent() {
                return Inner1b.this.parentData;
            }
        }
    }

    private class Inner3 {
        private String data;
        private Inner2b obj2;

        private Inner3() {
        }

        public String get() {
            return this.data;
        }

        private class Inner2 {
            private Inner2() {
            }

            public void set() {
                Inner3.this.data = TelephonyManager.getDeviceId();
            }
        }

        private class Inner2b {
            private Inner2 foo;

            private Inner2b() {
            }
        }
    }

    private class SimpleTree {
        private String data = "";
        private SimpleTree left;
        private SimpleTree right;

        private SimpleTree() {
        }
    }

    private class Tree {
        private Tree left;
        private Tree right;
        private String data;

        private Tree() {
        }
    }

    private class SeparatedTree {
        private TreeElement left;
        private TreeElement right;

        private SeparatedTree() {
        }
    }

    private class TreeElement {
        private SeparatedTree child;
        private String data;

        private TreeElement() {
        }
    }

    private class C {
        private B b;

        private C() {
        }
    }

    public static class Container2 {
        Container1 f;
    }

    public static class Container1 {
        String g;
    }

    class D {
        E e;

        D() {
        }

        public void read() {
            this.e = new E();
            this.e.read();
        }

        public void setF(E e) {
            this.e = e;
            this.e.setF(e);
        }
    }

    class E {
        String str;

        E() {
        }

        public void read() {
            this.str = "";
            this.str = TelephonyManager.getDeviceId();
        }

        public void setF(E e) {
            e.str = "";
            e.str = TelephonyManager.getDeviceId();
        }
    }

    class F {
        G g;

        F() {
        }

        public void read() {
            this.g = new G();
            this.g.read();
        }
    }

    class G {
        String str;

        G() {
        }

        public void read() {
            this.str = TelephonyManager.getDeviceId();
        }
    }

    class H {
        I i;

        H() {
        }

        public void read() {
            this.i = new I();
            this.i.read();
        }
    }

    class I {
        String str;
        String str2;

        I() {
        }

        public void read() {
            this.str2 = this.str = "";
            this.str = TelephonyManager.getDeviceId();
        }
    }

    class J {
        E e;
        E f;

        J() {
        }

        public void read() {
            this.f = this.e = new E();
            this.e.read();
        }
    }

    private static class Book {
        public String name;

        private Book() {
        }
    }

    public static class OuterClass {
        InnerClass i;
    }

    public static class InnerClass {
        OuterClass o;
        String str;

        public void leakIt() {
            ConnectionManager cm = new ConnectionManager();
            cm.publish(this.str);
        }
    }
}

