/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test;

import soot.jimple.infoflow.test.android.ConnectionManager;

public class SourceSinkTestCode {
    private A getSecret() {
        return new A("Secret");
    }

    private B getSecret2() {
        return new B();
    }

    public void testDataObject() {
        A a = this.getSecret();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(a.data);
    }

    private void doSomething(Object o) {
        ConnectionManager cm = new ConnectionManager();
        cm.publish("" + o);
    }

    public void testAccessPathTypes() {
        A a = this.getSecret();
        this.doSomething(a);
        B b = this.getSecret2();
        this.doSomething(b);
    }

    public void testSourceAccessPaths() {
        A a = this.getSecret();
        ConnectionManager cm = new ConnectionManager();
        cm.publish(a.getData2());
    }

    private void doLeakSecret(String s) {
        System.out.println(s);
    }

    public void testSinkAccessPaths() {
        A a = this.getSecret();
        this.doLeakSecret(a.data);
    }

    public void testSinkAccessPaths2() {
        A a = this.getSecret();
        a.data2 = a.data;
        this.doLeakSecret(a.data2);
    }

    public void ifAsSinkTest() {
        long x = System.currentTimeMillis();
        if (x > 100L) {
            System.out.println("Greater");
        } else {
            System.out.println("Smaller");
        }
    }

    public void sourceToSourceTest() {
        A a = this.getSecret();
        String s = a.getSecret();
        this.doLeakSecret(s);
    }

    private void source(A a) {
        a.data = "Hello World";
    }

    private void annotatedSource(Object o) {
    }

    public void parameterSourceTest1() {
        A a = new A("x");
        this.source(a);
        this.doLeakSecret(a.data);
    }

    public void parameterSourceTest2() {
        C c = new C();
        A a = c.a;
        this.source(a);
        this.doLeakSecret(c.a.data);
    }

    public void parameterSourceTest3() {
        C c = new C();
        A a = c.a;
        this.annotatedSource(a.data);
        this.doLeakSecret(c.a.data);
    }

    public void parameterSourceTest4() {
        C c = new C();
        this.annotatedSource(c.a.data);
        A a = c.a;
        this.doLeakSecret(a.data);
    }

    private class A
    extends Base {
        private String data;
        private String data2;

        public A(String data) {
            this.data = data;
            this.data2 = "foo";
        }

        public String getData2() {
            return this.data2;
        }

        public String getSecret() {
            return "Secret";
        }
    }

    private class B
    extends Base {
        private B() {
        }
    }

    private class C {
        private A a;

        public C() {
            this.a = new A("Hello World");
        }
    }

    private class Base {
        private String x = "foo";

        private Base() {
        }

        public String toString() {
            return this.x;
        }
    }
}

