/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.base;

import jakarta.servlet.http.HttpServlet;
import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public abstract class AbstractJUnitTests {
    protected static void appendWithSeparator(StringBuilder sb, File f) throws IOException {
        if (f.exists()) {
            if (sb.length() > 0) {
                sb.append(System.getProperty("path.separator"));
            }
            sb.append(f.getCanonicalPath());
        }
    }

    protected static void addTestPathes(File rootDir, StringBuilder appPathBuilder) throws IOException {
        File testSrc1 = new File(rootDir, "bin");
        File testSrc2 = new File(rootDir, "build" + File.separator + "classes");
        File testSrc3 = new File(rootDir, "build" + File.separator + "testclasses");
        if (!(testSrc1.exists() || testSrc2.exists() || testSrc3.exists())) {
            Assert.fail((String)String.format("Test aborted - none of the test sources are available at root %s", rootDir.getCanonicalPath()));
        }
        AbstractJUnitTests.appendWithSeparator(appPathBuilder, testSrc1);
        AbstractJUnitTests.appendWithSeparator(appPathBuilder, testSrc2);
        AbstractJUnitTests.appendWithSeparator(appPathBuilder, testSrc3);
    }

    protected static void addRtJarPath(StringBuilder libPathBuilder) throws IOException {
        String javaBaseDir = System.getProperty("java.home") + File.separator + "lib" + File.separator;
        AbstractJUnitTests.appendWithSeparator(libPathBuilder, new File(javaBaseDir + "rt.jar"));
        AbstractJUnitTests.appendWithSeparator(libPathBuilder, new File("/usr/lib/jvm/java-8-openjdk-amd64/jre/lib/rt.jar"));
        AbstractJUnitTests.appendWithSeparator(libPathBuilder, new File("C:\\Program Files\\Java\\java-se-8u41-ri\\jre\\lib\\rt.jar"));
        String jakartaJAR = HttpServlet.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        AbstractJUnitTests.appendWithSeparator(libPathBuilder, new File(jakartaJAR));
        String springJAR = MultipartHttpServletRequest.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        AbstractJUnitTests.appendWithSeparator(libPathBuilder, new File(springJAR));
    }
}

