/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.junit;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import soot.jimple.Stmt;
import soot.jimple.infoflow.IInfoflow;
import soot.jimple.infoflow.results.DataFlowResult;
import soot.jimple.infoflow.results.ResultSourceInfo;
import soot.jimple.infoflow.test.junit.JUnitTests;

public abstract class AlwaysShortenTests
extends JUnitTests {
    private boolean pathContainsStmt(ResultSourceInfo sourceInfo, String signature) {
        for (Stmt stmt : sourceInfo.getPath()) {
            if (!signature.equals(stmt.toString())) continue;
            return true;
        }
        return false;
    }

    @Test
    public void alwaysShortenTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void alwaysShortenTest1(int)>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertEquals((long)2L, (long)infoflow.getResults().getResultSet().stream().map(res -> res.getSource().getStmt()).distinct().count());
        for (DataFlowResult res2 : infoflow.getResults().getResultSet()) {
            Assert.assertFalse((boolean)this.pathContainsStmt(res2.getSource(), "$stack2 = i + 42"));
        }
    }

    @Test
    public void alwaysShortenTest2() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void alwaysShortenTest2(int)>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertEquals((long)1L, (long)infoflow.getResults().getResultSet().size());
        for (DataFlowResult res : infoflow.getResults().getResultSet()) {
            Assert.assertFalse((boolean)this.pathContainsStmt(res.getSource(), "$stack2 = i + 42"));
        }
    }
}

