/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.junit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Test;
import soot.Body;
import soot.Local;
import soot.LocalGenerator;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.infoflow.IInfoflow;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.handlers.PreAnalysisHandler;
import soot.jimple.infoflow.test.junit.JUnitTests;

public abstract class BytecodeTests
extends JUnitTests {
    public Container source() {
        return new Container();
    }

    public void sink(Container c) {
    }

    public static void dummy() {
        Container c = new Container();
        System.out.println(c);
    }

    @Test
    public void flowSensitivityTest1() {
        List<String> sources = Collections.singletonList("<soot.jimple.infoflow.test.junit.BytecodeTests: soot.jimple.infoflow.test.junit.BytecodeTests$Container source()>");
        List<String> sinks = Collections.singletonList("<soot.jimple.infoflow.test.junit.BytecodeTests: void sink(soot.jimple.infoflow.test.junit.BytecodeTests$Container)>");
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.junit.BytecodeTests: void dummy()>");
        infoflow.addPreprocessor(new PreAnalysisHandler(){

            public void onBeforeCallgraphConstruction() {
                BytecodeTests.this.createBytecodeFlowSensitivityTest1();
            }

            public void onAfterCallgraphConstruction() {
            }
        });
        infoflow.getConfig().setCodeEliminationMode(InfoflowConfiguration.CodeEliminationMode.NoCodeElimination);
        infoflow.computeInfoflow(appPath, libPath, epoints, sources, sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    private void createBytecodeFlowSensitivityTest1() {
        SootClass testClass = new SootClass("TestClass");
        Scene sc = Scene.v();
        sc.addClass(testClass);
        testClass.setApplicationClass();
        SootMethod smSource = Scene.v().getMethod("<soot.jimple.infoflow.test.junit.BytecodeTests: soot.jimple.infoflow.test.junit.BytecodeTests$Container source()>");
        SootMethod smSink = Scene.v().getMethod("<soot.jimple.infoflow.test.junit.BytecodeTests: void sink(soot.jimple.infoflow.test.junit.BytecodeTests$Container)>");
        SootMethod consContainer = Scene.v().getMethod("<soot.jimple.infoflow.test.junit.BytecodeTests$Container: void <init>()>");
        RefType containerType = Scene.v().getRefType("soot.jimple.infoflow.test.junit.BytecodeTests$Container");
        SootMethod smOnCreate = Scene.v().makeSootMethod("onCreate", Collections.singletonList(containerType), (Type)VoidType.v());
        testClass.addMethod(smOnCreate);
        smOnCreate.setModifiers(9);
        JimpleBody bOnCreate = Jimple.v().newBody(smOnCreate);
        smOnCreate.setActiveBody((Body)bOnCreate);
        LocalGenerator localGenOnCreate = Scene.v().createLocalGenerator((Body)bOnCreate);
        Local thisOnCreate = localGenOnCreate.generateLocal((Type)testClass.getType());
        Local param0onCreate = localGenOnCreate.generateLocal((Type)containerType);
        bOnCreate.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)thisOnCreate, (Value)Jimple.v().newThisRef(testClass.getType())));
        bOnCreate.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)param0onCreate, (Value)Jimple.v().newParameterRef((Type)containerType, 0)));
        SootMethod smTarget = Scene.v().makeSootMethod("callTarget", Collections.singletonList(containerType), (Type)VoidType.v());
        testClass.addMethod(smTarget);
        smTarget.setModifiers(9);
        JimpleBody bTarget = Jimple.v().newBody(smTarget);
        smTarget.setActiveBody((Body)bTarget);
        LocalGenerator localGenTarget = Scene.v().createLocalGenerator((Body)bTarget);
        Local thisTarget = localGenTarget.generateLocal((Type)testClass.getType());
        Local param0Target = localGenTarget.generateLocal((Type)containerType);
        bTarget.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)thisTarget, (Value)Jimple.v().newThisRef(testClass.getType())));
        bTarget.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)param0Target, (Value)Jimple.v().newParameterRef((Type)containerType, 0)));
        bTarget.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)param0Target, (Value)Jimple.v().newVirtualInvokeExpr(thisTarget, smSource.makeRef())));
        bTarget.getUnits().add((Unit)Jimple.v().newReturnVoidStmt());
        bOnCreate.getUnits().add((Unit)Jimple.v().newInvokeStmt((Value)Jimple.v().newStaticInvokeExpr(smTarget.makeRef(), (Value)param0onCreate)));
        bOnCreate.getUnits().add((Unit)Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(thisOnCreate, smSink.makeRef(), Collections.singletonList(param0onCreate))));
        bOnCreate.getUnits().add((Unit)Jimple.v().newReturnVoidStmt());
        SootMethod smEntryPoint = Scene.v().getMethod("<soot.jimple.infoflow.test.junit.BytecodeTests: void dummy()>");
        Body bEntryPoint = smEntryPoint.retrieveActiveBody();
        LocalGenerator localGenEntryPoint = Scene.v().createLocalGenerator(bEntryPoint);
        Local containerEntryPoint = localGenEntryPoint.generateLocal((Type)containerType);
        bEntryPoint.getUnits().insertBefore((Unit)Jimple.v().newAssignStmt((Value)containerEntryPoint, (Value)Jimple.v().newNewExpr(containerType)), smEntryPoint.getActiveBody().getUnits().getLast());
        bEntryPoint.getUnits().insertBefore((Unit)Jimple.v().newInvokeStmt((Value)Jimple.v().newSpecialInvokeExpr(containerEntryPoint, consContainer.makeRef())), smEntryPoint.getActiveBody().getUnits().getLast());
        InvokeStmt stmtCall = Jimple.v().newInvokeStmt((Value)Jimple.v().newStaticInvokeExpr(smOnCreate.makeRef(), Collections.singletonList(containerEntryPoint)));
        bEntryPoint.getUnits().insertBefore((Unit)stmtCall, smEntryPoint.getActiveBody().getUnits().getLast());
    }

    public static class Container {
        public String data = "";
    }
}

