/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.junit;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import soot.jimple.infoflow.IInfoflow;
import soot.jimple.infoflow.taintWrappers.EasyTaintWrapper;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.test.junit.JUnitTests;

public abstract class EasyWrapperTests
extends JUnitTests {
    protected EasyTaintWrapper easyWrapper = EasyTaintWrapper.getDefault();

    @Test(timeout=300000L)
    public void equalsTest() {
        EasyTaintWrapper wrapper = this.easyWrapper.clone();
        wrapper.setAlwaysModelEqualsHashCode(true);
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.EasyWrapperTestCode: void equalsTest()>");
        infoflow.setTaintWrapper((ITaintPropagationWrapper)wrapper);
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void hashCodeTest() {
        EasyTaintWrapper wrapper = this.easyWrapper.clone();
        wrapper.setAlwaysModelEqualsHashCode(true);
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.EasyWrapperTestCode: void hashCodeTest()>");
        infoflow.setTaintWrapper((ITaintPropagationWrapper)wrapper);
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void equalsTest2() {
        EasyTaintWrapper wrapper = this.easyWrapper.clone();
        wrapper.setAlwaysModelEqualsHashCode(true);
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.EasyWrapperTestCode: void equalsTest2()>");
        infoflow.setTaintWrapper((ITaintPropagationWrapper)wrapper);
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void hashCodeTest2() {
        EasyTaintWrapper wrapper = this.easyWrapper.clone();
        wrapper.setAlwaysModelEqualsHashCode(true);
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.EasyWrapperTestCode: void hashCodeTest2()>");
        infoflow.setTaintWrapper((ITaintPropagationWrapper)wrapper);
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void getConstantTest() {
        EasyTaintWrapper wrapper = this.easyWrapper.clone();
        wrapper.setAggressiveMode(true);
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.EasyWrapperTestCode: void constantTest1()>");
        infoflow.setTaintWrapper((ITaintPropagationWrapper)wrapper);
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void getConstantTest2() {
        EasyTaintWrapper wrapper = this.easyWrapper.clone();
        wrapper.setAggressiveMode(false);
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.EasyWrapperTestCode: void constantTest1()>");
        infoflow.setTaintWrapper((ITaintPropagationWrapper)wrapper);
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void interfaceInheritanceTest() {
        EasyTaintWrapper wrapper = this.easyWrapper.clone();
        wrapper.addIncludePrefix("soot.jimple.infoflow.test");
        wrapper.addMethodForWrapping("soot.jimple.infoflow.test.EasyWrapperTestCode$I1", "java.lang.String getSecret()");
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.EasyWrapperTestCode: void interfaceInheritanceTest()>");
        infoflow.setTaintWrapper((ITaintPropagationWrapper)wrapper);
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void interfaceInheritanceTest2() {
        EasyTaintWrapper wrapper = this.easyWrapper.clone();
        wrapper.addIncludePrefix("soot.jimple.infoflow.test");
        wrapper.addMethodForWrapping("soot.jimple.infoflow.test.EasyWrapperTestCode$I1", "void taintMe(java.lang.String)");
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.EasyWrapperTestCode: void interfaceInheritanceTest2()>");
        infoflow.setTaintWrapper((ITaintPropagationWrapper)wrapper);
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void interfaceInheritanceTest3() {
        EasyTaintWrapper wrapper = this.easyWrapper.clone();
        wrapper.addIncludePrefix("soot.jimple.infoflow.test");
        wrapper.addMethodForWrapping("soot.jimple.infoflow.test.EasyWrapperTestCode$I1", "void taintMe(java.lang.String)");
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.EasyWrapperTestCode: void interfaceInheritanceTest3()>");
        infoflow.setTaintWrapper((ITaintPropagationWrapper)wrapper);
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void interfaceInheritanceTest4() {
        EasyTaintWrapper wrapper = this.easyWrapper.clone();
        wrapper.addIncludePrefix("soot.jimple.infoflow.test");
        wrapper.addMethodForWrapping("soot.jimple.infoflow.test.EasyWrapperTestCode$I1", "void taintMe(java.lang.String)");
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.EasyWrapperTestCode: void interfaceInheritanceTest4()>");
        infoflow.setTaintWrapper((ITaintPropagationWrapper)wrapper);
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void stringConcatTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.EasyWrapperTestCode: void stringConcatTest()>");
        infoflow.setTaintWrapper((ITaintPropagationWrapper)this.easyWrapper);
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.TelephonyManager: java.lang.String getDeviceId()>"));
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.AccountManager: java.lang.String getPassword()>"));
    }

    @Test(timeout=300000L)
    public void wrapperMissAndCalleeOverwritesTaint() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.EasyWrapperTestCode: void wrapperMissAndCalleeOverwritesTaint()>");
        infoflow.setTaintWrapper((ITaintPropagationWrapper)this.easyWrapper);
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void wrapperHitAndCalleeOverwritesTaint() throws IOException {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.EasyWrapperTestCode: void wrapperMissAndCalleeOverwritesTaint()>");
        infoflow.setTaintWrapper((ITaintPropagationWrapper)new EasyTaintWrapper((Reader)new StringReader("^soot.jimple.infoflow.test.EasyWrapperTestCode$Wrapper")));
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }
}

