/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.junit;

import org.junit.Assert;
import org.junit.Test;
import soot.jimple.infoflow.util.extensiblelist.ExtensibleList;

public class ExtensibleListTest {
    @Test
    public void test() {
        ExtensibleList l1 = new ExtensibleList();
        l1.addAll((Object[])new Integer[]{1, 2, 3});
        Assert.assertEquals((long)3L, (long)l1.size());
        Assert.assertEquals((long)3L, (long)((Integer)l1.removeLast()).intValue());
        Assert.assertEquals((long)2L, (long)l1.size());
        Assert.assertEquals((long)2L, (long)((Integer)l1.getLast()).intValue());
        ExtensibleList cmp = new ExtensibleList();
        cmp.addAll((Object[])new Integer[]{1, 2});
        Assert.assertEquals((Object)cmp, (Object)l1);
        ExtensibleList l2 = new ExtensibleList(l1);
        l2.addAll((Object[])new Integer[]{3, 4});
        ExtensibleList l3 = new ExtensibleList(l2);
        l3.addAll((Object[])new Integer[]{5});
        this.testListForward((ExtensibleList<Integer>)l2, 1, 2, 3, 4);
        l2.addAll((Object[])new Integer[]{-1, -2});
        l1.add((Object)-2);
        this.testListForward((ExtensibleList<Integer>)l3, 1, 2, 3, 4, 5);
        l3 = l3.addFirstSlow((Object)9);
        this.testListForward((ExtensibleList<Integer>)l3, 9, 1, 2, 3, 4, 5);
    }

    @Test
    public void testSafety() {
        ExtensibleList l1 = new ExtensibleList();
        l1.addAll((Object[])new Integer[]{1, 2, 3});
        ExtensibleList l2 = new ExtensibleList(l1);
        l2.add((Object)4);
        Assert.assertEquals((long)4L, (long)((Integer)l2.removeLast()).intValue());
        ExtensibleList l3 = (ExtensibleList)l1.removeLast();
        this.testListForward((ExtensibleList<Integer>)l3, 1, 2);
        this.testListForward((ExtensibleList<Integer>)l1, 1, 2, 3);
    }

    @Test
    public void testSafety2() {
        ExtensibleList l1 = new ExtensibleList();
        l1.addAll((Object[])new Integer[]{1, 2, 3});
        ExtensibleList l2 = new ExtensibleList(l1);
        this.testListForward((ExtensibleList<Integer>)l2, 1, 2, 3);
        l2 = (ExtensibleList)l2.removeLast();
        this.testListForward((ExtensibleList<Integer>)l2, 1, 2);
        this.testListForward((ExtensibleList<Integer>)l1, 1, 2, 3);
    }

    @Test
    public void testRemoveLast() {
        ExtensibleList l1 = new ExtensibleList();
        l1.addAll((Object[])new Integer[]{1, 2, 3});
        Assert.assertEquals((Object)3, (Object)l1.removeLast());
        Assert.assertEquals((long)2L, (long)l1.size());
        l1.add((Object)42);
        Assert.assertEquals((Object)42, (Object)l1.removeLast());
        Assert.assertEquals((long)2L, (long)l1.size());
    }

    private void testListForward(ExtensibleList<Integer> l, int ... test) {
        Assert.assertEquals((long)test.length, (long)l.size());
        if (test.length > 0 && !((Integer)l.getFirstSlow()).equals(test[0])) {
            throw new AssertionError();
        }
        int r = (Integer)l.getLast();
        Assert.assertEquals((long)r, (long)test[test.length - 1]);
        ExtensibleList cmp = new ExtensibleList();
        for (int i : test) {
            cmp.add((Object)i);
        }
        Assert.assertEquals(l, (Object)cmp);
        Assert.assertEquals((long)l.hashCode(), (long)cmp.hashCode());
        ExtensibleList.ExtensibleListIterator it = l.reverseIterator();
        for (int i = test.length - 1; i >= 0; --i) {
            int c = test[i];
            Assert.assertTrue((boolean)it.hasNext());
            int actual = (Integer)it.next();
            Assert.assertEquals((long)c, (long)actual);
        }
        Assert.assertFalse((boolean)it.hasNext());
    }
}

