/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.junit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import soot.RefType;
import soot.Scene;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.IInfoflow;
import soot.jimple.infoflow.Infoflow;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.entryPointCreators.DefaultEntryPointCreator;
import soot.jimple.infoflow.entryPointCreators.IEntryPointCreator;
import soot.jimple.infoflow.entryPointCreators.SequentialEntryPointCreator;
import soot.jimple.infoflow.handlers.TaintPropagationHandler;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.MethodSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.manager.ISourceSinkManager;
import soot.jimple.infoflow.sourcesSinks.manager.SinkInfo;
import soot.jimple.infoflow.sourcesSinks.manager.SourceInfo;
import soot.jimple.infoflow.taintWrappers.AbstractTaintWrapper;
import soot.jimple.infoflow.taintWrappers.IReversibleTaintWrapper;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.test.junit.JUnitTests;

public abstract class HeapTests
extends JUnitTests {
    @Test(timeout=300000L)
    public void testForEarlyTermination() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void testForEarlyTermination()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void testForLoop() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void testForLoop()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void testForWrapper() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void testForWrapper()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void simpleTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void simpleTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void argumentTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void argumentTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void negativeTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void negativeTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void doubleCallTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void doubleCallTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void heapTest0() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void methodTest0()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void heapTest0b() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void methodTest0b()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void heapTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void methodTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void testExample1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ForwardBackwardTest: void testMethod()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void testReturn() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void methodReturn()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void testTwoLevels() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void twoLevelTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void multiAliasTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void multiAliasTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void multiAliasNoRecusiveAPTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().getAccessPathConfiguration().setUseRecursiveAccessPaths(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void multiAliasTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void overwriteAliasTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().getAccessPathConfiguration().setUseRecursiveAccessPaths(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void overwriteAliasTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void arrayAliasTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void arrayAliasTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void arrayAliasTest2() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void arrayAliasTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void functionAliasTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void functionAliasTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void functionAliasTest2() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void functionAliasTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void multiLevelTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void multiLevelTaint()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void multiLevelTest2() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void multiLevelTaint2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void negativeMultiLevelTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void negativeMultiLevelTaint()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void negativeMultiLevelTest2() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void negativeMultiLevelTaint2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void threeLevelTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void threeLevelTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void threeLevelShortAPTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().getAccessPathConfiguration().setAccessPathLength(1);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void threeLevelTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void recursionTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void recursionTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void activationUnitTest1() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void activationUnitTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void activationUnitTest2() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void activationUnitTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void activationUnitTest3() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void activationUnitTest3()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void activationUnitTest4() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void activationUnitTest4()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void activationUnitTest4b() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void activationUnitTest4b()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void activationUnitTest5() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void activationUnitTest5()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void returnAliasTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void returnAliasTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void callPerformanceTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void callPerformanceTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void aliasesTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().getAccessPathConfiguration().setAccessPathLength(5);
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void testAliases()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void wrapperAliasesTest() {
        IInfoflow infoflow = this.initInfoflow();
        MyTaintWrapper taintWrapper = new MyTaintWrapper();
        infoflow.setTaintWrapper((ITaintPropagationWrapper)taintWrapper);
        infoflow.getConfig().getAccessPathConfiguration().setAccessPathLength(3);
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void testWrapperAliases()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void negativeAliasesTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().getAccessPathConfiguration().setAccessPathLength(4);
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void negativeTestAliases()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void aliasPerformanceTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().getAccessPathConfiguration().setAccessPathLength(3);
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void aliasPerformanceTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 2);
    }

    @Test(timeout=300000L)
    public void aliasPerformanceTestFIS() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().getAccessPathConfiguration().setAccessPathLength(3);
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void aliasPerformanceTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 3);
    }

    @Test(timeout=300000L)
    public void backwardsParameterTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void backwardsParameterTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void aliasTaintLeakTaintTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void aliasTaintLeakTaintTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void fieldBaseOverwriteTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void fieldBaseOverwriteTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void doubleAliasTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void doubleAliasTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 2);
    }

    @Test(timeout=300000L)
    public void doubleAliasTest2() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void doubleAliasTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 2);
    }

    @Test(timeout=300000L)
    public void tripleAliasTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void tripleAliasTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 3);
    }

    @Test(timeout=300000L)
    public void singleAliasTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void singleAliasTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void negativeSingleAliasTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void negativeSingleAliasTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void intAliasTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void intAliasTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void staticAliasTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void staticAliasTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void staticAliasTest2() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void staticAliasTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void unAliasParameterTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void unAliasParameterTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void overwriteParameterTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void overwriteParameterTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void multiAliasBaseTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void multiAliasBaseTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 2);
    }

    @Test(timeout=300000L)
    public void innerClassTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        infoflow.getConfig().getAccessPathConfiguration().setUseRecursiveAccessPaths(false);
        infoflow.getConfig().getAccessPathConfiguration().setUseThisChainReduction(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void innerClassTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void innerClassTest2() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        infoflow.getConfig().getAccessPathConfiguration().setUseRecursiveAccessPaths(false);
        infoflow.getConfig().getAccessPathConfiguration().setUseThisChainReduction(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void innerClassTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void innerClassTest3() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        infoflow.getConfig().getAccessPathConfiguration().setUseRecursiveAccessPaths(false);
        infoflow.getConfig().getAccessPathConfiguration().setUseThisChainReduction(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void innerClassTest3()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void innerClassTest4() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void innerClassTest4()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void innerClassTest5() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        infoflow.getConfig().getAccessPathConfiguration().setUseRecursiveAccessPaths(false);
        infoflow.getConfig().getAccessPathConfiguration().setUseThisChainReduction(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void innerClassTest5()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void innerClassTest6() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        infoflow.getConfig().getAccessPathConfiguration().setUseRecursiveAccessPaths(false);
        infoflow.getConfig().getAccessPathConfiguration().setUseThisChainReduction(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void innerClassTest6()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void datastructureTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void datastructureTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void datastructureTest2() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        infoflow.getConfig().getAccessPathConfiguration().setUseRecursiveAccessPaths(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void datastructureTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void staticAccessPathTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void staticAccessPathTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void separatedTreeTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void separatedTreeTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void overwriteAliasedVariableTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void overwriteAliasedVariableTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void overwriteAliasedVariableTest2() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void overwriteAliasedVariableTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void overwriteAliasedVariableTest3() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void overwriteAliasedVariableTest3()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void overwriteAliasedVariableTest4() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void overwriteAliasedVariableTest4()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 2);
    }

    @Test(timeout=300000L)
    public void overwriteAliasedVariableTest5() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void overwriteAliasedVariableTest5()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 2);
    }

    @Test(timeout=300000L)
    public void overwriteAliasedVariableTest6() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void overwriteAliasedVariableTest6()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Ignore(value="fails, looks like a conceptual problem")
    @Test(timeout=300000L)
    public void aliasFlowTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void aliasFlowTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void aliasStrongUpdateTest() {
        String sinkMethod = "<soot.jimple.infoflow.test.HeapTestCode: void leakData(soot.jimple.infoflow.test.HeapTestCode$Data)>";
        String sourceMethod = "<soot.jimple.infoflow.test.HeapTestCode: soot.jimple.infoflow.test.HeapTestCode$Data getSecretData()>";
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void aliasStrongUpdateTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, Collections.singleton("<soot.jimple.infoflow.test.HeapTestCode: soot.jimple.infoflow.test.HeapTestCode$Data getSecretData()>"), Collections.singleton("<soot.jimple.infoflow.test.HeapTestCode: void leakData(soot.jimple.infoflow.test.HeapTestCode$Data)>"));
        Assert.assertTrue((boolean)infoflow.isResultAvailable());
        InfoflowResults map = infoflow.getResults();
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertTrue((boolean)map.containsSinkMethod("<soot.jimple.infoflow.test.HeapTestCode: void leakData(soot.jimple.infoflow.test.HeapTestCode$Data)>"));
        Assert.assertTrue((boolean)map.isPathBetweenMethods("<soot.jimple.infoflow.test.HeapTestCode: void leakData(soot.jimple.infoflow.test.HeapTestCode$Data)>", "<soot.jimple.infoflow.test.HeapTestCode: soot.jimple.infoflow.test.HeapTestCode$Data getSecretData()>"));
    }

    @Test(timeout=300000L)
    public void aliasStrongUpdateTest2() {
        String sinkMethod = "<soot.jimple.infoflow.test.HeapTestCode: void leakData(soot.jimple.infoflow.test.HeapTestCode$Data)>";
        String sourceMethod = "<soot.jimple.infoflow.test.HeapTestCode: soot.jimple.infoflow.test.HeapTestCode$Data getSecretData()>";
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void aliasStrongUpdateTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, Collections.singleton("<soot.jimple.infoflow.test.HeapTestCode: soot.jimple.infoflow.test.HeapTestCode$Data getSecretData()>"), Collections.singleton("<soot.jimple.infoflow.test.HeapTestCode: void leakData(soot.jimple.infoflow.test.HeapTestCode$Data)>"));
        Assert.assertTrue((boolean)infoflow.isResultAvailable());
        InfoflowResults map = infoflow.getResults();
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertTrue((boolean)map.containsSinkMethod("<soot.jimple.infoflow.test.HeapTestCode: void leakData(soot.jimple.infoflow.test.HeapTestCode$Data)>"));
        Assert.assertTrue((boolean)map.isPathBetweenMethods("<soot.jimple.infoflow.test.HeapTestCode: void leakData(soot.jimple.infoflow.test.HeapTestCode$Data)>", "<soot.jimple.infoflow.test.HeapTestCode: soot.jimple.infoflow.test.HeapTestCode$Data getSecretData()>"));
    }

    @Test(timeout=300000L)
    public void aliasStrongUpdateTest3() {
        String sinkMethod = "<soot.jimple.infoflow.test.HeapTestCode: void leakData(soot.jimple.infoflow.test.HeapTestCode$Data)>";
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        this.onlyForwards(infoflow, "not supported backward");
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void aliasStrongUpdateTest3()>");
        ISourceSinkManager ssm = null;
        if (infoflow instanceof Infoflow) {
            ssm = new ISourceSinkManager(){

                public SinkInfo getSinkInfo(Stmt sCallSite, InfoflowManager manager, AccessPath ap) {
                    SootMethod sm;
                    if (sCallSite.containsInvokeExpr() && (sm = sCallSite.getInvokeExpr().getMethod()).getSignature().equals("<soot.jimple.infoflow.test.HeapTestCode: void leakData(soot.jimple.infoflow.test.HeapTestCode$Data)>")) {
                        return new SinkInfo((ISourceSinkDefinition)new MethodSourceSinkDefinition(new SootMethodAndClass(sm)));
                    }
                    return null;
                }

                public SourceInfo getSourceInfo(Stmt sCallSite, InfoflowManager manager) {
                    if (sCallSite instanceof AssignStmt) {
                        AssignStmt assignStmt = (AssignStmt)sCallSite;
                        if (assignStmt.getRightOp().toString().contains("taintedBySourceSinkManager")) {
                            return new SourceInfo(manager.getAccessPathFactory().createAccessPath(assignStmt.getLeftOp(), true));
                        }
                        return null;
                    }
                    return null;
                }

                public void initialize() {
                }
            };
        }
        infoflow.computeInfoflow(appPath, libPath, (IEntryPointCreator)new DefaultEntryPointCreator(epoints), ssm);
        Assert.assertTrue((boolean)infoflow.isResultAvailable());
        InfoflowResults map = infoflow.getResults();
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertTrue((boolean)map.containsSinkMethod("<soot.jimple.infoflow.test.HeapTestCode: void leakData(soot.jimple.infoflow.test.HeapTestCode$Data)>"));
    }

    @Test(timeout=300000L)
    public void arrayLengthAliasTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void arrayLengthAliasTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void arrayLengthAliasTest2() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void arrayLengthAliasTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void arrayLengthAliasTest3() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void arrayLengthAliasTest3()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void arrayLengthAliasTest4() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void arrayLengthAliasTest4()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void taintPrimitiveFieldTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void taintPrimitiveFieldTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void taintPrimitiveFieldTest2() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void taintPrimitiveFieldTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void multiContextTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void multiContextTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 2);
    }

    @Test(timeout=300000L)
    public void recursiveFollowReturnsPastSeedsTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void recursiveFollowReturnsPastSeedsTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void doubleAliasTest1() {
        IInfoflow infoflow = this.initInfoflow(false);
        infoflow.getConfig().getPathConfiguration().setPathReconstructionMode(InfoflowConfiguration.PathReconstructionMode.Fast);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void doubleAliasTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertEquals((long)2L, (long)infoflow.getResults().numConnections());
    }

    @Test(timeout=300000L)
    public void contextTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void contextTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void contextTest2() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void contextTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void contextTest3() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void contextTest3()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void summaryTest1() {
        for (int i = 0; i < 10; ++i) {
            IInfoflow infoflow = this.initInfoflow();
            ArrayList<String> epoints = new ArrayList<String>();
            epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void summaryTest1()>");
            infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
            this.checkInfoflow(infoflow, 1);
        }
    }

    @Test(timeout=300000L)
    public void delayedReturnTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void delayedReturnTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void aliasWithOverwriteTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void aliasWithOverwriteTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void aliasWithOverwriteTest2() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void aliasWithOverwriteTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void aliasWithOverwriteTest3() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void aliasWithOverwriteTest3()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void aliasWithOverwriteTest4() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void aliasWithOverwriteTest4()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void aliasWithOverwriteTest5() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void aliasWithOverwriteTest5()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void innerFieldReductionTestNegative() {
        IInfoflow infoflow = this.initInfoflow();
        this.onlyForwards(infoflow, "We lose the object sensitivity here due to the recursive data structurereduction. See also the comment above the code of innerFieldReductionTestNegative.");
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void innerFieldReductionTestNegative()>");
        infoflow.computeInfoflow(appPath, libPath, (IEntryPointCreator)new SequentialEntryPointCreator(epoints), sources, sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void innerFieldReductionTestNegative2() {
        IInfoflow infoflow = this.initInfoflow();
        this.onlyBackwards(infoflow, "We lose the object sensitivity here due to the recursive data structurereduction. See also the comment above the code of innerFieldReductionTestNegative.");
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void innerFieldReductionTestNegative2()>");
        infoflow.computeInfoflow(appPath, libPath, (IEntryPointCreator)new SequentialEntryPointCreator(epoints), sources, sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void activationStatementTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void activationStatementTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void callSiteCreatesAlias() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void callSiteCreatesAlias()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void lhsNotUpwardsInAliasFlow() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void lhsNotUpwardsInAliasFlow()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void identityStmtIsNotAGoodHandoverPoint() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        infoflow.setTaintPropagationHandler(new TaintPropagationHandler(){

            public void notifyFlowIn(Unit stmt, Abstraction taint, InfoflowManager manager, TaintPropagationHandler.FlowFunctionType type) {
                Assert.assertTrue((boolean)taint.isAbstractionActive());
            }

            public Set<Abstraction> notifyFlowOut(Unit stmt, Abstraction d1, Abstraction incoming, Set<Abstraction> outgoing, InfoflowManager manager, TaintPropagationHandler.FlowFunctionType type) {
                return outgoing;
            }
        });
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void identityStmtIsNotAGoodHandoverPoint()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void testRecursiveAccessPath() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void testRecursiveAccessPath()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void testRemoveEntailedAbstractions1() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void removeEntailedAbstractionsTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertEquals((long)2L, (long)infoflow.getResults().getResultSet().stream().map(res -> res.getSource().getStmt()).distinct().count());
    }

    @Test(timeout=300000L)
    public void testRemoveEntailedAbstractions2() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().getAccessPathConfiguration().setAccessPathLength(1);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void removeEntailedAbstractionsTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertEquals((long)2L, (long)infoflow.getResults().getResultSet().stream().map(res -> res.getSource().getStmt()).distinct().count());
    }

    private class MyTaintWrapper
    extends AbstractTaintWrapper
    implements IReversibleTaintWrapper {
        private MyTaintWrapper() {
        }

        public boolean isExclusiveInternal(Stmt stmt, AccessPath taintedPath) {
            return stmt.containsInvokeExpr() && (stmt.getInvokeExpr().getMethod().getName().equals("foo2") || stmt.getInvokeExpr().getMethod().getName().equals("bar2"));
        }

        public Set<AccessPath> getTaintsForMethodInternal(Stmt stmt, AccessPath taintedPath) {
            if (!stmt.containsInvokeExpr()) {
                return Collections.singleton(taintedPath);
            }
            HashSet<AccessPath> res = new HashSet<AccessPath>();
            res.add(taintedPath);
            if (stmt.getInvokeExpr().getMethod().getName().equals("foo2")) {
                AccessPath ap;
                RefType rt;
                InstanceInvokeExpr iinv = (InstanceInvokeExpr)stmt.getInvokeExpr();
                if (taintedPath.getPlainValue() == iinv.getArg(0)) {
                    rt = (RefType)iinv.getBase().getType();
                    ap = this.manager.getAccessPathFactory().createAccessPath(iinv.getBase(), new SootField[]{rt.getSootClass().getFieldByName("b1")}, true);
                    res.add(ap);
                }
                if (taintedPath.getPlainValue() == iinv.getArg(1)) {
                    rt = (RefType)iinv.getBase().getType();
                    ap = this.manager.getAccessPathFactory().createAccessPath(iinv.getBase(), new SootField[]{rt.getSootClass().getFieldByName("b2")}, true);
                    res.add(ap);
                }
            } else if (stmt.getInvokeExpr().getMethod().getName().equals("bar2")) {
                InstanceInvokeExpr iinv = (InstanceInvokeExpr)stmt.getInvokeExpr();
                if (taintedPath.getPlainValue() == iinv.getArg(0)) {
                    RefType rt = (RefType)iinv.getBase().getType();
                    AccessPath ap = this.manager.getAccessPathFactory().createAccessPath(iinv.getBase(), new SootField[]{rt.getSootClass().getFieldByName("b1")}, true);
                    res.add(ap);
                } else if (taintedPath.getPlainValue() == iinv.getBase()) {
                    DefinitionStmt def = (DefinitionStmt)stmt;
                    AccessPath ap = this.manager.getAccessPathFactory().createAccessPath(def.getLeftOp(), new SootField[]{Scene.v().getSootClass("soot.jimple.infoflow.test.HeapTestCode$A").getFieldByName("b")}, true);
                    res.add(ap);
                }
            }
            return res;
        }

        public Set<Abstraction> getInverseTaintsForMethod(Stmt stmt, Abstraction d1, Abstraction taintedPath) {
            Set<AccessPath> aps = this.getInverseTaintsForMethodInternal(stmt, taintedPath.getAccessPath());
            if (aps == null || aps.isEmpty()) {
                return null;
            }
            HashSet<Abstraction> res = new HashSet<Abstraction>(aps.size());
            for (AccessPath ap : aps) {
                if (ap == taintedPath.getAccessPath()) {
                    res.add(taintedPath);
                    continue;
                }
                res.add(taintedPath.deriveNewAbstraction(ap, stmt));
            }
            return res;
        }

        public Set<AccessPath> getInverseTaintsForMethodInternal(Stmt stmt, AccessPath taintedPath) {
            if (!stmt.containsInvokeExpr()) {
                return Collections.singleton(taintedPath);
            }
            HashSet<AccessPath> res = new HashSet<AccessPath>();
            res.add(taintedPath);
            if (stmt.getInvokeExpr().getMethod().getName().equals("foo2")) {
                InstanceInvokeExpr iinv = (InstanceInvokeExpr)stmt.getInvokeExpr();
                if (iinv.getBase() == taintedPath.getPlainValue()) {
                    AccessPath ap;
                    boolean wholeObjectIsTainted;
                    RefType rt = (RefType)iinv.getBase().getType();
                    boolean bl = wholeObjectIsTainted = taintedPath.getTaintSubFields() && taintedPath.getFragmentCount() == 0;
                    if (wholeObjectIsTainted || taintedPath.firstFieldMatches(rt.getSootClass().getFieldByName("b1"))) {
                        ap = this.manager.getAccessPathFactory().createAccessPath(iinv.getArg(0), true);
                        res.add(ap);
                    }
                    if (wholeObjectIsTainted || taintedPath.firstFieldMatches(rt.getSootClass().getFieldByName("b2"))) {
                        ap = this.manager.getAccessPathFactory().createAccessPath(iinv.getArg(1), true);
                        res.add(ap);
                    }
                }
            } else if (stmt.getInvokeExpr().getMethod().getName().equals("bar2")) {
                AssignStmt assignStmt;
                InstanceInvokeExpr iinv = (InstanceInvokeExpr)stmt.getInvokeExpr();
                if (iinv.getBase() == taintedPath.getPlainValue()) {
                    boolean wholeObjectIsTainted;
                    RefType rt = (RefType)iinv.getBase().getType();
                    boolean bl = wholeObjectIsTainted = taintedPath.getTaintSubFields() && taintedPath.getFragmentCount() == 0;
                    if (wholeObjectIsTainted || taintedPath.firstFieldMatches(rt.getSootClass().getFieldByName("b1"))) {
                        AccessPath ap = this.manager.getAccessPathFactory().createAccessPath(iinv.getArg(0), true);
                        res.add(ap);
                    }
                } else if (stmt instanceof AssignStmt && (assignStmt = (AssignStmt)stmt).getLeftOp() == taintedPath.getPlainValue() && taintedPath.firstFieldMatches(Scene.v().getSootClass("soot.jimple.infoflow.test.HeapTestCode$A").getFieldByName("b"))) {
                    AccessPath ap = this.manager.getAccessPathFactory().createAccessPath(iinv.getBase(), true);
                    res.add(ap);
                    res.remove(taintedPath);
                }
            }
            return res;
        }

        public boolean supportsCallee(SootMethod method) {
            return false;
        }

        public boolean supportsCallee(Stmt callSite) {
            return false;
        }

        public Set<Abstraction> getAliasesForMethod(Stmt stmt, Abstraction d1, Abstraction taintedPath) {
            return null;
        }
    }
}

