/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.junit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.junit.Ignore;
import org.junit.Test;
import soot.RefType;
import soot.Scene;
import soot.SootField;
import soot.SootMethod;
import soot.jimple.DefinitionStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.IInfoflow;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.taintWrappers.AbstractTaintWrapper;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.test.junit.JUnitTests;

public abstract class HeapTestsPtsAliasing
extends JUnitTests {
    @Test(timeout=300000L)
    public void testForEarlyTermination() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void testForEarlyTermination()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void testForLoop() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void testForLoop()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void testForWrapper() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void testForWrapper()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void simpleTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void simpleTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void argumentTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void argumentTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void negativeTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void negativeTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test
    public void doubleCallTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void doubleCallTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void heapTest0() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void methodTest0()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void heapTest1() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        infoflow.getConfig().setMaxThreadNum(1);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void methodTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void heapTest2() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        infoflow.getConfig().setMaxThreadNum(1);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void methodTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void heapTest3() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        infoflow.getConfig().setMaxThreadNum(1);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void methodTest3()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void testExample1() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ForwardBackwardTest: void testMethod()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void testReturn() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void methodReturn()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void testTwoLevels() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void twoLevelTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void multiAliasTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void multiAliasTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void overwriteAliasTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void overwriteAliasTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void arrayAliasTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void arrayAliasTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void functionAliasTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void functionAliasTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void functionAliasTest2() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void functionAliasTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void multiLevelTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void multiLevelTaint()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void multiLevelTest2() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void multiLevelTaint2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void negativeMultiLevelTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void negativeMultiLevelTaint()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    public void negativeMultiLevelTest2() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void negativeMultiLevelTaint2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void threeLevelTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void threeLevelTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void threeLevelShortAPTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        infoflow.getConfig().getAccessPathConfiguration().setAccessPathLength(1);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void threeLevelTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void recursionTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void recursionTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void activationUnitTest1() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void activationUnitTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void activationUnitTest2() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void activationUnitTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void activationUnitTest3() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void activationUnitTest3()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void activationUnitTest4() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void activationUnitTest4()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void activationUnitTest4b() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void activationUnitTest4b()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void activationUnitTest5() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void activationUnitTest5()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void returnAliasTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void returnAliasTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void callPerformanceTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void callPerformanceTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void aliasesTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        infoflow.getConfig().getAccessPathConfiguration().setAccessPathLength(3);
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void testAliases()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void wrapperAliasesTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        infoflow.getConfig().getAccessPathConfiguration().setAccessPathLength(3);
        infoflow.setTaintWrapper((ITaintPropagationWrapper)new AbstractTaintWrapper(){

            public boolean isExclusiveInternal(Stmt stmt, AccessPath taintedPath) {
                return stmt.containsInvokeExpr() && (stmt.getInvokeExpr().getMethod().getName().equals("foo2") || stmt.getInvokeExpr().getMethod().getName().equals("bar2"));
            }

            public Set<AccessPath> getTaintsForMethodInternal(Stmt stmt, AccessPath taintedPath) {
                if (!stmt.containsInvokeExpr()) {
                    return Collections.singleton(taintedPath);
                }
                HashSet<AccessPath> res = new HashSet<AccessPath>();
                res.add(taintedPath);
                if (stmt.getInvokeExpr().getMethod().getName().equals("foo2")) {
                    AccessPath ap;
                    RefType rt;
                    InstanceInvokeExpr iinv = (InstanceInvokeExpr)stmt.getInvokeExpr();
                    if (taintedPath.getPlainValue() == iinv.getArg(0)) {
                        rt = (RefType)iinv.getBase().getType();
                        ap = this.manager.getAccessPathFactory().createAccessPath(iinv.getBase(), new SootField[]{rt.getSootClass().getFieldByName("b1")}, true);
                        res.add(ap);
                    }
                    if (taintedPath.getPlainValue() == iinv.getArg(1)) {
                        rt = (RefType)iinv.getBase().getType();
                        ap = this.manager.getAccessPathFactory().createAccessPath(iinv.getBase(), new SootField[]{rt.getSootClass().getFieldByName("b2")}, true);
                        res.add(ap);
                    }
                } else if (stmt.getInvokeExpr().getMethod().getName().equals("bar2")) {
                    InstanceInvokeExpr iinv = (InstanceInvokeExpr)stmt.getInvokeExpr();
                    if (taintedPath.getPlainValue() == iinv.getArg(0)) {
                        RefType rt = (RefType)iinv.getBase().getType();
                        AccessPath ap = this.manager.getAccessPathFactory().createAccessPath(iinv.getBase(), new SootField[]{rt.getSootClass().getFieldByName("b1")}, true);
                        res.add(ap);
                    } else if (taintedPath.getPlainValue() == iinv.getBase()) {
                        DefinitionStmt def = (DefinitionStmt)stmt;
                        AccessPath ap = this.manager.getAccessPathFactory().createAccessPath(def.getLeftOp(), new SootField[]{Scene.v().getSootClass("soot.jimple.infoflow.test.HeapTestCode$A").getFieldByName("b")}, true);
                        res.add(ap);
                    }
                }
                return res;
            }

            public boolean supportsCallee(SootMethod method) {
                return false;
            }

            public boolean supportsCallee(Stmt callSite) {
                return false;
            }

            public Set<Abstraction> getAliasesForMethod(Stmt stmt, Abstraction d1, Abstraction taintedPath) {
                return null;
            }
        });
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void testWrapperAliases()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void negativeAliasesTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void negativeTestAliases()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void aliasPerformanceTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        infoflow.getConfig().getAccessPathConfiguration().setAccessPathLength(3);
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void aliasPerformanceTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 3);
    }

    @Test(timeout=300000L)
    public void backwardsParameterTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void backwardsParameterTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void longAPAliasTest1() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void longAPAliasTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void simpleFieldTest1() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        infoflow.getConfig().setInspectSources(false);
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void simpleFieldTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Ignore(value="missing context-sensitivity in SPARK")
    @Test(timeout=300000L)
    public void contextTest1() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void contextTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Ignore(value="missing context-sensitivity in SPARK")
    @Test(timeout=300000L)
    public void contextTest2() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void contextTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Ignore(value="missing context-sensitivity in SPARK")
    @Test(timeout=300000L)
    public void contextTest3() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setAliasingAlgorithm(InfoflowConfiguration.AliasingAlgorithm.PtsBased);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.HeapTestCode: void contextTest3()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }
}

