/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.junit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.junit.Ignore;
import org.junit.Test;
import soot.jimple.infoflow.IInfoflow;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.config.IInfoflowConfig;
import soot.jimple.infoflow.taintWrappers.EasyTaintWrapper;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.test.junit.JUnitTests;
import soot.options.Options;

public abstract class ImplicitFlowTests
extends JUnitTests {
    @Override
    protected IInfoflow initInfoflow() {
        IInfoflow infoflow = super.initInfoflow();
        infoflow.getConfig().setImplicitFlowMode(InfoflowConfiguration.ImplicitFlowMode.AllImplicitFlows);
        return infoflow;
    }

    @Test(timeout=300000L)
    public void simpleTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void simpleTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void simpleNegativeTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void simpleNegativeTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void simpleOverwriteTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void simpleOverwriteTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void switchTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void switchTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void convertTest() {
        long timeBefore = System.nanoTime();
        System.out.println("Starting convertTest...");
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().getAccessPathConfiguration().setAccessPathLength(1);
        infoflow.getConfig().setInspectSinks(false);
        infoflow.getConfig().setStaticFieldTrackingMode(InfoflowConfiguration.StaticFieldTrackingMode.None);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void convertTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        System.out.println("convertTest took " + (double)(System.nanoTime() - timeBefore) / 1.0E9 + " seconds");
    }

    @Test(timeout=300000L)
    public void sinkTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void sinkTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void returnTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void returnTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void callTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void callTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void callTest2() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void callTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void negativeCallTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void negativeCallTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void recursionTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void recursionTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void recursionTest2() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void recursionTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void recursionTest3() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void recursionTest3()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void exceptionTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void exceptionTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void exceptionTest2() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void exceptionTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void exceptionTest3() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void exceptionTest3()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void fieldTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void fieldTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void staticFieldTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void staticFieldTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void staticFieldTest2() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void staticFieldTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void staticFieldTest3() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void staticFieldTest3()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void staticFieldTest4() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void staticFieldTest4()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void staticFieldTest5() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void staticFieldTest4()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void integerClassTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void integerClassTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void stringClassTest() {
        long timeBefore = System.nanoTime();
        System.out.println("Starting stringClassTest...");
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().getAccessPathConfiguration().setAccessPathLength(1);
        infoflow.getConfig().setInspectSinks(false);
        infoflow.getConfig().setStaticFieldTrackingMode(InfoflowConfiguration.StaticFieldTrackingMode.None);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void stringClassTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        System.out.println("stringClassTest took " + (double)(System.nanoTime() - timeBefore) / 1.0E9 + " seconds");
    }

    @Test(timeout=300000L)
    @Ignore
    public void conditionalExceptionTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void conditionalExceptionTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void passOverTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void passOverTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void passOverTest2() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void passOverTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void callToReturnTest() throws IOException {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        infoflow.setTaintWrapper((ITaintPropagationWrapper)EasyTaintWrapper.getDefault());
        infoflow.setSootConfig(new IInfoflowConfig(){

            public void setSootOptions(Options options, InfoflowConfiguration config) {
                options.set_include(Collections.emptyList());
                ArrayList<String> excludeList = new ArrayList<String>();
                excludeList.add("java.");
                excludeList.add("javax.");
                options.set_exclude(excludeList);
                options.set_prepend_classpath(false);
                Options.v().set_ignore_classpath_errors(true);
            }
        });
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void callToReturnTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void callToReturnTest2() throws IOException {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        infoflow.setTaintWrapper((ITaintPropagationWrapper)EasyTaintWrapper.getDefault());
        infoflow.setSootConfig(new IInfoflowConfig(){

            public void setSootOptions(Options options, InfoflowConfiguration config) {
                options.set_include(Collections.emptyList());
                ArrayList<String> excludeList = new ArrayList<String>();
                excludeList.add("java.");
                excludeList.add("javax.");
                options.set_exclude(excludeList);
                options.set_prepend_classpath(false);
                Options.v().set_ignore_classpath_errors(true);
            }
        });
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void callToReturnTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void createAliasInFunctionTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void createAliasInFunctionTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void createAliasInFunctionTest2() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void createAliasInFunctionTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void implicitFlowTaintWrapperTest() throws IOException {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        infoflow.setTaintWrapper((ITaintPropagationWrapper)EasyTaintWrapper.getDefault());
        infoflow.setSootConfig(new IInfoflowConfig(){

            public void setSootOptions(Options options, InfoflowConfiguration config) {
                options.set_include(Collections.emptyList());
                ArrayList<String> excludeList = new ArrayList<String>();
                excludeList.add("java.");
                excludeList.add("javax.");
                options.set_exclude(excludeList);
                options.set_prepend_classpath(false);
                Options.v().set_ignore_classpath_errors(true);
            }
        });
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void implicitFlowTaintWrapperTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void implicitFlowTaintWrapperNegativeTest() throws IOException {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        infoflow.setTaintWrapper((ITaintPropagationWrapper)new EasyTaintWrapper(Collections.emptyMap()));
        infoflow.setSootConfig(new IInfoflowConfig(){

            public void setSootOptions(Options options, InfoflowConfiguration config) {
                options.set_include(Collections.emptyList());
                ArrayList<String> excludeList = new ArrayList<String>();
                excludeList.add("java.");
                excludeList.add("javax.");
                options.set_exclude(excludeList);
                options.set_prepend_classpath(false);
                Options.v().set_ignore_classpath_errors(true);
            }
        });
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void implicitFlowTaintWrapperTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void hierarchicalCallSetTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void hierarchicalCallSetTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void conditionalAliasingTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void conditionalAliasingTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void conditionalAliasingTest2() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void conditionalAliasingTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void conditionalAliasingTest3() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void conditionalAliasingTest3()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void testStringConvert() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        infoflow.getConfig().setStaticFieldTrackingMode(InfoflowConfiguration.StaticFieldTrackingMode.None);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodStringConvert()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void afterCallNegativeTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void afterCallNegativeTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void ifInCalleeTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void ifInCalleeTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void activationConditionalTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void activationConditionalTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void classTypeTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void classTypeTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void conditionalReturnTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void conditionalReturnTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void stringObfuscationTest1() {
        IInfoflow infoflow = this.initInfoflow(true);
        infoflow.getConfig().setInspectSinks(false);
        ((EasyTaintWrapper)infoflow.getTaintWrapper()).addMethodForWrapping("soot.jimple.infoflow.test.android.Base64", "java.lang.String encodeToString(byte[])");
        ((EasyTaintWrapper)infoflow.getTaintWrapper()).addIncludePrefix("soot.jimple.infoflow.test.android.");
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void stringObfuscationTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void arrayIndexTest1() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void arrayIndexTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void exceptionTest1() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void exceptionTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void exceptionTest4() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void exceptionTest4()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void userCodeTest1() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        infoflow.getConfig().setCodeEliminationMode(InfoflowConfiguration.CodeEliminationMode.NoCodeElimination);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void userCodeTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void userCodeTest2() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setEnableExceptionTracking(false);
        infoflow.getConfig().setInspectSinks(false);
        infoflow.getConfig().setCodeEliminationMode(InfoflowConfiguration.CodeEliminationMode.NoCodeElimination);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void userCodeTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    @Ignore(value="does not match Soot's model of exceptional unit graphs")
    public void userCodeTest2b() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        infoflow.getConfig().setCodeEliminationMode(InfoflowConfiguration.CodeEliminationMode.NoCodeElimination);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void userCodeTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void nestedIfTest() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setInspectSinks(false);
        infoflow.getConfig().setCodeEliminationMode(InfoflowConfiguration.CodeEliminationMode.NoCodeElimination);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.ImplicitFlowTestCode: void nestedIfTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }
}

