/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.junit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import soot.Body;
import soot.Scene;
import soot.Unit;
import soot.jimple.ReturnStmt;
import soot.jimple.infoflow.IInfoflow;
import soot.jimple.infoflow.entryPointCreators.DefaultEntryPointCreator;
import soot.jimple.infoflow.entryPointCreators.IEntryPointCreator;
import soot.jimple.infoflow.sourcesSinks.manager.DefaultSourceSinkManager;
import soot.jimple.infoflow.sourcesSinks.manager.ISourceSinkManager;
import soot.jimple.infoflow.test.junit.JUnitTests;

public abstract class InFunctionTests
extends JUnitTests {
    private static final String SOURCE_STRING_PARAMETER = "@parameter0: java.lang.String";
    private static final String SOURCE_STRING_PARAMETER2 = "@parameter1: java.lang.String";
    private static final String SOURCE_INT_PARAMETER = "@parameter0: int";
    private static final String SOURCE_INT_PARAMETER2 = "@parameter1: int";

    private String getReturnValueName(String epoint) {
        Body body = Scene.v().getMethod(epoint).getActiveBody();
        for (Unit b : body.getUnits()) {
            if (!(b instanceof ReturnStmt)) continue;
            ReturnStmt ret = (ReturnStmt)b;
            return ret.getOp().toString();
        }
        throw new IllegalArgumentException(epoint + " has no return with operand.");
    }

    @Test(timeout=300000L)
    public void inFunctionTest1() {
        IInfoflow infoflow = this.initInfoflow(true);
        String epoint = "<soot.jimple.infoflow.test.InFunctionCode: java.lang.String infSourceCode1(java.lang.String)>";
        DefaultSourceSinkManager ssm = new DefaultSourceSinkManager((Collection)sources, (Collection)sinks);
        ssm.setParameterTaintMethods(Collections.singletonList(epoint));
        ssm.setReturnTaintMethods(Collections.singletonList(epoint));
        infoflow.computeInfoflow(appPath, libPath, epoint, (ISourceSinkManager)ssm);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetween(this.getReturnValueName(epoint), SOURCE_STRING_PARAMETER));
    }

    @Test(timeout=300000L)
    public void inFunctionTest2() {
        IInfoflow infoflow = this.initInfoflow(true);
        String epoint = "<soot.jimple.infoflow.test.InFunctionCode: java.lang.String infSourceCode2(java.lang.String)>";
        DefaultSourceSinkManager ssm = new DefaultSourceSinkManager((Collection)sources, (Collection)sinks);
        ssm.setParameterTaintMethods(Collections.singletonList(epoint));
        ssm.setReturnTaintMethods(Collections.singletonList(epoint));
        infoflow.computeInfoflow(appPath, libPath, epoint, (ISourceSinkManager)ssm);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void inFunctionTest3() {
        IInfoflow infoflow = this.initInfoflow(true);
        String epoint = "<soot.jimple.infoflow.test.InFunctionCode: java.lang.String infSourceCode3(java.lang.String)>";
        DefaultSourceSinkManager ssm = new DefaultSourceSinkManager((Collection)sources, (Collection)sinks);
        ssm.setParameterTaintMethods(Collections.singletonList(epoint));
        ssm.setReturnTaintMethods(Collections.singletonList(epoint));
        infoflow.computeInfoflow(appPath, libPath, epoint, (ISourceSinkManager)ssm);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetween(this.getReturnValueName(epoint), SOURCE_STRING_PARAMETER));
    }

    @Test(timeout=300000L)
    public void inFunctionTest4() {
        IInfoflow infoflow = this.initInfoflow(true);
        Assert.assertNotNull((Object)infoflow.getTaintWrapper());
        ArrayList<String> epoint = new ArrayList<String>();
        epoint.add("<soot.jimple.infoflow.test.InFunctionCode: void setTmp(java.lang.String)>");
        epoint.add("<soot.jimple.infoflow.test.InFunctionCode: java.lang.String foo(java.lang.String,java.lang.String)>");
        DefaultSourceSinkManager ssm = new DefaultSourceSinkManager((Collection)sources, (Collection)sinks);
        ssm.setParameterTaintMethods(epoint);
        ssm.setReturnTaintMethods(epoint);
        infoflow.computeInfoflow(appPath, libPath, (IEntryPointCreator)new DefaultEntryPointCreator(epoint), (ISourceSinkManager)ssm);
        Assert.assertFalse((boolean)infoflow.getResults().isEmpty());
        Assert.assertEquals((long)3L, (long)infoflow.getResults().numConnections());
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetween(this.getReturnValueName("<soot.jimple.infoflow.test.InFunctionCode: java.lang.String foo(java.lang.String,java.lang.String)>"), SOURCE_STRING_PARAMETER));
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetween(this.getReturnValueName("<soot.jimple.infoflow.test.InFunctionCode: java.lang.String foo(java.lang.String,java.lang.String)>"), SOURCE_STRING_PARAMETER2));
    }

    @Test(timeout=300000L)
    public void parameterFlowTest() {
        IInfoflow infoflow = this.initInfoflow(true);
        ArrayList<String> epoint = new ArrayList<String>();
        epoint.add("<soot.jimple.infoflow.test.InFunctionCode: int paraToParaFlow(int,int,soot.jimple.infoflow.test.InFunctionCode$DataClass,soot.jimple.infoflow.test.InFunctionCode$DataClass)>");
        DefaultSourceSinkManager ssm = new DefaultSourceSinkManager((Collection)sources, (Collection)sinks);
        ssm.setParameterTaintMethods(epoint);
        ssm.setReturnTaintMethods(epoint);
        infoflow.computeInfoflow(appPath, libPath, (IEntryPointCreator)new DefaultEntryPointCreator(epoint), (ISourceSinkManager)ssm);
        Assert.assertNotNull((Object)infoflow.getResults());
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetween("b", SOURCE_INT_PARAMETER2));
        Assert.assertFalse((boolean)infoflow.getResults().isPathBetween("b", SOURCE_INT_PARAMETER));
    }
}

