/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.junit;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import soot.G;
import soot.jimple.infoflow.AbstractInfoflow;
import soot.jimple.infoflow.BackwardsInfoflow;
import soot.jimple.infoflow.IInfoflow;
import soot.jimple.infoflow.Infoflow;
import soot.jimple.infoflow.config.ConfigForTest;
import soot.jimple.infoflow.config.IInfoflowConfig;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.taintWrappers.EasyTaintWrapper;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.test.base.AbstractJUnitTests;

public abstract class JUnitTests
extends AbstractJUnitTests {
    protected static String appPath;
    protected static String libPath;
    protected static List<String> sinks;
    protected static final String sink = "<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>";
    protected static final String sinkInt = "<soot.jimple.infoflow.test.android.ConnectionManager: void publish(int)>";
    protected static final String sinkBoolean = "<soot.jimple.infoflow.test.android.ConnectionManager: void publish(boolean)>";
    protected static final String sinkDouble = "<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.Double)>";
    protected static List<String> sources;
    protected static final String sourceDeviceId = "<soot.jimple.infoflow.test.android.TelephonyManager: java.lang.String getDeviceId()>";
    protected static final String sourceIMEI = "<soot.jimple.infoflow.test.android.TelephonyManager: int getIMEI()>";
    protected static final String sourceIMSI = "<soot.jimple.infoflow.test.android.TelephonyManager: int getIMSI()>";
    protected static final String sourcePwd = "<soot.jimple.infoflow.test.android.AccountManager: java.lang.String getPassword()>";
    protected static final String sourceUserData = "<soot.jimple.infoflow.test.android.AccountManager: java.lang.String[] getUserData(java.lang.String)>";
    protected static final String sourceBundleGet = "<soot.jimple.infoflow.test.android.Bundle: java.lang.Object get(java.lang.String)>";
    protected static final String sourceLongitude = "<soot.jimple.infoflow.test.android.LocationManager: double getLongitude()>";
    protected static final String sourceLocation = "<soot.jimple.infoflow.test.android.LocationManager: soot.jimple.infoflow.test.android.Location getLastKnownLocation()>";

    @BeforeClass
    public static void setUp() throws IOException {
        File f = JUnitTests.getInfoflowRoot();
        StringBuilder appPathBuilder = new StringBuilder();
        JUnitTests.addTestPathes(f, appPathBuilder);
        File fi = new File(f, "../soot-infoflow");
        if (!fi.getCanonicalFile().equals(f.getCanonicalFile())) {
            JUnitTests.addTestPathes(fi, appPathBuilder);
        }
        if (!(fi = new File(f, "../soot-infoflow-summaries")).getCanonicalFile().equals(f.getCanonicalFile())) {
            JUnitTests.addTestPathes(fi, appPathBuilder);
        }
        if ((fi = new File("soot-infoflow")).exists()) {
            JUnitTests.addTestPathes(fi, appPathBuilder);
        }
        if ((fi = new File("soot-infoflow-summaries")).exists()) {
            JUnitTests.addTestPathes(fi, appPathBuilder);
        }
        appPath = appPathBuilder.toString();
        StringBuilder libPathBuilder = new StringBuilder();
        JUnitTests.addRtJarPath(libPathBuilder);
        libPath = libPathBuilder.toString();
        if (libPath.isEmpty()) {
            throw new RuntimeException("Could not find rt.jar!");
        }
        JUnitTests.initializeSourceSinks();
    }

    protected static void initializeSourceSinks() {
        sources = new ArrayList<String>();
        sources.add(sourcePwd);
        sources.add(sourceUserData);
        sources.add(sourceDeviceId);
        sources.add(sourceIMEI);
        sources.add(sourceIMSI);
        sources.add(sourceBundleGet);
        sources.add(sourceLongitude);
        sources.add(sourceLocation);
        sinks = new ArrayList<String>();
        sinks.add(sink);
        sinks.add(sinkInt);
        sinks.add(sinkBoolean);
        sinks.add(sinkDouble);
    }

    @Before
    public void resetSootAndStream() throws IOException {
        G.reset();
        System.gc();
    }

    protected void checkInfoflow(IInfoflow infoflow, int resultCount) {
        if (infoflow.isResultAvailable()) {
            InfoflowResults map = infoflow.getResults();
            Assert.assertEquals((long)resultCount, (long)map.size());
            Assert.assertTrue((map.containsSinkMethod(sink) || map.containsSinkMethod(sinkInt) || map.containsSinkMethod(sinkBoolean) || map.containsSinkMethod(sinkDouble) ? 1 : 0) != 0);
            Assert.assertTrue((map.isPathBetweenMethods(sink, sourceDeviceId) || map.isPathBetweenMethods(sink, sourceIMEI) || map.isPathBetweenMethods(sinkDouble, sourceIMEI) || map.isPathBetweenMethods(sink, sourcePwd) || map.isPathBetweenMethods(sink, sourceBundleGet) || map.isPathBetweenMethods(sinkInt, sourceDeviceId) || map.isPathBetweenMethods(sinkInt, sourceIMEI) || map.isPathBetweenMethods(sinkInt, sourceIMSI) || map.isPathBetweenMethods(sinkInt, sourceLongitude) || map.isPathBetweenMethods(sinkBoolean, sourceDeviceId) || map.isPathBetweenMethods(sinkDouble, sourceLongitude) || map.isPathBetweenMethods(sinkDouble, sourceLocation) ? 1 : 0) != 0);
        } else {
            Assert.fail((String)"result is not available");
        }
    }

    protected void negativeCheckInfoflow(IInfoflow infoflow) {
        if (infoflow.isResultAvailable()) {
            InfoflowResults map = infoflow.getResults();
            Assert.assertEquals((long)0L, (long)map.size());
            Assert.assertFalse((boolean)map.containsSinkMethod(sink));
            Assert.assertFalse((boolean)map.containsSinkMethod(sinkInt));
        }
    }

    protected IInfoflow initInfoflow() {
        return this.initInfoflow(false);
    }

    protected IInfoflow initInfoflow(boolean useTaintWrapper) {
        AbstractInfoflow result = this.createInfoflowInstance();
        result.setThrowExceptions(true);
        ConfigForTest testConfig = new ConfigForTest();
        result.setSootConfig((IInfoflowConfig)testConfig);
        if (useTaintWrapper) {
            try {
                EasyTaintWrapper easyWrapper = EasyTaintWrapper.getDefault();
                result.setTaintWrapper((ITaintPropagationWrapper)easyWrapper);
            }
            catch (IOException e) {
                System.err.println("Could not initialized Taintwrapper:");
                e.printStackTrace();
            }
        }
        return result;
    }

    protected abstract AbstractInfoflow createInfoflowInstance();

    protected void onlyBackwards(IInfoflow infoflow, String message) {
        Assume.assumeTrue((String)("Test is only applicable on backwards analysis: " + message), (boolean)(infoflow instanceof BackwardsInfoflow));
    }

    protected void onlyForwards(IInfoflow infoflow, String message) {
        Assume.assumeTrue((String)("Test is only applicable on forwards analysis: " + message), (boolean)(infoflow instanceof Infoflow));
    }

    public static File getInfoflowRoot() throws IOException {
        File testRoot = new File(".").getCanonicalFile();
        if (!new File(testRoot, "src").exists()) {
            File subFolder = new File(testRoot, "soot-infoflow");
            testRoot = subFolder.exists() ? subFolder : new File(testRoot.getParentFile(), "soot-infoflow");
        }
        if (!new File(testRoot, "src").exists()) {
            throw new RuntimeException(String.format("Test root not found in %s", testRoot.getAbsolutePath()));
        }
        return testRoot;
    }
}

