/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.junit;

import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.infoflow.memory.MemoryWarningSystem;

public class MemoryWatcherTest {
    private static final Logger logger = LoggerFactory.getLogger(MemoryWatcherTest.class);
    private static final int MEMORY_STEP_SMALL = 2048;
    private static final int MEMORY_STEP_BIG = 0x6400000;
    List<byte[]> memoryLeak = new LinkedList<byte[]>();
    double[] thresholds = new double[]{0.1, 0.3, 0.5, 0.8};
    boolean[] wsReached = new boolean[this.thresholds.length];
    String fail;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void runMemoryWatcherTest() {
        try {
            MemoryWarningSystem[] ws = new MemoryWarningSystem[this.thresholds.length];
            for (int i = 0; i < this.thresholds.length; ++i) {
                final int current = i;
                ws[i] = new MemoryWarningSystem();
                ws[i].setWarningThreshold(this.thresholds[i]);
                ws[i].addListener(new MemoryWarningSystem.OnMemoryThresholdReached(){

                    public void onThresholdReached(long usedMemory, long maxMemory) {
                        logger.info("Threshold reached: " + MemoryWatcherTest.this.thresholds[current] + " with " + usedMemory);
                        MemoryWatcherTest.this.wsReached[current] = true;
                        for (int i = current + 1; i < MemoryWatcherTest.this.wsReached.length; ++i) {
                            if (!MemoryWatcherTest.this.wsReached[i]) continue;
                            MemoryWatcherTest.this.fail = "Threshold for " + i + " was reached before " + current + ", although threshold " + MemoryWatcherTest.this.thresholds[current] + " < " + MemoryWatcherTest.this.thresholds[i];
                        }
                    }
                });
            }
            while (!this.allHandlersCalled()) {
                this.leakMemory();
            }
        }
        finally {
            this.memoryLeak.clear();
            if (this.fail != null) {
                Assert.fail((String)this.fail);
            }
        }
    }

    private void leakMemory() {
        for (long i = 0L; i < 0x6400000L; i += 2048L) {
            this.memoryLeak.add(new byte[2048]);
        }
        long used = MemoryWarningSystem.findTenuredGenPool().getUsage().getUsed();
        logger.info("Leaking " + (double)((long)this.memoryLeak.size() * 2048L) / 1024.0 / 1024.0 + " MiB, in tenured gen pool " + (double)used / 1024.0 / 1024.0 + " MiB");
    }

    private boolean allHandlersCalled() {
        for (boolean b : this.wsReached) {
            if (b) continue;
            return false;
        }
        return true;
    }
}

